proc(2) = refine(bcp,bct,x,n);
@
  Refine turning point dates
  mww, 7/1/91
  The original dates are bcp (peaks) and bct (troughs)
  These are refined using the series x.  The new dates are
  those highest (for peaks) or lowest (for troughs) which are
  within  n periods of the old dates.

  Notes, peaks and troughs must alternate, and this is checked and
  the dates modified if necessary
@

local bcpn, i, d, t, b, bctn, s, d1, d2, m, xpad;

@ Pad X with n extra points at beginning and end @
xpad=(.99999*x[1,1]*ones(n,1))|x|(.99999*x[rows(x),1]*ones(n,1));

"Refining turning point dates...";;

@ For each peak date find highest  n months @
bcpn=bcp;
i=1; do while i <= rows(bcp);
  d=bcp[i,1]; t=seqa(-n,1,2*n+1);
   b=sortc(xpad[n+d-n:n+d+n,1]~t,1);
   @ Check for Ties -- Choose latest of the ties @
   b=selif(b,b[.,1].==b[rows(b),1]);
   bcpn[i,1]=d+maxc(b[.,2]);
i=i+1; endo;

@ For each trough date find lowest in Spencer curve  5 months @
bctn=bct;
i=1; do while i <= rows(bct);
  d=bct[i,1]; t=seqa(-n,1,2*n+1);
   b=sortc(xpad[n+d-n:n+d+n,1]~t,1);
   @ Check for Ties -- Choose latest of the ties @
   b=selif(b,b[.,1].==b[1,1]);
   bctn[i,1]=d+maxc(b[.,2]);
i=i+1; endo;

"  Done";print;

@ Make Sure Dates Alternate @
@ {bcpn,bctn}=alter2(bcpn,bctn,x); @

retp(bcpn,bctn);
endp;

