/* ht_reg.prc
   Compute regression of y onto x  and y onto (x,z)
   let b1 and b2 denote the coefficients on x in these two regressions
   test whether b1=b2
   
   hetero-robust inference

   
 */
 proc(6) = ht_reg(y,x,z);
 local b,w,u,t, k, n, sxx, suu, sxxi, suui, b1hat, b2hat, e1, e2, xe, ue, sxexe, sueue, sxeue, vb1, vb2, vb1b2, vdif, dif;

 
 t=rows(x);
 k=cols(x);
 n=cols(y);
 
 @ let w = MzY and u=MzX @
 b=y/z;
 w=y-z*b;
 b=x/z;
 u=x-z*b;
 
 
 sxx=x'x/t;
 suu=u'u/t;
 sxxi=invpd(sxx);
 suui=invpd(suu);
 
 b1hat=y/x;
 b2hat=w/u;
 e1=y-x*b1hat;
 e2=w-u*b2hat;
 xe=x.*e1;
 ue=u.*e2;
 sxexe=xe'xe/t;
 sueue=ue'ue/t;
 sxeue=xe'ue/t;
 vb1=sxxi*sxexe*sxxi/(t-k);
 vb2=suui*sueue*suui/(t-k);
 vb1b2=sxxi*sxeue*suui/(t-k);
 vdif=vb1+vb2-vb1b2-vb1b2';
 dif=b1hat-b2hat;
 
 retp(b1hat,b2hat,dif,vb1,vb2,vdif);
endp;

 
