/* mult_Reg(y,x)
   Compute multivariate regression of y onto x
   error covariance matrix is computed using HeteroRobust SE
   Same x's in all equation
   
   y is txn
   x is txk
   b is (nk)x1 ... 
     b = vec(b1' b2' ... bn')'
   vb is (nk) x (nk)
   
   vbr is hetero-robust
   bnnr is homo-only
   
 */
 proc(4) = mult_reg(y,x);
 local t, k, n, sxx, sxy, sxx_inv, b, e, i, h, tmp, vbr, vbnr, sige;
 t=rows(x);
 k=cols(x);
 n=cols(y);
 sxx=x'x/t;
 sxy=x'y/t;
 sxx_inv=invpd(sxx);
 b=sxx_inv*sxy;
 e=y-x*b;
 b=vec(b);
 i=1; do while i <= t;
  if i .== 1;
   h=(e[i,.]'e[i,.]).*.(x[i,.]'x[i,.]);
  else;
   h=h+(e[i,.]'e[i,.]).*.(x[i,.]'x[i,.]);
  endif;
 i=i+1; endo;
 h=h/(t-k);
 tmp=eye(n).*.sxx_inv;
 vbr=tmp*h*tmp;
 vbr=vbr/t;
 
 sige=e'e/(t-k);
 vbnr=sige.*.sxx_inv;
 vbnr=vbnr/t;
 
 retp(b,vbnr,vbr,sige);
endp;
 