proc(3) = sw_parm;

local iota_p, bet, gam, sig_e, squig_p, eps_p, phi_p, b, pi_1, pi_2, pi_3;

 @ Compute NK PC parameters for SW model from their parameter values @
 iota_p = 0.228354019115349  ;
 squig_p = 0.656266260297550  ;
 eps_p = 10; @ Calibrated @
 phi_p = 1.614979587976331 ; @ Check called PHI in Table @

/*
 bet = 1/((1/100)+1);
 gam = 1.004;  @ Check @
 sig_e = 1.39;
 b = bet*(gam^(1-sig_e));
*/
 b =    0.9978;

 pi_1 = iota_p/(1+b*iota_p);
 pi_2 = b/(1+b*iota_p);
 pi_3 = (1/(1+b*iota_p))*((1-b*squig_p)*(1-squig_p)/(squig_p*((phi_p-1)*eps_p+1)));
 
 /*
 format /rd 10,8;
 "b";;b;
 "pi_1";pi_1;
 "pi_2";pi_2;
 "pi_3";pi_3;
 */
 
retp(pi_1,pi_2, pi_3);
endp;

