/* -------------------------------------------------
 CALENDAR.PRC          JHS 9/19/95
 create calendar matrices
   inputs:
    y1, p1 = first year, subperiod (eg month) for calendar
    y2, p2 = final year, subperiod (eg month) for calendar
    nper   = number of years per period (eg 12) 
*/
proc (4)=calendar(y1,p1,y2,p2,nper);
 local nobs,yno,pno,calascii,calreal,calenrv,calrv,calmat;
 nobs=nper*(y2-y1) + (p2-p1+1);
 calreal=y1+(p1+seqa(0,1,nobs)-1)/nper;
   yno=floor(calreal+.001);
   pno=fix(nper*(calreal-floor(calreal+.001)) +1.001);
 calascii=ftocv(yno,2,0) $+ ":" $+ ftocv(pno,2,0);
 calmat=yno~pno;
 calenrv= zeros((y1-1)*nper+p1-1,1) |
          seqa(1,1,(y2-y1+2)*nper);
 calrv=reshape(calenrv,y2,nper);
retp(calascii,calreal,calrv,calmat);
endp;
@ -------------------------------------------------@
