proc(1) = bcd_pline(b,calvec,icolor,iline_type);
local np, p1, m2;

/* Colors 
0 Black
1 Blue
2 Green 
3 Cyan
4 Red
5 Magenta
6 Brown
7 Grey
8 Dark Grey
9 Light Blue
10 Light Green
11 Light Cyan
12 Light Red
13 Light Magenta
14 Yellow
15 White

iline_type
1 Dashed
2 Dittoed
3 short dashes
4 closely spaced dots
5 dots and dashes
6 solid

*/


np=sumc(b);               @ Number of Peaks and Troughs @
p1=selif(calvec,b);
m2=ones(np,1);            @ Col. 1 of m2=1=>lines in plot coordinates @
m2=m2~ones(np,1).*iline_type;      @ Col. 2 of m2=2=>dashed lines @
m2=m2~p1;                 @ Col. 3 => starting point in x-coord. @
m2=m2~ones(np,1).*(90);   @ Col. 4 => starting point in y-coord. @
m2=m2~p1;                 @ Col. 5 => ending point in x-coord. @
m2=m2~ones(np,1).*(-90);  @ Col. 6 => ending point in y-coord. @
m2=m2~ones(np,1);         @ Col. 7 => new curve @
m2=m2~ones(np,1)*icolor;       @ Col. 8 => color @
m2=m2~zeros(np,1);        @ Col. 9 => line thickness @

retp(m2);
endp;
