proc(1) = dfgls(y,nar);

/* -- df, mu and tau statistics with gls detrending
 y -- data
 nar -- number of lags of y (level) in augmenting
*/

local t, dftau, dy, rho, xy, xx, mu, x, z, xxi, beta, ssr, s2, b, vb, i;
local dfmu, yrho, xcrho, xtrho, trnd, mut, y1, y2, dy1, dy2, x1, x2, c;

t=rows(y);

dftau=miss(zeros(1,2),0);
if nar .< 1;
 retp(dftau);
elseif t .< nar+10;
 retp(dftau);
elseif ismiss(y);
 retp(dftau);
endif;

@ -- GLS estimate of constant term -- @
c=-7;
rho=(1+c/t);
yrho=y[1]|(y[2:t]-rho*y[1:t-1]);  @ Quasi Differenced Y series @
xcrho=1|((1-rho)*ones(t-1,1));    @ Quasi Difference Constant @
mu=(xcrho'yrho)/(xcrho'xcrho);    @ GLS  mu @

c=-13.5;
rho=(1+c/t);
yrho=y[1]|(y[2:t]-rho*y[1:t-1]);  @ Quasi Differenced Y series @
xcrho=1|((1-rho)*ones(t-1,1));    @ Quasi Difference Constant @
trnd=seqa(1,1,t);
xtrho=trnd[1]|(trnd[2:t]-rho*trnd[1:t-1]);  @ Quasi Differenced trend @
x=xcrho~xtrho;
mut=(invpd(x'x))*(x'yrho);        @ GLS mu and trend @


@ -- detrend y -- @
y1=y-mu*ones(t,1);                @ GLS Demeaned @
y2=y-(ones(t,1)~trnd)*mut;        @ GLS Detrended @
dy1=miss(zeros(t,1),0);
dy2=miss(zeros(t,1),0);
dy1[2:t]=y1[2:t]-y1[1:t-1];
dy2[2:t]=y2[2:t]-y2[1:t-1];

@ -- Compute ADF statistic -- @
x1=miss(zeros(t,nar),0);
x2=miss(zeros(t,nar),0);
x1[2:t,1]=y1[1:t-1];
x2[2:t,1]=y2[1:t-1];
i=1; do while i <= nar-1;
 x1[i+1:t,i+1]=dy1[1:t-i];
 x2[i+1:t,i+1]=dy2[1:t-i];
i=i+1; endo;
z=packr(y1~x1);
y=z[.,1];
x=z[.,2:cols(z)];
xxi=invpd(x'x);
xy=x'y;
beta=xxi*xy;
ssr=(y'y)-(xy)'beta;
s2=ssr/(rows(y)-cols(x));
b=beta[1];
vb=s2*xxi[1,1];
dfmu=(b-1)/(sqrt(vb));

z=packr(y2~x2);
y=z[.,1];
x=z[.,2:cols(z)];
xxi=invpd(x'x);
xy=x'y;
beta=xxi*xy;
ssr=(y'y)-(xy)'beta;
s2=ssr/(rows(y)-cols(x));
b=beta[1];
vb=s2*xxi[1,1];
dftau=(b-1)/(sqrt(vb));

retp(dfmu~dftau);

endp;