proc(1) = psi_compute(t,q,itrend);

/* Compute DCT
   Input
   		   t = sample size
   		   q = number of terms to include for demeaned version
   		       (q-1 are computed for detrended version)
   		   itrend = 1 (demean); 2 (detrend);   
   output
         psi = demeaned or detrended cosine transform

*/

 local psi,fvec,tvec,svec,dct,fvec_2t,ljt,z,zzi,b,dct_t,ef_t,mjt,avec,i,sgn,anum,om,tmp;
 psi=miss(0,0);
 @ For Demeaned Series @
 fvec=pi*seqa(1,1,q);   
 tvec=seqa(0.5,1,t);         
 svec=tvec./t;
 dct=sqrt(2)*cos(svec.*fvec');  @ Note: This is the dct @
 dct=dct./(t.^0.5);
 fvec_2t=fvec./(2*t);
 ljt=sin(fvec_2t)./fvec_2t;

 if itrend .== 1;
  psi=dct.*ljt';
 elseif itrend .== 2;
  @ Compute Detrended versions of DCT @
  z=ones(t,1)~seqa(1,1,t);
  zzi=invpd(z'z);
  b=zzi*(z'dct);
  dct_t=dct-z*b;
  @ Compute asymptotic eigenfunctions for detrended random walk -- discarding first two @
  ef_t=dct_t;               @ Note ... even number columns of ef_t are the same as dct_t, same as dct @
  mjt=ljt;
  load avec[]=magic_as.asc; @ Odd numbered entries for are sin(a*(s-0.5)) where s = t/T (here I use s=(t-0.5)/T for consistency with DCT) @ 
  i=3; do while i <= q;
   sgn=(-1).^((i+1)/2);
   anum=(i-1)/2;
   om=avec[anum];
   ef_t[.,i]=sgn*sqrt(2*om/(om-sin(om)))*(sin((svec-0.5*ones(t,1))*om)/(t.^0.5));
   tmp=om/(2*t);
   mjt[i]=sin(tmp)/tmp;
  i=i+2; endo;
  b=zzi*(z'ef_t);
  ef_t=ef_t-z*b;         @ This imposes exact orthogonality for this value of T @
  ef_t=ef_t[.,2:cols(ef_t)]; @ Drop first column of ef_t and dct_t ... start at frequency 2*pi/t @
  mjt=mjt[2:rows(mjt)];
  psi=ef_t.*mjt';
 endif;
 retp(psi);
endp;
