proc (3) = csr(&mconv,A,B,CF,nf,nleads);
     local H1,ny,nd,Bff,G,H,mconv:proc;

@ CSR.PRC: classical state reduction program
  inputs: A,B,CF,nf,nleads
  outputs: A,B,CF

  The following program solves a classical state reduduction
  problem for the dynamic system of the form:
    A Ey(t+1)|I(t) = B y(t) + C(F) Ex(t)|I(t)
  with the posited structure

   | 0  0   | |Ef(t+1)|I(t)|   |Bff   Bfd| |f(t)|    |Cf(F)|
   |        | |            | = |         | |    |  + |     |  Ex(t)|I(t)
   |Adf Add | |Ed(t+1)|I(t)|   |Bdf   Bdd| |d(t)|    |Cd(F)|

  where Bff is a nonsingular nf x nf matrix; f(t) is the first nf
  elements of y(t) and d(t) is the last nd=ny-nf elements of y(t).@

ny=rows(A);
nd=ny-nf;

@ We compute the state reduction using a transformation T(F) = G*F+H
  such that the transformed system is in the form:

   | 0  0 | |Ef(t+1)|I(t)|   |I     NU | |f(t)|    |CCf(F)|
   |      | |            | = |         | |    |  + |      |  Ex(t)|I(t)
   |0  AA | |Ed(t+1)|I(t)|   |0     BB | |d(t)|    |CCd(F)|

  That is, the transformed system has specified control variables and
  state variables.  We do not require that AA is invertible, so that the
  current program can be used in a singular systems context.

  Set up the matrices of the transformation:
   G = | 0      0 |         H = | I/Bff     0  |
       |Adf/Bff 0 |             |-Bdf/Bff   I  | @

Bff=B[1:nf,1:nf];
G = zeros(ny,ny);
G[nf+1:ny,1:nf]=A[nf+1:ny,1:nf]*inv(Bff);

H = eye(ny);
H[1:nf,1:nf]   =  eye(nf)*inv(Bff);
H[nf+1:ny,1:nf]= -B[nf+1:ny,1:nf]*inv(Bff);

@ Utilize the transformation to produce new values of the matrices A and B
  in the desired form;@

A = H*A-G*B;
B = H*B;

@ make the new C(F) polynomial CC(F) = T(F)*C(F): @

CF = mconv(H~G,CF,1,nleads);

retp(A,B,CF);
endp;
