proc (3) = lus(W,bstar,ns,np);
  local l,lcmu,nus,rw,emod,tol,eind,luss,mus,i,j,temp;

/*
  LUS.prc, (last revised 7/6/94, mww)
  PROC to determine unstable eigenvalues and corresponding left eigen-
  vectors of the matrix W.

  Consider the equation: E s(t+1)|I(t) = W s(t) + PSI2(F) E x(t)|I(t)

  The right eigenvectors of W are a matrix R such that W*R=R*MU
  The left  eigenvectors of W are a matrix L such that L*W=MU*L
  where in each case MU is the diagonal matrix of eigenvalues

*/

tol=1.0e-8;
rw=rows(w);
{lcmu,L}=eigv(W');

@ Find Unstable Eigenvalues and corresponding Eigenvectors @
emod = abs(lcmu);
emod = emod~seqa(1,1,rw);
eind = (bstar.*emod[.,1]) .> (1.0+tol);

nus=sumc(eind);

if nus ./= (ns-np);
  print "the number of forward variables is not as suggested by nd-np";
  print "PROCESSING STOPS in LUS.prc";
  stop;
endif;

if nus .== 0;
  print "no unstable eigenvalues in LUS.prc";
  retp(nus,0,0);
endif;

emod = selif(emod,eind);
mus=zeros(nus,1);
luss=zeros(rw,nus);
i=1; do while i <= nus;
 j=emod[i,2];
 mus[i]=lcmu[j];
 luss[.,i]=l[.,j];
i=i+1; endo;
luss=luss';
luss=conj(luss);

temp=luss[.,1:rows(luss)];
if rank(temp) ./= rows(luss);
  "Rank Condition Fails in LUS.PRC";
  "PROCESSING STOPS";
endif;

retp(nus,luss,mus);
endp;
