proc (3) = mdrkw(B,CF,Q,RHO,L,MU,K,ns,np,nshock);

/* mdrkw.prc, 7/6/94 mww (revision of rjk's mdrkw.g)
   This program "Solves" the dynamic LRE model after it
   has been transformed into standard form.  On input
   the model has the structure:

   y(t)=K*z(t), with

   A Ez(t+1)|I(t) = B z(t) + C(F) Ex(t)|I(t),

   with nx the dimension of x(t).  In partitioned form, this equation
   is written as:

   | 0  0  | |Ef(t+1)|I(t)|   | I     V | |f(t)|    |PSI1(F)|
   |       | |            | = |         | |    |  + |       |  Ex(t)|I(t)
   | 0  I  | |Ed(t+1)|I(t)|   | 0     W | |d(t)|    |PSI2(F)|

  with ns the dimension of d(t) and with W non-singular. (Thus, there is
  no need to input the matrix A.)  The variable NP contains the number of
  predetermined variables in z(t).

  L denotes the left eigenvectors of W associated with unstable
  eigenvalues.  These are given by MU.  That is:
  L*W=MU*L, where MU is the diag matrix of unstable eigenvalues

  The exogenous variables, x(t), follow the "forcing" process:

  x(t) = Q*m(t)
  m(t) = RHO*m(t-1) + G*e(t)

  where G = |eye(nshock) |
            | 0          |

  On Output the system matrices Pii and M from the represtentation:

    y(t)=pii*s(t)
    s(t+1)=m*s(t) + H*e(t);

are Produced.  Where Y(t) is padded out with the exogenous variables

*/
local nx,ny,nf,nlead,j,R,PHI,nus,q1,theta,IRHO,i,lamk,lamdr;
local BT,B2,B3,nk,PII,ndrv,M,H;

  @ -- Some dimensions -- @
  nx=rows(q);
  ny=rows(B);
  nf=ny-ns;
  nus=rows(mu);      @ number of unstable roots @
  if nus ./= ns-np;
   "Incorrect Dimensions in MDRKW";
   "nus, ns, np=";;nus~ns~np;
   "Processing Stops";
   stop;
  endif;
  nlead=cols(CF)/nx;
  nlead=nlead-1;


@ -- Step 1 write C(F) Ex(t)|I(t) = PHI*m(t) --
      Calculate CF0*Q*I+CF1*Q*RHO+CF2*Q*RHO^2 + ...CFn*Q*RHO^nlead
      i.e., calculate C(F) Ex(t)|I(t) @

 R=eye(cols(RHO));
 PHI=CF[.,1:nx]*Q*R;
 j=0; do while j<nlead;
   R=R*RHO;
   PHI=PHI+CF[.,(j+1)*nx+1:(j+2)*nx]*Q*R;
 j=j+1; endo;


@ -- Step 2 -- Solve Unstable portion of Model

      Let u(t)=L*d(d) denote the unstable portion of model, then:

      Eu(t+1)|I(t) =  MU u(t) + L*PHI2 m(t),

      Set q = L*PHI2 and MI=inv(MU), then solving forward:

      u(t)=-MI*[q +(MI)*q*RHO + (MI^2)*q*(RHO^2) + ... ]*m(t)
          = THETA*m(t)

      Note, THETA satisfies:

      THETA*RHO = MU*THETA + q, so that the i'th row satisfies:

       thetai*RHO=MU(i,i)*thetai + qi => thetai = qi/(RHO-MU(i,i)*eye(RHO) @

"nus";;nus;"nf";;nf;"ny";;ny;"cols(phi)";;cols(phi);"Cols(rho)";;cols(rho);
q1 = L*PHI[nf+1:ny,.];
theta=zeros(nus,cols(PHI));
IRHO=eye(cols(RHO));
i=0; do until i==nus;
 i=i+1;
 theta[i,.]=q1[i,.]*inv(RHO-MU[i,i]*IRHO);
endo;

@ -- Step 3: use this solution for u(t) to solve for some elements of d(t)
     Note: from model reduction program, d(t) can be partitioned as:
            | lam(t)|
     d(t) = |       |
            | k(t)  |

where k(t) are predetermined (i.e., k(t+1/t)=k(t+1)).  Thus writing

    u(t) = L*d(t) = Llam*lam(t) + Lk*k(t)

we must have that Llam is non-singular.  (If not, the predetermined variables
will explode.

Thus, we can write:  lam(t) = inv(Llam)*[-Lk*k(t)+u(t)]
                            = inv(Llam)*[-Lk*k(t)+theta*m(t)]
                            = lamk*k(t) + lamdr*m(t)

with lmak = -inv(Llam)*Lk, and lamdr=inv(Llam)*theta

@

if np>0;
 lamk=-inv(L[.,1:nus])*L[.,nus+1:ns];
endif;
lamdr= inv(L[.,1:nus])*theta;


nus=rows(mu);      @ number of unstable roots @
nlead=cols(CF)/nx;
nlead=nlead-1;

BT=B;

@ We want to impose this solution on the dynamic system, i.e.,
  "substitute out" for lam(t) using the above rule, which we write
  as lam(t) = lamk * k(t) + lamdr * drv(t).  We have equations of the form:
   B2 * lam(t) +         B3 * k(t) +   PHI           * m(t) = 0.  Adding

  -B2 * lam(t) +    B2*lamk * k(t) +   B2*lamdr      * m(t) = 0,  we get

   0  * lam(t) + B3+B2*lamk * k(t) +  (PHI+B2*lamdr) * m(t) = 0   @

B2 = BT[.,nf+1:nf+nus];
B3 = BT[.,nf+nus+1:ny];

@ incorporate the influence of k(t) via lam(t) into system.@

if np>0;
 BT[.,nf+nus+1:ny]=B3+B2*lamk;
endif;

@ incorporate the influence of m(t) via lam(t) into system.@

PHI=PHI+B2*lamdr;

@ patch up the lam(t) influences and the lam(t) equations.@
BT[.,nf+1:nf+nus]=zeros(rows(B2),cols(B2));
BT[nf+1:nf+nus,nf+1:nf+nus]=eye(nus);
if np>0;
 BT[nf+1:nf+nus,nf+nus+1:nf+ns]=-lamk;
endif;
PHI[nf+1:nf+nus,.] = -lamdr;

@ solve for state space system:
  z(t) =   PI*s(t)
  s(t+1) = M*s(t) + H*e(t+1)
  with s(t) = |k(t)  |   and z(t) = |y(t)|
              |m(t)  |              |k(t)|
                                    |x(t)| @

nk=ns-nus;
ndrv=cols(Q);

PII= ((-BT[1:nf+nus,nf+nus+1:ny])~(-PHI[1:nf+nus,.]))|
      (eye(nk)~zeros(nk,ndrv));

@ This is a PI matrix for the new ordering, we now create one
  for the old ordering and add exogenous variables @

PII=  (K'*PII)|(zeros(nx,nk)~Q);

M = (BT[nf+nus+1:ny,nf+nus+1:ny]~PHI[nf+nus+1:ny,.])|
     (zeros(ndrv,nk)~RHO);

H = zeros(rows(M),nshock);
H[nk+1:nk+nshock,.]=eye(nshock);

retp(M, PII, H);
endp;
