proc (5) = redkw(&mconv,&csr,A,B,CF,nx,lpd);
    local  ny,K,PHI,ord,lnpd,npd,nf,nlead,it,dt0,nnf,Al,Be,U,S,V,
           rAl,tol,mk,TR,IA,nd,Q,P,E,R,qx,qp,mtt,ncf,lcb,
           mconv:proc,csr:proc;
@ redkw.prc @

@ Dynamic system reduction program
  The inputs are matrices A,B, and CF=[C0 ... Cn] and parameter nx.
  The outputs are matrices B, PSIF = [PSI0 ... PSIq] and parameter nd.

  The program reduces a singular dynamic system of the form:

    A Ey(t+1)|I(t) = B y(t) + C(F) Ex(t)|I(t),

  with nx the dimension of x(t), to a dynamic system of the form

   | 0  0  | |Ef(t+1)|I(t)|   | I     V | |f(t)|    |PSI1(F)|
   |       | |            | = |         | |    |  + |       |  Ex(t)|I(t)
   | 0  I  | |Ed(t+1)|I(t)|   | 0     W | |d(t)|    |PSI2(F)|

  with nd the dimension of d(t) and with a reordering of variables
  (permutation) matrix K, such that
            | f(t) |
   y(t) = K |      |
            | d(t) | @

ny=cols(A);

lpd=vec(lpd);
npd=sumc(lpd ./= 0);

@ initialize K matrix (reordering matrix)@
K=eye(ny);
"number of PD variable in redkw =";;npd;

if npd>0;
  lnpd=lpd ./= 0;
  lpd = selif(lpd,lnpd);
 @ selection matrix that gets predetermined variables.@
  PHI=K[lpd,.];

 @ construct selection matrix that gets non-predetermined variables.@
  lnpd=ones(ny,1)-sumc(PHI);
  K=selif(K,lnpd);

 @ K is matrix that locates nonpd and then pd variables.@
  K=K|PHI;
 
 @since K*K' = I and ynew=K*yold, we must postmultiply A and B by K'=inv(K)@
  A=A*K';
  B=B*K';

endif;

@ We begin by specifying an initial number of flows (nf=0).
  As we progressively reduce the system, we always have
  systems of the form

   | 0  0  | |Ef(t+1)|I(t)|   | I     Nu | |f(t)|    |Ch1(F)|
   |       | |            | = |          | |    |  + |      |  Ex(t)|I(t)
   | 0  Al | |Ed(t+1)|I(t)|   | 0     Be | |d(t)|    |Ch2(F)| @

ny=rows(A);
nf=0;
nlead=cols(CF)/nx;
nlead=nlead-1; @ take account of C0 @

@ Intialize iteration@
it=0;

@ Undertake system reduction if there is a small
  determinant of Al in Al d(t+1) = Be d(t) + ...


  Iterate until either det(Al) >0 or until no additional
  flows are removed on the prior iteration

  det0=1 <=>determinant is about zero.@

dt0=(abs(det(A[nf+1:ny,nf+1:ny]))<.000001);

nnf=1; @ pretend flows were eliminated on prior iteration@

do while dt0==1 .and nnf>0;

@ The system is partitioned:

  A = | 0  0  |     B = | I     Nu|   C(F) =  |C1(F)|
      | 0  Al |         | 0     Be|           |C2(F)|

  where Al is short for alpha and Be is short for beta.@

Al=A[nf+1:ny,nf+1:ny];
Be=B[nf+1:ny,nf+1:ny];

@ The first problem is to get some more zero rows in Al, making it

  Al = |  0   0   |
       | ah21 ah22|

  One way to do this is to compute the singular value decomposition of Al@

{U,S,V}=svd1(Al);

@ where U and V are unitary matrices (U*U'=I and V*V'=I) and S is
  S = |sigma  0 |
      |  0    0 |
  with sigma being a diagonal matrix with rank(Al) postive numbers
  (the singular values) on its diagonal.

  The rank of a matrix is theoretically the number of non-zero
  singular values.  We approximate this here as in the PC-MATLAB
  rank command, where the computation is based on the number of
  singular values greater than a given tolerance level. @

rAl = diag(S);
tol = cols(S)*rAl[1]*0.00000001;
rAl = sumc(rAl.>tol); @ rank @

@ System Translation #1:
  We now want to transform the system, leaving the flow equations unaltered
  but changing the equations describing the d(t) so that these are
  in form SV' Ed(t+1)|t = U'B2 d(t) + U'C2(F) Ex(t)|I(t). @

TR=eye(ny);
TR[nf+1:ny,nf+1:ny]=U';

@ System Translation #2:
  We also want to rearrange the ordering of the equations of the system
  so that those with zeros appear before the non-degenerate ones. This
  involves multiplying by a matrix:
    | I  0  0|
    | 0  0  I|
    | 0  I  0|
  with suitably chosen dimensions of the identity matrices @

IA=eye(ny);
nd=ny-nf;

if nf>0;
IA=IA[.,1:nf]~IA[.,ny-rAl+1:ny]~IA[.,nf+1:ny-rAl];
else;
IA=IA[.,ny-rAl+1:ny]~IA[.,nf+1:ny-rAl];
endif;

TR=IA*TR;

A=TR*A;
B=TR*B;
CF=mconv(TR,CF,0,nlead);

@ The "d(t) equations" of the system are now in the form:

    |  0   0   | |Elam(t)|I(t)|   | Be11 Be12 | |lam(t)|   | Cl(F)|
    |          | |            | = |           | |      | + |      | Ex(t)|I(t)
    | ah21 ah22| |Ek(t)  |I(t)|   | Be21 Be22 | |k(t)  |   | Ck(F)|

  where lam(t) are the non-predetermined d(t) and k(t) are predetermined.
  Notice that this suggests that there are "candidate flows",
  i.e., elements of d(t) attached to behavioral equations that contain
  no leads.  We want to solve for as many of these as possible.

  Get the first ns-max(rAl,npd) rows and ns-np columns of the Be matrix, Be11
  rows reorganized.  We take max(rAl,npd) since we don't want
  an inconsistent equation system.@

mtt=rAl~npd;
lcb=B[nf+1:nf+nd-maxc(mtt'),nf+1:ny-npd];

@ We compute the "QR" factorization of this matrix, i.e., we find matrices
  Q,R, and P such that b P = QR.  Q is unitary, P is a permutation
  matrix and R is upper triangular.  (If the rank of row b is less than full
  then the last rows of R are zero).

  Hence, if we want to solve the system of equations b x = k, we can do so
  as follows: k = bx <=> k = b P (P'x) <=> Q'k = R (P'x).  Thus, if we are
  willing to reorder the x's (using X=P'x), we can solve for a subset--call
  it x1--as a function of the others: R11 x1 + R12 x2 = k1 =>
  x1 = inv(R11)*{k1-R12*x2}.  In this expression, we have used only the parts
  of the system for which the transformed equations are non-zero.  As a
  consistency check, we also need to verify that the elements k2 =0. @

 {Q,R,E}=qqre(lcb);
  P=eye(rows(e));
  P=P[.,E];    @ note LCB*P = Q*R @

@ Translation #3:
  as above, reordering of variables y=TR*ystar; ystar=TR'*y;
  implies we need to post-multiply A and B by TR; @

TR=eye(ny);
TR[nf+1:ny-npd,nf+1:ny-npd]=P;
A=A*TR;
B=B*TR;
@ and change the reordering matrix K by@

K=TR'*K;
@ This reordering implies that the ncf=nd-max(rAl,npd) candidate flows
  are ordered first in the d(t).@

ncf=rows(lcb);

@ Translation #4:
  multiply the ncf equations of the "candidate flows" by Q' @
TR=eye(ny);
TR[nf+1:nf+ncf,nf+1:nf+ncf]=Q';

A=TR*A;
B=TR*B;
CF=mconv(TR,CF,0,nlead);

@ Solving for the candidate flows.

  We determine how many linearly independent rows of the equations there are
  by finding the total number of elements in each row that are close to zero;
  computing the number of rows with all zeros and subtracting from the number
  of rows. @

nnf=abs(R).<0.00001;
nnf=sumc(nnf');
nnf=nnf./cols(R);
nnf=sumc(nnf.==1);
nnf=rows(R)-nnf;

if nnf>0;
@ We check the elements of the linear system if nnf < ncf @
if nnf<ncf;
  qx=maxc(maxc(abs(CF[nf+nnf+1:nf+ncf,.])));
  if qx>.000000001;
    print "Problems with flow equations and exogenous variables";
    pause(20);
  endif;
  qp=maxc(maxc(abs(B[ny-npd+1:ny,.])));
  if qp>.000000001;
    print "Problems with flow equations and exogenous variables";
    pause(20);
  endif;
endif;

@ new number of flows: nf+nnf@
nf=nf+nnf;

@ undertake classical system reduction@
{A,B,CF}=csr(&mconv,A,B,CF,nf,nlead);
nlead=nlead+1;
it=it+1;
print "iteration #:" it;
endif;

dt0=(abs(det(A[nf+1:ny,nf+1:ny]))<.000001);  @ determinant is about zero.@

endo;

if dt0==1;
  print "dynamic system contains irreducible singularity in A";
else;
  TR=eye(ny);
  TR[nf+1:ny,nf+1:ny]=inv(A[nf+1:ny,nf+1:ny]);
  A=TR*A;
  B=TR*B;
  CF=mconv(TR,CF,0,nlead);
endif;

nd=ny-nf;
retp(nd,A,B,K,CF);
endp;
