proc(2) = specme(spmod,spdat,wght);
/* Procedure for Calculating Error Spectral Density Matrix 
   Input:
         spmod = model spectrum
         spdat = data spectrum
         wght = weight (to weight trace)

   Output:
         sperr = error spectrum
         spmd = cross-spec (model, data)
*/
local k, u, s, v, a, dif, b, w, atil, g, spmd, sperr;

@ -- (1) Decompose spmod=a*a',  where a is nxk, and k = rank(spmod) -- @
 k=rank(spmod);
 {u,s,v}=svd1(spmod);
 a=u[.,1:k]*(sqrt(s[1:k,1:k]));

@ -- (2) Calculate Matrix Square Root of SPDATA, spdat = b*b' @
 {u,s,v}=svd1(spdat);
 b=u*(sqrt(s));

@ -- (3) Find G, such that:
         sxy=A*G'; SPdat = g*g' + See, where See is psd @
 w=diagrv(eye(rows(a)),wght);
 atil=b'*w*a;
 {u,s,v}=svd1(atil);
 g=b*u[.,1:k]*v';
@ -- (4) Calculate Spectrum of Error -- @
 spmd=a*g';
 sperr=spmod+spdat-spmd-spmd';

retp(sperr,spmd);
endp;

