proc(1) = sptran(spec,w,gy,gr);
/* Transform Spectrum to Specrum of First Difference

input:
   spec is the spectrum of
   n    1
   rw   2
   m    3
   R     4
   c-y   5
   i-y   6
   mdec  7     m-p-gy*y-gr*R
   rwec  8     rw-y+n

   next 8 variables are the expections of these 1 period ahead,
   i.e., n(t+1/t), rw(t+1/t), etc.

   w = required frequency
   gy = income elasticity of money demand
   gr = interest rate semi-elasticity of money demand

output
   spec is the spectrum of
     y, c, i, n, rw, m, p, m-p, R, r
     where r = R - p(t+1/t)*400.
*/
local im, z, az, azi, a, g ;
local in, irw, imn, iBR, icy, iiy, imdec, irwec;
local jy,jc,ji,jn,jrw,jm,jp,jbr,jmp,jr;
local nx, gepi, gept;
nx=8;
@ -- Input Locations -- @
   in=    1;
   irw=   2;
   imn=   3;
   iBR=   4;
   icy=   5;
   iiy=   6;
   imdec= 7;
   irwec= 8;

@ -- Output Locations -- @
   jy=1;
   jc=2;
   ji=3;
   jn=4;
   jrw=5;
   jm=6;
   jp=7;
   jmp=8;
   jBR=9;
   jr=10;


@ Step 1 -- Accumulate First three Elements of
  Input spectra -- thus, first three elements are
  Now the levels of n, rw, m.  All other variables
  are unchanged
@
let im = 0+1i;
z=exp(-w*im);az=1-z;  @ az is first difference filter @
azi=inv(az);          @ azi is the accumulation operator @
a=eye(rows(spec));
a[1:3,1:3]=azi*(eye(3));
spec=a*spec*a';

@ Step 2 -- Change First 3 Expectations variables, so that these are levels @
a=eye(rows(spec));
a[nx+1:nx+3,1:3]=(eye(3));        @ Levels at time t @
a[nx+1:nx+3,nx+1:nx+3]=(eye(3));  @ Add expected changes at t+1 @
spec=a*spec*a';


@ Step 2 , find mapping from
     x1=(n, rw, m, R, (c-y), (i-y), m-p-gy*y-gr*R, rw-y+n) + Expectations to
 to  x2=(y, c, i, n, rw, m, p, m-p, R, r)
        |E(t+1(y, c, i, n, rw, m, p, m-p, R, r)

@
  g=zeros(10,rows(spec));
  g[jy,irwec]=-1; g[jy,in]=1; g[jy,irw]=1;
  g[jc,icy]=1;g[jc,.]=g[jc,.]+g[jy,.];
  g[ji,iiy]=1;g[ji,.]=g[ji,.]+g[jy,.];
  g[jn,in]=1;
  g[jrw,irw]=1;
  g[jm,imn]=1;
  g[jBR,iBR]=1;
  g[jp,imdec]=-1;g[jp,.]=g[jp,.]+g[jm,.]-gy*g[jy,.]-gr*g[jBR,.];
  g[jmp,.]=g[jm,.]-g[jp,.];
  gEpt = zeros(1,nx)~g[jp,1:nx];    @ Ep(t+1/t) @
  gepi = gept-g[jp,.];             @ Ep(t+1/t)-p(t) @
  g[jr,ibr]=1; g[jr,.]=g[jr,.]-400*gepi;  @ Real rates, percent AAR @


@ Step 3, find spectrum of y, c, i, n, rw, m, p, m-p, R, r @
  spec=g*spec*g';

@ Step 4, find spectrum of y,c,i,n,rw,m,p,m-p,R,r @
  a=az*eye(rows(spec));
  a[jbr,jbr]=1; a[jr,jr]=1;
  spec=a*spec*a';

retp(spec);
endp;
