proc(1) = sptran(spec,w,gy,gr);
/* Transform Spectrum to Specrum of First Difference

input:
   spec is the spectrum of
     y, n, m, r, (y-c), (y-i), rw-y+n, m-p-gy*y-gr*r
   w = required frequency
   gy = income elasticity of money demand
   gr = interest rate semi-elasticity of money demand

output
   spec is the spectrum of
     y, c, i, n, rw, m, p, r
*/
local im, z, az, azi, a, g ;

@ Step 1 -- Calculate Spectrum of
     y, n, m, r, (y-c), (y-i), rw-y+n, m-p-gy*y-gr*r
@
let im = 0+1i;
z=exp(-w*im);az=1-z;  @ az is first difference filter @
azi=inv(az);          @ azi is the accumulation operator @
a=eye(rows(spec));
a[1,1]=azi;a[3,3]=azi;
spec=a*spec*a';

@ Step 2 , find mapping from
     y, n, m, r, (y-c), (y-i), rw-y+n, m-p-gy*y-gr*r
 to  y, c, i, n, rw, m, p, r

     -- First, construct inverse --
@
  g=zeros(8,8);
  g[1,1]=1;
  g[2,4]=1;
  g[3,6]=1;
  g[4,8]=1;
  g[5,1]=1; g[5,2]=-1;
  g[6,1]=1; g[6,3]=-1;
  g[7,5]=1; g[7,1]=-1; g[7,4]=1;
  g[8,6]=1; g[8,7]=-1; g[8,1]=-gy; g[8,8]=-gr;

  g=inv(g);

@ Step 3, find spectrum of y, c, i, n, rw, m, p, r @
  spec=g*spec*g';

@ Step 4, find spectrum of y, c, i, n, rw, m, p, r @
  a=az*eye(8);a[2,2]=1; a[8,8]=1;
  spec=a*spec*a';

retp(spec);
endp;

