proc(1) = spt(ss,w);
/* -- SPT_pM.PRC
   9/25/94, mww
   TEST VERSION
*/
local im, z, az, a, g, spec, nx1, nx2;
local iL,iN,iC,ii,iy,ip,iw,idbp,iq,ik,iBR,ir,ilam,ia,imn,iv;
local inw,imc,idl,ipl,ih, ipsit, imu, is, ipsi, isl;
local jdy, jdc, jdi, jdn, jdw, jdp, jdmn, jdmp, jbr, jr, jda;

/*
   @ -- Variable List for pM Model --@
input:
   spec is the spectrum of X1=
                L(t)  1
                N(t)  2
                H(t)  3
                C(t)  4
                I(t)  5
                Y(t)  6
                P(t)  7
                W(t)  8
                psi(t)9
                mu(t) 10
                q(t)  11
                k(t)  12
                S(t)  13
                S(t-1)14
                R(t)  15
                r(t)  16
                a(t)  17
                m(t)  18
                d1    19
                d2    20
                d3    21
                d4    22
                d5    23
                d6    24
   w = required frequency
*/
iL=   1;
iN=   2;
iH=   3;
iC=   4;
iI=   5;
iY=   6;
iP=   7;
iW=   8;
ipsi= 9;
imu= 10;
iq=   1;
ik=  12;
is=  13;
isl= 14;
iBR= 15;
ir=  16;
ia=  17;
imn= 18;


/*
output
   spec is the spectrum of X2=
          y(t)  1
          c(t)  2
          i(t)  3
          n(t)  4
          w(t)  5
          p(t)  7
          m(t)  6
          m-p  8
          R     9
          r     10
          a    11
*/
          jdy=  1;
          jdc=  2;
          jdi=  3;
          jdn=  4;
          jdw=  5;
          jdmn= 6;
          jdp=  7;
          jdmp =8;
          jBR = 9;
          jr = 10;
          jda = 11;

nx1=rows(ss); nx2=11;

@ Step 1 -- First Difference Variables -- @

let im = 0+1i;
z=exp(-w*im);az=1-z;  @ az is first difference filter @
a=az*(eye(rows(ss)));
a[ibr,ibr]=1;
a[ir,ir]=1;
spec=a*ss*a';

@ Step 2 , find mapping from
     del(x1) to x2
@
  g=zeros(nx2,nx1);
  g[jdy,iy]=1;
  g[jdc,ic]=1;
  g[jdi,ii]=1;
  g[jdn,in]=1;
  g[jdw,iw]=1;
  g[jdp,ip]=1;
  g[jdmn,imn]=1;
  g[jdmp,imn]=1; g[jdmp,ip]=-1;
  g[jBR,iBR]=1;
  g[jr,ir]=1;
  g[jda,ia]=1;

@ Step 3, find spectrum of X2 @
  spec=g*spec*g';

retp(spec);
endp;
