proc(1) = spt(ss,w);
/* -- SPT_pM.PRC
   9/25/94, mww
*/
local im, z, az, a, g, spec, nx1, nx2;
local iL,iN,iC,ii,iy,ip,iw,idbp,iq,ik,iBR,ir,ilam,ia,imn,iv;
local inw,imc,idl,ipl;
local jdy, jdc, jdi, jdn, jdw, jdp, jdmn, jdmp, jbr, jr, jda, jdv;

/*
   @ -- Variable List for pM Model --@
input:
   spec is the spectrum of X1=
          L(t)   1
          N(t)   2
          C(t)   3
          I(t)   4
          Y(t)   5
          P(t)   6
          w(t)   7
          dbp(t) 8
          q(t)   9
          k(t)   10
          R(t)   11
          r(t)   12
          lam(t) 13
          nw(t)  14
          mc(t)  15
          dl(t)  16
          pl(t)  17
          a(t)   18
          m(t)   19
          v(t)   20
   w = required frequency
*/
          iL=   1;
          iN=   2;
          iC=   3;
          iI=   4;
          iY=   5;
          iP=   6;
          iw=   7;
          idbp= 8;
          iq=   9;
          ik=   10;
          iBR=   11;
          ir=   12;
          ilam= 13;
          inw=  14;
          imc=  15;
          idl=  16;
          ipl=  17;
          ia=   18;
          imn=  19;
          iv = 20;

/*
output
   spec is the spectrum of X2=
          y(t)  1
          c(t)  2
          i(t)  3
          n(t)  4
          w(t)  5
          p(t)  7
          m(t)  6
          m-p  8
          R     9
          r     10
          a    11
          v    12
*/
          jdy=  1;
          jdc=  2;
          jdi=  3;
          jdn=  4;
          jdw=  5;
          jdmn= 6;
          jdp=  7;
          jdmp =8;
          jBR = 9;
          jr = 10;
          jda = 11;
          jdv = 12;

nx1=rows(ss); nx2=12;

@ Step 1 -- First Difference Variables -- @

let im = 0+1i;
z=exp(-w*im);az=1-z;  @ az is first difference filter @
a=az*(eye(rows(ss)));
a[ibr,ibr]=1;
a[ir,ir]=1;
spec=a*ss*a';

@ Step 2 , find mapping from
     del(x1) to x2
@
  g=zeros(nx2,nx1);
  g[jdy,iy]=1;
  g[jdc,ic]=1;
  g[jdi,ii]=1;
  g[jdn,in]=1;
  g[jdw,iw]=1;
  g[jdp,ip]=1;
  g[jdmn,imn]=1;
  g[jdmp,imn]=1; g[jdmp,ip]=-1;
  g[jBR,iBR]=1;
  g[jr,ir]=1;
  g[jda,ia]=1;
  g[jdv,iv]=1;

@ Step 3, find spectrum of X2 @
  spec=g*spec*g';

retp(spec);
endp;
