proc(1) = spvar(q,m,seps,w);
/* Procedure for Calculating Spectral Density Matrix for a 
   SS model of the form:

   y(t) = q*x(t)
   x(t) = m*m(t-1) + g*u(t)
   var(u(t))=seps:

   Output:  ss = spectrum of s at frequency w.
   Note: Spectrum is not divided by 2*pi

*/
local im, z, sm, smi, ss, nvar, nlags, ii, z1;

nvar=rows(seps);       @ Number of Variables in VAR @
nlags=cols(b)/(nvar);

@ -- Calculate Spectrum of S --- @
 let im = 0+1i;
 z=exp(-w*im);
 sm=eye(rows(seps));
 z1=1;
 ii=1; do while ii <= nlags;
  n1=nvar*(ii-1);
  z1=z*z1;
  sm=sm-z1*b[.,n1+1:n1+nvar];
 ii=ii+1; endo;
smi=inv(sm);

ss=smi*seps*smi';
@ ss=ss/(2*pi);  @

retp(ss);
endp;
