proc (3) = timing(AM,BM,CFM,ns,vs,nd,vd,QM,PI,M,nshock,lpd,nlead,list);

local piyk, npd, piyd, qs, piyshock, nsub, abar, bbar, cfbar, tr, r0;
local ord, lnpd, ky, ry, rd, abars, bbars, cfbars, mm, rm, phid, kk;
local dalready, imk, nalready, e, p, rnk, nc, pipart, mpart, dd, ny, nx;
local rho,k;

/* Timing.gss, mww, 7/13/94
   (Gauss translation of rgk's timing.m)

 TIMING: function to compute response of endogenous variables to shocks
         in a model with "ns" subperiods. The model is presumed to be
         written in the form:

         A0 Ey(t+1)|I0(t) + A1 Ey(t+1)|I1(t) + ...   An Ey(t+1)|In(t)

          =  B0 Ey(t)|I0(t) + B1 Ey(t)|I1(t)   + ...   Bn Ey(t)|In(t)

           + C0(F) Ex(t)|I0(t) + C1(F) Ex(t)|I1(t) + ... Cn(F) Ex(t)|In(t)

         The matrices AM,BM, and CFM contain the subperiod matrices ordered
                 AM=[A0
                     A1...
                     An] etc.

  Input: xx

  Output: xx

*/

ny=cols(AM);       @ number of y variables  @
nx=rows(QM);
npd=rows(lpd);     @ number of predetermined variables @

/*
     The vectors ns and vs contain information about the determination
     of variables by subperiod:
     ns=[ns0 ns1 .... nsn], with nsi being the number of variables
           determined in the ith subperiod.
     vs is an ny element vector containing the indices of the
           variables in ordered determined (the first ns0 are
           determined in period 0, the next ns1 in period 1, etc.)
     Comparably, nd and vd give the location of "shock" variables by
           subperiod.  (x(t)-Ex(t)|I0(t)=QS*shock(t)).
     The matrices PIyk and PIyd contain the response of y to changes in
            k and perturbations to driving variables (as computed from
            the model: A Ey(t+1)|I0(t) = B Ey(t)|I0(t) + C(F) Ex(t)|I0(t)
     Get these and other useful information out of PI and M:
*/

RHO=M[npd+1:rows(M),npd+1:rows(M)];
PIyk=PIi[1:ny,1:npd];
PIyd=PIi[1:ny,npd+1:cols(PIi)]*RHO;
         @  correct PI for fact that its now delta(t-1)  @
PIyd=PIyd[.,1:nshock];    @ innovation effects only (not forecasting lags) @
QS=QM[.,1:nshock];        @  innovation effects only (not forecasting lags) @


/*
        We are building a response matrix of the same size as PIyd,
        so we initialize it.
*/

PIyshock=zeros(rows(PIyd),cols(piyd));

/*
        Writing the model in terms of "innovations" one sub-period ahead
        we get:
         Abar1 (Ey(t+1)|I1(t) - Ey(t+1)|I0(t))
          + Abar2 (Ey(t+1)|I2(t) - Ey(t+1)|I1(t))
          + Abarn (Ey(t+1)|In(t) - Ey(t+1)|In-1(t))

         = Bbar1 (Ey(t)|I1(t) - Ey(t)|I0(t))
          + Bbar2 (Ey(t)|I2(t) - Ey(t)|I1(t))
          + Bbarn (Ey(t)|In(t) - Ey(t)|In-1(t))

          + CFbar1 (Ex(t)|I1(t) - Ex(t)|I0(t))
          + CFbar2 (Ex(t)|I2(t) - Ex(t)|I1(t))
          + CFbarn (Ex(t)|In(t) - Ex(t)|In-1(t))

         where Abars=As+...+An, etc. Thus, we have blocks of equations of the
         general form:
           Abars (Ey(t+1)|Is(t) - Ey(t+1)|Is-1(t))
          = Bbars (Ey(t)|Is(t) - Ey(t)|Is-1(t))
          + CFbars (Ex(t)|Is(t) - Ex(t)|Is-1(t))
*/

nsub=rows(ns)-1;

@  create the Abar, etc. matrices @
Abar=AM;
Bbar=BM;
CFbar=CFM;

i=nsub; do while i >= 1;
  Abar[ny*(i-1)+1:ny*i,.]=AM[ny*(i-1)+1:ny*i,.]+Abar[ny*i+1:ny*(i+1),.];
  Bbar[ny*(i-1)+1:ny*i,.]=BM[ny*(i-1)+1:ny*i,.]+Bbar[ny*i+1:ny*(i+1),.];
  CFbar[ny*(i-1)+1:ny*i,.]=CFM[ny*(i-1)+1:ny*i,.]+CFbar[ny*i+1:ny*(i+1),.];
i=i-1; endo;

/*
 Note that we have created Abar0=A0+A1+...An even though we don't need it.
*/

tr=0;
r0=rank(Abar[tr*ny+1:(tr+1)*ny,.]~Bbar[tr*ny+1:(tr+1)*ny,.]);
if (r0<cols(Abar));
  "problems with A,B matrices: [A0 B0] less than full rank";
endif;

@ Matrices used below to reorder y and d (shocks) @

/*
 Various reordering matrices useful below:
 1. Standard translation to put predetermined variables last:
 initialize K matrix (reordering matrix)
*/

K=eye(ny);
npd=rows(lpd);
if (npd>0);
 @ selection matrix that gets predetermined variables  @
 PHI=K[lpd,.];

 @  construct selection matrix that gets non-predetermined variables @
 ord=seqa(1,1,ny);

 @ This step isolates the rows of K which correspond to variables that
   are not predetermined @
 if npd==1;
   K=selif(K,(ones(1,ny)-PHI)');
 else;
  lnpd=ones(ny,1)-sumc(PHI);
  @lnpd vector with ones for nonpredetermined variables and zeros elsewhere @
  K=selif(K,lnpd);
 endif;
 @ K is matrix that locates nonpd and then pd variables @
 K=K|PHI;

elseif npd.==0;
 Ky=eye(ny);
endif;


@ 2. Reordering matrices associated with timing structure @
RY=eye(ny);
RY=RY[vs,.]; @  reorder y variables according to vs (note inv(R)=R'); @

RD=eye(sumc(nd));
RD=RD[vd,.]; @ reorder shock variables according to vd (note inv(R)=R'); @

@ Construction of the Response Matrix By Subperiod: @

i=1; do while i <= nsub;
  @ for each subperiod, i=1,...n @
 j=i+1;   @ correction for presence of A0 @

/*
         We will concentrate on solving the above equations.
         For each "s", we can use

           Abars (Ey(t+1)|Is(t) - Ey(t+1)|Is-1(t))
          = Abars PIyk  (Ek(t+1)|Is(t) - Ek(t+1)|Is-1(t))
          + Abars PIyd (Ed(t)|Is(t) - Ed(t)|Is-1(t))

         where by d(t) we mean the shocks and thus
           (Ed(t)|Is(t) - Ed(t)|Is-1(t)) is the relevant subperiod shocks.
*/

Abars=Abar[ny*(j-1)+1:ny*j,.];
Bbars=Bbar[ny*(j-1)+1:ny*j,.];
CFbars=CFbar[ny*(j-1)+1:ny*j,.];

/*
         Further, we know that there are no innovations to k(t) since
         it is predetermined.  Thus, we may rewrite the equations as:
                                     |(Efl(t)|Is(t) - Efl(t)|Is-1(t))  |
             |-Bbars,fl Abars*PIyk|  |                                 |
                                     |(Ek(t+1)|Is(t) - Ek(t+1)|Is-1(t))|

                     =  CFbars (Ex(t)|Is(t) - Ex(t)|Is-1(t))

                       - Abars*PIyd (Ed(t)|Is(t) - Ed(t)|Is-1(t))

         In this expression, Bbars,fl is the columns of Bbars that pertain
         to nonpredetermined variables (called f and lambda in the KW paper).

   To do this, we need to reorder the variables: ynew = K*yold. Hence,
   we post multiply Bbars Bby K'=inv(K); Note that the "k variables"
   are already ordered last by earlier procedures (in PIyk).
*/

Bbars=Bbars*K';
MM=(-Bbars[.,1:ny-npd])~(Abars*PIyk);
 @ We now want to reorder the variables "back": yold=K'*ynew; @
Bbars=Bbars*K;
MM=MM*K;

/*
         There are two additional problems to be solved.  First, one must
         evaluate CFbars (Ex(t)|Is(t) - Ex(t)|Is-1(t)), which involves
         a procedure analagous to that in mdrkw.m.   However, in the current
         context, we need also to restrict the influence to those shocks
         that actually occur in subperiod s.

             Calculate CF0*QM*I+CF1*QM*RHO+CF2*QM*RHO^2 + ...CFn*QM*RHO^nlead
               i.e., calculate C(F) Ex(t)|I(t)
*/

RM=eye(rows(RHO));

PHID=CFbars[.,1:nx]*QM*RM;
kk=0; do while kk < nlead;
 kk=kk+1;
 RM=RM*RHO;
 PHID=PHID+CFbars[.,kk*nx+1:(kk+1)*nx]*QM*RM;
endo;

@ Drop predetermined forecasting elements @
PHID=PHID[.,1:nshock];

@  Add in influence of future predetermined variables: @
PHID=PHID-Abars*PIyd;

@        Reorder shocks  @
PHID=PHID*RD';

@   Select component that corresponds to shocks within period  @
dalready=sumc(nd[1:j-1]); @ number of shocks that have occurred already @
imk=dalready+nd[j];
PHID=PHID[.,dalready+1:imk];

/*
         Second, one wants to reorder
                   |(Efl(t)|Is(t) - Efl(t)|Is-1(t))  |
                   |(Ek(t+1)|Is(t) - Ek(t+1)|Is-1(t))|
         so as to partition out elements that have already been determined
         in earlier subperiods (these have coeficients of zero). If this
         reordering is RY, then we compute:
             |-Bbars,fl Abars*PIyk|  inv(RY)
*/

nalready=sumc(ns[1:j-1]);
MM=MM*RY';

/*
    The last "ny - nalready" columns of this matrix pertain to the variables
     of interest so these are selected. Call this matrix MM:
*/

MM=MM[.,nalready+1:ny];

/*
         our linear system is then of the form:
               MM  (Ec(t)|Is(t) - Ec(t)|Is-1(t)) | = PHID * shocks
         We solve it using the QR factorization (MM*P=Q*R)
*/

 {Q,R,E}=qqre(MM);
  P=eye(rows(e));
  P=P[.,E];    @ note M*P = Q*R @

/*
 We determine how many linearly independent rows of the equations there are
 by finding the total number of elements in each row that are close to zero;
 computing the number of rows with all zeros and subtracting from the number
 of rows.
*/

rnk=(abs(R)<.00001);
rnk=sumc(rnk');
rnk=rnk/cols(R);
rnk=sumc(rnk.==1);
rnk=rows(R)-rnk;

/*
 The solution is found as follows: first, multiply both sides of
  MM c = PHID d
 by Q'. Then, we expect that we can solve for all elements of c
 uniquely. The number of elements of c is:
*/

nc=cols(MM);

if (rnk<nc);
 "rank condition violated/program pausing in subperiod i";;i;
endif;

PHID=Q'*PHID;

if rows(phid) .> rnk;
 if (maxc(maxc(abs(PHID[rnk+1:rows(phid),.])))>.000001);
  "inconsistent system of equations/program pausing in subperiod i";;i;
 endif;
endif;

R=R*P';
R=R[1:rnk,.];

PHID=inv(r)*(phid[1:rnk,.]);    @  solution for coefficients @

@  Add back in variables determined in earlier periods:  @
PHID=zeros(ny-rows(PHID),cols(PHID))|PHID;

@  reorder variables @
PHID=RY'*PHID;

/*
 Now we want to insert this information into the relevant columns of the
 PIyshock matrix.
*/
imk=dalready+nd[j];
imk=vd[dalready+1:imk];
PIyshock[.,imk]=PHID;
"through subperiod #:";;j-1;

i=i+1; endo;

/*
 We now have a matrix that tells us how "f(t),lam(t), and k(t+1)" respond
 to shocks within the period. We next reorder to get the predetermined
 variables last, which separates out the equations for k(t+1). Our
 equations are of the form ytwiddle = PIyshock*shock, so we premultiply
 by K:
**/

PIyshock=K*PIyshock;
PIpart=PIyshock[1:(ny-npd),.]|zeros(npd,cols(PIyshock));

Mpart=PIyshock[ny-npd+1:ny,.];

dd=zeros(nshock,cols(mpart));
dd[1:nshock,1:nshock]=eye(nshock);
Mpart= (Mpart)|dd;
if (rows(M)-rows(Mpart)) .> 0;
 mpart=mpart|(zeros(rows(M)-rows(Mpart),cols(Mpart)));
endif;

/*
  We now reorder the equations for "f(t), lam(t), k(t)" back to their original
  variable ordering:
*/

PIpart=K'*PIpart;
dd=zeros(nx,cols(pipart));
dd[.,1:nshock]=qs;
PIpart=PIpart|dd;

/*
  We next expand the PI and M matrices to make room for the new
  (shock) state variables:
*/

PIi=PIi[.,1:npd]~(PIi[.,npd+1:cols(PIi)]*RHO)~PIpart;

M = (M~Mpart)|
     zeros(cols(Mpart),cols(M)+cols(Mpart));

h=zeros(rows(m),nshock);
@ -- Note -- h maps to shocks into the state
     The shocks were added as the last nshock elements of the states
     so that these rows of H contain non-zero elements. @
imk=eye(nshock);
h[rows(h)-nshock+1:rows(h),.]=imk;
retp(m,pii,h);

endp;

