

/* -- BandPass Procedures -- */
/* bpassar.prc -- Bandpass with AR padding for ends */
proc(1) = bpassar(x,updc,lpdc,n,nar,tcode);
/* -- input:
      x = series to be filtered
      updc = Period corresponding to upper cutoff frequency
      lpdc = Period corresponding to lower cutoff frequency
      n = number of terms in moving average filter
      nar = order of AR used for padding
      tcode = transformation code for AR model
              0 -- no transformation
              1 -- first difference

      Return is filtered value of series 
*/
local xtran, xpad, xpadf, xbp;

@ -- Pad Series -- @
if tcode .== 0; xtran=x; endif;
if tcode .== 1; xtran=x[2:rows(x)]-x[1:rows(x)-1]; endif;
xpad=pad(x,xtran,tcode,n,nar);

@ -- Bandpass Padded Series -- @
xpadf = bpass(xpad,updc,lpdc,n);
xbp=xpadf[n+1:rows(xpadf)-n];

retp(xbp);
endp;


      

/*
    bpass.prc
    GAUSS Translation of King's bpass.m
    1/26/94, mww
    program to compute bandpass filtered series using upper and lower
    cutoff periods.

*/
proc(1) = bpass(x,updc,lpdc,n);

/* -- input:
      x = series to be filtered
      updc = Period corresponding to upper cutoff frequency
      lpdc = Period corresponding to lower cutoff frequency
      n = number of terms in moving average filter

      Note: updc=2 makes this a high pass filter
      (since period = 2 implies om=pi).

      if lpdc .> rows(x), frequency is set to zero
*/
local avec, omubar, omlbar, step, np, om, omp, kk, lam, akvec, xf, j, i, t;

/*
"Band Pass Filtering of Time Series: ";
"Components between Periods of ";;  updc~lpdc;; "Time Units";;
*/

@ Implied Frequencies @
omubar=2*pi/updc;
omlbar=2*pi/lpdc;
if (lpdc .>= rows(x)); omlbar=0; endif;

/*
 To construct a low pass filter, with a cutoff frequency of "ombar",
 we note that the transfer function of the approximating filter
 is given by:

  alpha(om) = a0 + a1 cos(om) + ... aK cos(K om)

 and the ak's are given by:

 a0 = ombar/(pi)

 ak = sin(k ombar)/(k pi)

 where ombar is the cutoff frequency.

  We employ the fact that a bandpass filter is the difference between two
  low pass filters,
    bp(L) = bu(L) - bl(L)
  with bu(L) being the filter with the high cutoff point and bl(L) being
  that with the low cutoff point.
*/

@ Define the vector of K's to be studied @

@ Set the grid for om @
step=.01; np=(2/step)+1;
om=seqa(-1,step,np);

om=pi*om;
omp=om/pi;

@ Initialize output matrix @

@  Loop over specified K's @

 @  Construct Filter Weights @

 akvec=zeros(n+1,1);

 akvec[1]=(omubar-omlbar)/(pi);

 kk=1; do while kk <= n;
  akvec[kk+1]=(sin(kk*omubar)-sin(kk*omlbar))/(kk*pi);
 kk=kk+1; endo;
/*
  Impose constraint that transfer is
    (i)  0 at om = 0 if oml .> 0;
    (ii) 1 at om = 0 if oml .== 0;
  This amounts to requiring that weights sum to zero.
  Initial sum of weights:
*/
lam=akvec[1]+2*sumc(akvec[2:n+1]);
/* amount to add to each weight to get sum to add to zero */
if (omlbar .> .00000001);
   lam = -lam/(2*(n+1));
 else;
   lam = (1-lam)/(2*(n+1));
endif;
akvec=akvec+lam;
akvec[1]=akvec[1]+lam;

t=rows(x);    @ number of observations @

@ Set vector of weights @

avec=zeros(2*n+1,1);
avec[n+1]=akvec[1];
i=1; do while i <= n;
 avec[n+1-i]=akvec[i+1];
 avec[n+1+i]=akvec[i+1];
i=i+1; endo;

xf=miss(zeros(t,1),0);
j=n+1; do while j <= t-n;
 xf[j]=x[j-n:j+n]'*avec;
j=j+1; endo;

retp(xf);
endp;

proc(1)=pad(y,yf,fcode,n,nar);

/* -- Pad Data series y out using AR Forecasts and Backcasts
      y -- series to be padded
     yf -- data to use in AR (levels or diffs)
     fcode -- 1 if yf is first dif of y
              otherwise yf=y
     n -- number of terms to pad forward and backward
     nar -- order of autoregression to use
*/
local w, x, i, beta, v, forc, ypad;

@ Pad out future @
w=yf[nar+1:rows(yf)];
x=ones(rows(w),1);
i=1; do while i<=nar;
 x=x~yf[nar+1-i:rows(yf)-i];
i=i+1; endo;
beta=invpd(x'x)*(x'w);
v=rev(yf[rows(yf)-nar+1:rows(yf)]);
forc=zeros(n,1);
i=1; do while i <= n;
 forc[i]=beta'(1|v);
 v[2:rows(v)]=v[1:rows(v)-1];
 v[1]=forc[i];
i=i+1; endo;
if fcode .== 1;
 forc=cumsumc(forc) + ones(n,1)*y[rows(y),1];
endif;
ypad=y|forc;

@ Pad out past, by reversing series @
yf=rev(yf);
if fcode .== 1;
 yf=-yf;
endif;
w=yf[nar+1:rows(yf)];
x=ones(rows(w),1);
i=1; do while i<=nar;
 x=x~yf[nar+1-i:rows(yf)-i];
i=i+1; endo;
beta=invpd(x'x)*(x'w);
v=rev(yf[rows(yf)-nar+1:rows(yf)]);
forc=zeros(n,1);
i=1; do while i <= n;
 forc[i]=beta'(1|v);
 v[2:rows(v)]=v[1:rows(v)-1];
 v[1]=forc[i];
i=i+1; endo;
if fcode .== 1;
 forc=cumsumc(forc) + ones(n,1)*y[1,1];
endif;
forc=rev(forc);
ypad=forc|ypad;

retp(ypad);
endp;
