proc(2) = hac(y,x,j,ikern);
@
     Modified by MWW, 12-28-96

     Procedure for estimating the regression y = xbeta+ u
     The procedure produces the OLS estimate of b
     and a hetero/autocorrelation consistent estimate of
     the autocorrelation matrix.

Input:
     y = tx1
     x = txk
     j=truncation parameter
     ikern = kernel indicator
             1 => triangular
             2 => rectangular

Output:
     Beta = OLS estimate of beta (kx1)
    VBeta = Robust estimate of covariance matrix of beta (kxk)

@
local u, z, ii, xxi, r1, r2, v, kern, beta, vbeta;
beta=x'y/(x'x);
u=y-x*beta;

z=x.*u;
v=zeros(cols(x),cols(x));


@ Form Kernel @
kern=zeros(j+1,1);
ii = 0; do while ii <= j;
 kern[ii+1,1]=1;
 if j .> 0;
 if ikern .== 1; kern[ii+1,1]=(1-(ii/(j+1))); endif;
 endif;
ii=ii+1; endo;

@ Form Hetero-Serial Correlation Robust Covariance Matrix @
ii = -j; do while ii <= j;
 if ii <= 0; r1=1; r2=rows(z)+ii; else; r1=1+ii; r2=rows(z); endif;
 v=v + kern[abs(ii)+1,1]*(z[r1:r2,.]'z[r1-ii:r2-ii,.]);
ii=ii+1; endo;
xxi=invpd(x'x);
vbeta=xxi*v*xxi;
retp(beta,vbeta);
endp;

