proc(3) = infbias(tdsq);


@ -- Compute inflation bias -- here using 
     ERR, 1998 page 80, Table 2.4

     Series values for PCE and CPI
    
    -.12  from 1995:1 to 1995:4
    -.22  from 1996:1 to 1996:4
    -.28  from 1997:1 to 1997:4
    -.49  from 1998:1 to 1998:4
    -.69  from 1999:1 to 1999:4
    -.69  from 2000:1 to 2000:4 (assuming nothing new) 

     Series values for GDP Deflator
    
    -.00  from 1995:1 to 1995:4
    -.06  from 1996:1 to 1996:4
    -.06  from 1997:1 to 1997:4
    -.08  from 1998:1 to 1998:4
    -.20  from 1999:1 to 1999:4
    -.20  from 2000:1 to 2000:4 (assuming nothing new)
@

local d1, d2, d3, d4, d5, i1, i2, i3, i4, i5, pcebias, eps,
   cpibias, gdpbias, f1,f2,f3,f4,f5,d6,i6,f6;
      
d1=1995+(1-1)/4; f1=1995+(4-1)/4;
d2=1996+(1-1)/4; f2=1996+(4-1)/4;
d3=1997+(1-1)/4; f3=1997+(4-1)/4;
d4=1998+(1-1)/4; f4=1998+(4-1)/4;
d5=1999+(1-1)/4; f5=1999+(4-1)/4;
d6=2000+(1-1)/4; f6=2000+(4-1)/4;
eps=.0001;
i1= (tdsq .>= d1-eps) .and (tdsq .< f1+eps);    
i2= (tdsq .>= d2-eps) .and (tdsq .< f2+eps);    
i3= (tdsq .>= d3-eps) .and (tdsq .< f3+eps);    
i4= (tdsq .>= d4-eps) .and (tdsq .< f4+eps);    
i5= (tdsq .>= d5-eps) .and (tdsq .< f5+eps);    
i6= (tdsq .>= d6-eps) .and (tdsq .< f6+eps);

pcebias= (-.12*i1) + (-.22*i2) + (-.28*i3) + (-.49*i4)+(-.69*i5)+(-.69*i6);
cpibias=pcebias;
gdpbias=(-.00*i1) + (-.06*i2) + (-.06*i3) + (-.08*i4)+(-.20*i5)+(-.20*i6);

retp(pcebias, cpibias, gdpbias);

endp;