proc(3) = infbiasg(tdsq);


@ -- Compute inflation bias -- here using 
     ERR, 1998 page 80, Table 2.4

     Series values for PCE and CPI
    
    -.1   from 1992:1 to 1994:4
    -.52  from 1995:1 to 1995:4
    -.72  from 1996:1 to 1996:4
    -.48  from 1997:1 to 1997:4
    -.59  from 1998:1 to 1998:4
    -.64  from 1999:1 to 1999:4

@

local d1, d2, d3, d4, d5, eps, i1, i2, i3, i4, i5, pcebias,
      cpibias, gdpbias, f1,f2,f3,f4,f5,d6,i6,f6;
d1=1992+(1-1)/4; f1=1994+(4-1)/4;
d2=1995+(1-1)/4; f2=1995+(4-1)/4;
d3=1996+(1-1)/4; f3=1996+(4-1)/4;
d4=1997+(1-1)/4; f4=1997+(4-1)/4;
d5=1998+(1-1)/4; f5=1998+(4-1)/4;
d6=1999+(1-1)/4; f6=1999+(4-1)/4;
eps=.0001;
i1= (tdsq .>= d1-eps) .and (tdsq .< f1+eps);    
i2= (tdsq .>= d2-eps) .and (tdsq .< f2+eps);    
i3= (tdsq .>= d3-eps) .and (tdsq .< f3+eps);    
i4= (tdsq .>= d4-eps) .and (tdsq .< f4+eps);    
i5= (tdsq .>= d5-eps) .and (tdsq .< f5+eps);    
i6= (tdsq .>= d6-eps) .and (tdsq .< f6+eps);
 
pcebias= (-.1*i1) + (-.52*i2) + (-.72*i3) + (-.48*i4)+(-.59*i5)+(-.64*i6);
cpibias=pcebias;
gdpbias=.7*pcebias;

retp(pcebias, cpibias, gdpbias);

endp;