proc(1) = mtoq(mdata,caldsm,caldsq,imeth);

/* -- Converts monthly observations to quarterly observations --
      
      mdata == monthly data series
      caldsm == Tx2 vector of dates (yr,mth) for monthly obs
      caldsq == Nx2 vector of dates (Yr,qtr) for quarterly obs

      imeth == 0  Average over quarter
               1  First Month of Quarter
               2  Second Month of Quarter
               3  Third month of Quarter
*/
local qdata, i, temp, itemp, iy, iq, im;

qdata=miss(zeros(rows(caldsq),1),0);

@ -- Check to make sure that mdata has correct number of observations -- @
if rows(mdata) ./= rows(caldsm);
 "Error in Procedure MTOQ -- wrong number of elements in mdata";
 "Rows of Mdata";;rows(mdata);
 "Rows of Caldsm";;rows(caldsm);
 retp(qdata);
endif;

@ -- Check to make imeth is in the correct bounds -- @
if imeth .> 3;
 "Error in Procedure MTOQ -- Invalid Value for Imeth";
 "Imeth";;imeth;
 retp(qdata);
endif;


temp=mdata;

if imeth .== 0; @ Form averages @
 temp=miss(zeros(rows(mdata),1),0);
 i=3; do while i <= rows(mdata);
  temp[i]=meanc(mdata[i-2:i]);
 i=i+1; endo;
 imeth=3;
endif;

i=1; do while i <= rows(caldsq);
 iy=caldsq[i,1]; @ Year @
 iq=caldsq[i,2]; @ Quarter @
 im=(3*(iq-1)) + imeth;    @ Month to use @
 itemp=(caldsm[.,1] .== iy) .and (caldsm[.,2] .== im);
 qdata[i]=selif(temp,itemp);
i=i+1; endo;

retp(qdata);
endp;
