proc(2) = myols(y,x);
@
     Modified by MWW, 8-19-98

     OLS and Classical Covariance Matrix Estimators
Input:
     y = tx1
     x = txk

Output:
     Beta = OLS estimate of beta (kx1)
    VBeta = Classical estimate of covariance matrix of beta (kxk)

@
local u, xxi, beta, vbeta, s2;
xxi=invpd(x'x);
beta=x'y/(x'x);
u=y-x*beta;
s2=(u'u)/(rows(x)-cols(x));
vbeta=s2*xxi;
retp(beta,vbeta);
endp;
