proc(8) = tvnairu(y,x,iu,clev,lam);

@ ---- Procedure for Computing NAIRU and confidence interval
       via tvp
       Confidence Intervals Computed ignoring parameter uncertainty
       (only state uncertainty is accounted for)

Input:
   y = dependent variable
   x = regressors
   iu = location of level of unemployment rate in X regressor
   clev = confidence level 
   lam = lambda value used in TV estimation

Output:
   ubar = estimate of NAIRU (smoothed)
   tvci = tx2 matrix of upper and lower CI bands  (smoothed)
   seubar = standard error of ubar (state uncertainty only) (smoothed)
   ubarf = estimate of NAIRU (filtered)
   seubarf = standard error of ubar (state uncertainty only) (filtered)
   ctt = smoothed value of constant
   sectt = se of smoothed value of constant
   pcslope == slope of PC
--------------------------------------------------------------------------- @
local nobs, xa, xxi, xy, e, vare, ba, b, bu, r, q, vague, x1, x2, x3, 
      p1, p2, p3, x1t, x2t, x3t, p1t, p2t, p3t, t, ubar, seubar, pv, 
      cval, dubar1, dubar2, y1, n, h, ubarf, seubarf, ctt, sectt;



nobs=rows(y);

@ -- Compute Regression Coefficients -- @
xa=ones(rows(x),1)~x;
xxi=invpd(xa'xa);
xy=xa'y;
ba=xxi*xy;
e=y-(xa*ba);
vare=(e'e)/(nobs-cols(xa));
b=ba[2:rows(ba)];

@ -- Extract Relevant Regressors, coefficients, etc. -- @
bu=b[iu];           @ U Coefficients @

r=vare;
q=(lam^2)*r/(nobs^2);
vague=1e+05;
x1t=miss(zeros(nobs,1),0);
x2t=miss(zeros(nobs,1),0);
p1t=miss(zeros(nobs,1),0);
p2t=miss(zeros(nobs,1),0);
x1=0;
p1=vague;

t=1; do while t<=nobs;
 x1t[t]=x1;
 p1t[t]=p1;
 y1=y[t]-x[t,.]*b;
 {x1,p1,x2,p2,n,h}=rwkfilt(y1,x1,p1,r,q);
 x2t[t]=x2;
 p2t[t]=p2;
t=t+1; endo;

x3t=miss(zeros(nobs,1),0);
x3=x1;
x3t[nobs]=x3;
p3t=miss(zeros(nobs,1),0);
p3=p1;
p3t[nobs]=p3;
t=nobs; do while t >= 2;
 x2=x2t[t];
 p2=p2t[t];
 x1=x1t[t];
 p1=p1t[t];
 {x3,p3}=rwksmth(x1,x2,x3,p1,p2,p3);
 x3t[t-1]=x3;
 p3t[t-1]=p3;
t=t-1; endo;

@ -- Compute NAIRU -- @
ubar=-x3t./bu;
seubar=abs(sqrt(p3t)./bu);

@ -- Compute Filtered Nairu -- @
ubarf=-x1t./bu;
seubarf=abs(sqrt(p1t)./bu);

@ -- Smoothed value of constant and SE -- @
ctt=x3t;
sectt=sqrt(p3t);

 @ -- Compute Critical Value of T-statistics -- @
 pv=1-( (1-clev)/2);
 cval=cdfni(pv);
 dubar1=ubar+(cval.*seubar);  @ Upper CI -- delta method @
 dubar2=ubar-(cval.*seubar);  @ Upper CI -- delta method @

retp(ubar,(dubar1~dubar2),seubar,ubarf,seubarf,ctt,sectt,bu);

endp;