/* -- VAR Procedures -- */

Proc(2) = var_comp(x,n1,n2,nar);

/*
   var_comp.prc,  mww 12/18/00
   This estimates a VAR and forms companion matrix

   
   Input:
   X = Txn vector of variables
   nar = number of lags in VAR
   n1 = first obs of X to use
   n2 = last obs of X to use

   
   (Note: this uses all possible obs between n1 and n2 -- if n1
          is too small, n1=1, for example, or n2 is too large
          the regression uses all obs that it can.)
   
   Output:
   C and G
   
   where:
   
   Z(t) = C*Z(t-1) + Ge(t)
   
   and var(e(t))=I
   
   Z is a ((nar*n) + 1) x 1 vector  (+ 1 for the constant term)
   G is ((nar*n) + 1) x n  
      
*/

local yv, xv, i, beta, e, seps, b, comp, ch, g, tmp;
n1=maxc(n1|nar+1);
n2=minc(n2|rows(x));


@ Set Up VAR @
yv=x[n1:n2,.];
xv=ones(rows(yv),1);
i=1; do while i<=nar;
  xv=xv~x[n1-i:n2-i,.];
i=i+1; endo;

tmp=yv~xv;
tmp=packr(tmp);
yv=tmp[.,1:cols(yv)];
xv=tmp[.,cols(yv)+1:cols(tmp)];

@ Estimate VAR @
beta=inv(xv'xv)*xv'yv;
e=yv-xv*beta;
seps=(e'e)/(rows(xv)-cols(xv));  @ Use Degrees of Freedom Adjustment @
b=beta[2:rows(beta),.]';

@ ---- Calculate Companion Matrix ---- @
comp=zeros(cols(b),cols(b));
comp[1:rows(b),.]=b;
if cols(b) .> rows(b);
 comp[rows(b)+1:rows(comp),1:cols(comp)-rows(b)]=eye(cols(comp)-rows(b));
endif;
@ -- Add Constant as last element of state vector -- @
comp=comp~zeros(rows(comp),1);
comp=comp|zeros(1,cols(comp));
comp[rows(comp),cols(comp)]=1;
@ -- Add intercepts -- @
comp[1:cols(x),cols(comp)]=beta[1,.]';
g=zeros(rows(comp),rows(seps));
ch=chol(seps);
g[1:rows(seps),.]=ch';

retp(comp,g);
endp;

/* ----------------------------------------------------- */
proc(1)=var_fcst(x,nar,comp,nph);
/*
   var_fcst.prc,  mww 12/18/00
   Compute VAR Foreasts from estimated VAR
   Estimated VAR summarized by companion Matrix COMP
   (A constant is added as LAST element of STATE vector!)
     
   Input:
   X = Txn vector of variables
   nar = number of lags in VAR
   COMP = Companion Matrix
   nph = number of period ahead for forecasts
   
   Output:
   Xfcst = nph x n matrix of forecasts      
*/

@ -- Construct Date T State Vector -- @
local s, i, xfcst;

s = x[rows(x),.]';
i=2; do while i <= nar;
 s=s|x[rows(x)+1-i,.]';
i=i+1; endo;
s=s|1;

@ -- Forecasts -- @
xfcst=miss(zeros(nph,cols(x)),0);
i=1; do while i <= nph;
 s=comp*s;
 xfcst[i.,]=s[1:cols(x)]';
i=i+1; endo;

retp(xfcst);
endp;

