/* This program merges state-level data from various sources */
log using "d:\wage phillips\stata\log\mk_suppx", replace
clear

/* initial dataset has state abb. and fips */
use "d:\wage phillips\stata\data\statex"
sort fips

/* merge on state-level productivity data from BEA */
merge fips using "d:\wage phillips\stata\data\prod_st"
tab _merge
drop _merge
sort abbrev year
save "d:\wage phillips\stata\data\temp", replace

/* merge on state-year level labor variables from various sources */
use "D:\wage phillips\stata\data\labvars", clear
sort abbrev year
merge abbrev year using "d:\wage phillips\stata\data\temp"
tab _merge
drop _merge
sort state year

/* merge on di/ssi variables from autor/duggan */
merge state year using "d:\wage phillips\stata\data\di-ssi-staiger"
drop if year<79
drop if abbrev=="DC"
tab _merge
drop _merge
sort year

/* merge on US aggregate/industry productivity numbers from BEA */
merge year using "d:\wage phillips\stata\data\prod_us"
drop if year<79
tab _merge
drop _merge

/* clean up and save */
replace cpi_ann=163.0 if year==98
replace cpi_ann=166.6 if year==99
gen cpi_99=166.6/cpi_ann
drop if state==94 | state==95
sort state year
save "d:\wage phillips\stata\data\suppx", replace
describe
summ
log close
