set more 1

/* 
   Create 'compatible' MSAs, based on consistent version of msa70
   for linking to CPI data by msa.
   This code should only be run after running geocode86/geocode94 so 
   that msa70 is available for all years in consistent fashion.
   
   Creates variable msa70a, with values 1-22 (missing for nonMSAs)

   D. Staiger, 12/28/00.
   
   
*/


   generate msa70a=.

   *New York, Northern NJ, and Long Island 
    replace msa70a =  1 if (msa70==1) | (msa70==9) | (msa70==15) | (msa70==23)

   *Philadelphia
    replace msa70a =  2 if (msa70==4)
   
   *Boston
    replace msa70a =  3 if (msa70==8)

   *Pittsburgh
    replace msa70a =  4 if (msa70==10)

   *Chicago, Gary
    replace msa70a =  5 if (msa70==3) | (msa70==53)

   *Cincinnati
    replace msa70a =  6 if (msa70==22)

   *Cleveland, Akron
    replace msa70a =  7 if (msa70==13) | (msa70==49)

   *Detroit
    replace msa70a =  8 if (msa70==5)

   *Kansas City
    replace msa70a =  9 if (msa70==27)

   *Milwaukee
    replace msa70a = 10 if (msa70==20)

   *Minneapolis, St. Paul
    replace msa70a = 11 if (msa70==16)

   *St. Louis
    replace msa70a = 12 if (msa70==11)

   *Atlanta
    replace msa70a = 13 if (msa70==21)

   *Dallas, Ft. Worth
    replace msa70a = 14 if (msa70==17) | (msa70==44)

   *Houston, Galveston, Brazoria
    replace msa70a = 15 if (msa70==14)

   *Miami
    replace msa70a = 16 if (msa70==26)

   *Denver
    replace msa70a = 17 if (msa70==28)

   *Los Angeles, Riverside, Orange county
    replace msa70a = 18 if (msa70==2) | (msa70==19) | (msa70==29)

   *Portland
    replace msa70a = 19 if (msa70==34)

   *San Diego
    replace msa70a = 20 if (msa70==24)

   *San Francisco, Oakland, San Jose
    replace msa70a = 21 if (msa70==6) | (msa70==31)

   *Seattle
    replace msa70a = 22 if (msa70==18)

