# delimit ;
set more 1;

log using "d:\wage phillips\stata\log\assemb-nairu-state", replace;

/* 

   Assemble nairu data by state by year.
   
   This program is the final step in the sequence.  Also see:
   
   mk_suppx.do       - compiles all the state-level covariates

   calcmeanperson.do - Calculates characteristics of mean person 79-99
                       
   prep-resid.do     - Calculates state-level cps means, resids, predictions
                       
   batch?.do         - runs prep-resid for each year & dataset
   
*/;

clear;
set mem 100m;

************************************************************************;
** Step 1: Assemble complete by year predicted mean wage data sets      ;
************************************************************************;

capture program drop ASSEMBYR;
program define ASSEMBYR;
   * Parameters: 1 - all, 1, 2;
   
   use "d:\wage phillips\stata\data\resid-state-79-ind-`1'", clear;
   replace year=79;
   append using "d:\wage phillips\stata\data\resid-state-80-ind-`1'";
   replace year=80 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-81-ind-`1'";
   replace year=81 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-82-ind-`1'";
   replace year=82 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-83-ind-`1'";
   replace year=83 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-84-ind-`1'";
   replace year=84 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-85-ind-`1'";
   replace year=85 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-86-ind-`1'";
   replace year=86 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-87-ind-`1'";
   replace year=87 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-88-ind-`1'";
   replace year=88 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-89-ind-`1'";
   replace year=89 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-90-ind-`1'";
   replace year=90 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-91-ind-`1'";
   replace year=91 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-92-ind-`1'";
   replace year=92 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-93-ind-`1'";
   replace year=93 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-94-ind-`1'";
   replace year=94 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-95-ind-`1'";
   replace year=95 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-96-ind-`1'";
   replace year=96 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-97-ind-`1'";
   replace year=97 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-98-ind-`1'";
   replace year=98 if year==.;
   append using "d:\wage phillips\stata\data\resid-state-99-ind-`1'";
   replace year=99 if year==.;

   sort state year;
   save "e:\temp\nairu7999-`1'",replace;
end;

ASSEMBYR 1;
ASSEMBYR 2;
ASSEMBYR all;

**************************************************************************;
** Step 2: Merge together, and then with supplemental state data  ********;
**************************************************************************;

clear;
use "e:\temp\nairu7999-all";
merge state year using "e:\temp\nairu7999-1";
tab _merge;
drop _merge;
sort state year;
merge state year using "e:\temp\nairu7999-2";
tab _merge;
drop _merge;
** drop AK, HI, and DC **;
drop if state==94 | state==95 | state==53;
sort state year;
merge state year using "d:\wage phillips\stata\data\suppx";
tab _merge;
drop _merge;

**************************************************************************;
** Step 3: save final dataset                                     ********;
**************************************************************************;

label var fips     "state fips code";
label var gsp      "gross state prod";
label var gspgr    "gross state prod growth";
label var emp      "BEA total employment";
label var empg     "BEA total emp growth";
label var prodgr   "labor productivity growth";
label var ssfrc    "fraction 25-64 on SSI";
label var difrc    "fraction 25-64 on DI";
label var bofrc    "fraction 25-64 on DI/SSI";
label var sscnt    "number 25-64 on SSI";
label var dicnt    "number 25-64 on DI";
label var bocnt    "number 25-64 on DI/SSI";
label var emp1     "US emp, ag/for/fish";
label var empg1    "US emp gr, ag/for/fish";
label var gsp1     "US gsp, ag/for/fish";
label var gspgr1   "US gsp gr, ag/for/fish";
label var prodgr1  "US prod gr, ag/for/fish";
label var emp2     "US emp, mining";
label var empg2    "US emp gr, mining";
label var gsp2     "US gsp, mining";
label var gspgr2   "US gsp gr, mining";
label var prodgr2  "US prod gr, mining";
label var emp3     "US emp, construction";
label var empg3    "US emp gr, construction";
label var gsp3     "US gsp, construction";
label var gspgr3   "US gsp gr, construction";
label var prodgr3  "US prod gr, construction";
label var emp4     "US emp, durable man";
label var empg4    "US emp gr, durable man";
label var gsp4     "US gsp, durable man";
label var gspgr4   "US gsp gr, durable man";
label var prodgr4  "US prod gr, durable man";
label var emp5     "US emp, non-dur man";
label var empg5    "US emp gr, non-dur man";
label var gsp5     "US gsp, non-dur man";
label var gspgr5   "US gsp gr, non-dur man";
label var prodgr5  "US prod gr, non-dur man";
label var emp6     "US emp, trans & util";
label var empg6    "US emp gr, trans & util";
label var gsp6     "US gsp, trans & util";
label var gspgr6   "US gsp gr, trans & util";
label var prodgr6  "US prod gr, trans & util";
label var emp7     "US emp, whlsl trade";
label var empg7    "US emp gr, whlsl trade";
label var gsp7     "US gsp, whlsl trade";
label var gspgr7   "US gsp gr, whlsl trade";
label var prodgr7  "US prod gr, whlsl trade";
label var emp8     "US emp, retail trade";
label var empg8    "US emp gr, retail trade";
label var gsp8     "US gsp, retail trade";
label var gspgr8   "US gsp gr, retail trade";
label var prodgr8  "US prod gr, retail trade";
label var emp9     "US emp, FIRE";
label var empg9    "US emp gr, FIRE";
label var gsp9     "US gsp, FIRE";
label var gspgr9   "US gsp gr, FIRE";
label var prodgr9  "US prod gr, FIRE";
label var emp10    "US emp, services";
label var empg10   "US emp gr, services";
label var gsp10    "US gsp, services";
label var gspgr10  "US gsp gr, services";
label var prodgr10 "US prod gr, services";
label var emp11    "US emp, govt";
label var empg11   "US emp gr, govt";
label var gsp11    "US gsp, govt";
label var gspgr11  "US gsp gr, govt";
label var prodgr11 "US prod gr, govt";
label var cpi_99   "CPI-U update to 1999$";
label var pce98    "PCE update to 1998$";

sort state year;
save "d:\wage phillips\stata\data\nairu7999-state-ind", replace;

describe;
summ;

log close;
