# delimit ;
set more 1;

log using "d:\wage phillips\stata\log\calcmeanperson", replace;

/* 

   Calculate the mean characteristics of workers in our NAIRU sample
   from 1979 - 1999 for all individuals in the labor force

   and save into the dataset:
   
   stmns7999  (with 1 obs)

   note that means are weighted within year, but each year given equal wieght
   
*/;

capture program drop WORKDATA;
program define WORKDATA;

   * Parameters: 
   * 1 - Year
   
   * Open source;
   clear;
   set mem 200m;
   set matsize 800;
   use "e:\morg\annual\morg`1'",clear;
   keep if age>=16;

* Drop nilf and flag unemployed;
if `1'<=88 {;
   drop if esr>3;
   gen byte ue=esr==3;
   };
if `1'>=89 & `1'<94 {;
   drop if lfsr89>4;
   gen byte ue = lfsr89==3 | lfsr89==4;
   };
if `1'>=94 {;
   drop if lfsr94>4;
   gen byte ue = lfsr94==3 | lfsr94==4;
   };

* Consistent education categories for regression;
if `1'<92 {;
  gen byte educ=gradeat - (gradecp==2);
  replace educ=0 if educ<0;
  gen byte ed1   = (educ==0);
  gen byte ed2   = (educ>=1 & educ<=4);
  gen byte ed3   = (educ>=5 & educ<=8);
  gen byte ed4   = (educ==9);
  gen byte ed5   = (educ==10);
  gen byte ed6   = (educ==11);
  gen byte edhsg = (educ==12 & gradecp==1);
  gen byte edsmc = (educ>=13 & educ<=15) | (educ==12 & gradecp==2);
  gen byte edclg = (educ==16 | educ==17);
  gen byte edgtc = (educ>17);

  };
   
if `1'>=92 {;
  gen byte ed1   = (grade92==31);
  gen byte ed2   = (grade92==32);
  gen byte ed3   = (grade92==33 | grade92==34);
  gen byte ed4   = (grade92==35);
  gen byte ed5   = (grade92==36);
  gen byte ed6   = (grade92==37);
  gen byte edhsg = (grade92==38 & grade92==39);
  gen byte edsmc = (grade92>=40 & grade92<=42);
  gen byte edclg = (grade92==43);
  gen byte edgtc = (grade92>=44 & grade92<=46);
   };


** Gender and race vars;
gen byte female= sex==2;
gen byte black = race==2;
gen byte other = race>2;
gen byte bfem=black*female;
gen byte ofem=other*female;

** Education-gender interactions;
gen byte fed1   = female*ed1  ;
gen byte fed2   = female*ed2  ;
gen byte fed3   = female*ed3  ;
gen byte fed4   = female*ed4  ;
gen byte fed5   = female*ed5  ;
gen byte fed6   = female*ed6  ;
gen byte fedhsg = female*edhsg;
gen byte fedsmc = female*edsmc;
gen byte fedclg = female*edclg;
gen byte fedgtc = female*edgtc;

** Potential experience;
if `1'<92 {;
  gen exp1=max(age-educ-6,0);
  };

if `1'>=92 {;
  * Impute years of schooling to get experience;

  replace race=3 if race>3;
  gen edyrs=.;

  * men, white;
  replace edyrs = .32  if (race==1 & sex==1 & (grade92 ==31|grade92==00));
  replace edyrs = 3.19 if (race==1 & sex==1 & grade92 ==32);
  replace edyrs = 7.24 if (race==1 & sex==1 & (grade92 ==33 | grade92==34));
  replace edyrs = 8.97 if (race==1 & sex==1 & grade92 == 35);
  replace edyrs = 9.92 if (race==1 & sex==1 & grade92 == 36);
  replace edyrs = 10.86 if (race==1 & sex==1 & grade92 ==37);
  replace edyrs = 11.58 if (race==1 & sex==1 & grade92 ==38);
  replace edyrs = 11.99 if (race==1 & sex==1 & grade92 ==39);
  replace edyrs = 13.48 if (race==1 & sex==1 & grade92 ==40);
  replace edyrs = 14.23 if (race==1 & sex==1 & (grade92 ==41 | grade92==42));
  replace edyrs = 16.17 if (race==1 & sex==1 & grade92 ==43);
  replace edyrs = 17.68 if (race==1 & sex==1 & grade92 ==44);
  replace edyrs = 17.71 if (race==1 & sex==1 & grade92 ==45);
  replace edyrs = 17.83 if (race==1 & sex==1 & grade92 ==46);
  
  * female, white;
  replace edyrs = 0.62 if (race==1 & sex==2 & (grade92 ==31|grade92==00));
  replace edyrs = 3.15 if (race==1 & sex==2 & grade92 ==32);
  replace edyrs = 7.23 if (race==1 & sex==2 & (grade92 ==33 | grade92==34));
  replace edyrs = 8.99 if (race==1 & sex==2 & grade92 == 35);
  replace edyrs = 9.95 if (race==1 & sex==2 & grade92 == 36);
  replace edyrs = 10.87 if (race==1 & sex==2 & grade92 ==37);
  replace edyrs = 11.73 if (race==1 & sex==2 & grade92 ==38);
  replace edyrs = 12.00 if (race==1 & sex==2 & grade92 ==39);
  replace edyrs = 13.35 if (race==1 & sex==2 & grade92 ==40);
  replace edyrs = 14.22 if (race==1 & sex==2 & (grade92 ==41 | grade92==42));
  replace edyrs = 16.15 if (race==1 & sex==2 & grade92 ==43);
  replace edyrs = 17.64 if (race==1 & sex==2 & grade92 ==44);
  replace edyrs = 17.00 if (race==1 & sex==2 & grade92 ==45);
  replace edyrs = 17.76 if (race==1 & sex==2 & grade92 ==46);
  
  * men, black;
  replace edyrs = .92  if (race==2 & sex==1 & (grade92 ==31|grade92==00));
  replace edyrs = 3.28 if (race==2 & sex==1 & grade92 ==32);
  replace edyrs = 7.04 if (race==2 & sex==1 & (grade92 ==33 | grade92==34));
  replace edyrs = 9.02 if (race==2 & sex==1 & grade92 == 35);
  replace edyrs = 9.91 if (race==2 & sex==1 & grade92 == 36);
  replace edyrs = 10.90 if (race==2 & sex==1 & grade92 ==37);
  replace edyrs = 11.41 if (race==2 & sex==1 & grade92 ==38);
  replace edyrs = 11.98 if (race==2 & sex==1 & grade92 ==39);
  replace edyrs = 13.57 if (race==2 & sex==1 & grade92 ==40);
  replace edyrs = 14.33 if (race==2 & sex==1 & (grade92 ==41 | grade92==42));
  replace edyrs = 16.13 if (race==2 & sex==1 & grade92 ==43);
  replace edyrs = 17.51 if (race==2 & sex==1 & grade92 ==44);
  replace edyrs = 17.83 if (race==2 & sex==1 & grade92 ==45);
  replace edyrs = 18.00 if (race==2 & sex==1 & grade92 ==46);
  
  * female, black;
  replace edyrs = 0.00 if (race==2 & sex==2 & (grade92 ==31|grade92==00));
  replace edyrs = 2.90 if (race==2 & sex==2 & grade92 ==32);
  replace edyrs = 7.03 if (race==2 & sex==2 & (grade92 ==33 | grade92==34));
  replace edyrs = 9.05 if (race==2 & sex==2 & grade92 == 35);
  replace edyrs = 9.99 if (race==2 & sex==2 & grade92 == 36);
  replace edyrs = 10.85 if (race==2 & sex==2 & grade92 ==37);
  replace edyrs = 11.64 if (race==2 & sex==2 & grade92 ==38);
  replace edyrs = 12.00 if (race==2 & sex==2 & grade92 ==39);
  replace edyrs = 13.43 if (race==2 & sex==2 & grade92 ==40);
  replace edyrs = 14.33 if (race==2 & sex==2 & (grade92 ==41 | grade92==42));
  replace edyrs = 16.04 if (race==2 & sex==2 & grade92 ==43);
  replace edyrs = 17.69 if (race==2 & sex==2 & grade92 ==44);
  replace edyrs = 17.40 if (race==2 & sex==2 & grade92 ==45);
  replace edyrs = 18.00 if (race==2 & sex==2 & grade92 ==46);
  
  * men, other;
  replace edyrs = .62  if (race>=3 & sex==1 & (grade92 ==31|grade92==00));
  replace edyrs = 3.24 if (race>=3 & sex==1 & grade92 ==32);
  replace edyrs = 7.14 if (race>=3 & sex==1 & (grade92 ==33 | grade92==34));
  replace edyrs = 9.00 if (race>=3 & sex==1 & grade92 == 35);
  replace edyrs = 9.92 if (race>=3 & sex==1 & grade92 == 36);
  replace edyrs = 10.88 if (race>=3 & sex==1 & grade92 ==37);
  replace edyrs = 11.50 if (race>=3 & sex==1 & grade92 ==38);
  replace edyrs = 11.99 if (race>=3 & sex==1 & grade92 ==39);
  replace edyrs = 13.53 if (race>=3 & sex==1 & grade92 ==40);
  replace edyrs = 14.28 if (race>=3 & sex==1 & (grade92 ==41 | grade92==42));
  replace edyrs = 16.15 if (race>=3 & sex==1 & grade92 ==43);
  replace edyrs = 17.60 if (race>=3 & sex==1 & grade92 ==44);
  replace edyrs = 17.77 if (race>=3 & sex==1 & grade92 ==45);
  replace edyrs = 17.92 if (race>=3 & sex==1 & grade92 ==46);
  
  * female, other;
  replace edyrs = 0.31 if (race>=3 & sex==2 & (grade92 ==31|grade92==00));
  replace edyrs = 3.03 if (race>=3 & sex==2 & grade92 ==32);
  replace edyrs = 7.13 if (race>=3 & sex==2 & (grade92 ==33 | grade92==34));
  replace edyrs = 9.02 if (race>=3 & sex==2 & grade92 == 35);
  replace edyrs = 9.97 if (race>=3 & sex==2 & grade92 == 36);
  replace edyrs = 10.86 if (race>=3 & sex==2 & grade92 ==37);
  replace edyrs = 11.69 if (race>=3 & sex==2 & grade92 ==38);
  replace edyrs = 12.00 if (race>=3 & sex==2 & grade92 ==39);
  replace edyrs = 13.47 if (race>=3 & sex==2 & grade92 ==40);
  replace edyrs = 14.28 if (race>=3 & sex==2 & (grade92 ==41 | grade92==42));
  replace edyrs = 16.10 if (race>=3 & sex==2 & grade92 ==43);
  replace edyrs = 17.67 if (race>=3 & sex==2 & grade92 ==44);
  replace edyrs = 17.20 if (race>=3 & sex==2 & grade92 ==45);
  replace edyrs = 17.88 if (race>=3 & sex==2 & grade92 ==46);

  assert edyrs!=.;
  gen exp1=max(age-edyrs-6,0);
  };

* Experience quartic interacted with gender;
gen exp2=exp1^2/100;
gen exp3=exp1^3/1000;
gen exp4=exp1^4/10000;
gen fexp1=female*exp1;
gen fexp2=female*exp2;
gen fexp3=female*exp3;
gen fexp4=female*exp4;


   * Generate major industry dummies;
   if `1'<=82 {;
      sort ind70;
      merge ind70 using "d:\wage phillips\stata\data\ind70";
      drop if _merge==2;
      assert _merge==3 if ind70!=.;
      drop _merge;
      };

   if `1'>82 & `1'<=91 {;
      sort ind80;
      merge ind80 using "d:\wage phillips\stata\data\ind80";
      drop if _merge==2;
      assert _merge==3 if ind80!=. & ind80!=991; ** 991 is unemployed ex-military **;
      drop _merge;
      };

   if `1'>=92 {;
      rename ind80 ind90;
      sort ind90;
      merge ind90 using "d:\wage phillips\stata\data\ind90";
      drop if _merge==2;
      assert _merge==3 if ind80!=.;
      drop _merge;
      };

   /* The major industries are as follows:

       1 - Agriculture, forestry and fisheries
       2 - Mining
       3 - Construction
       4 - Durable manufacturing
       5 - Nondurable manufacturing
       6 - Transportation
       7 - Communications
       8 - Utilities and sanitary services
       9 - Wholesale trade
      10 - Retail trade
      11 - FIRE
      12 - Private households
      13 - Business and repair
      14 - Personal services
      15 - Entertainment and recreation
      16 - Hospitals
      17 - Health services except hospitals
      18 - Education
      19 - Social services
      20 - Misc. professional services
      21 - Forestry, fishing, hunting and trapping
      22 - Public administration

      We will aggregate further to:

      inagri - Agriculture
      inmine - Mining
      intran - Transport/communications/utilities
      inmand - Durable manufacturing
      inmann - Non-durable manufacturing
      incons - Construction
      inwtrd - Wholesale
      inrtrd - Retail
      infire - FIRE
      insvcs - Services
      ingovt - Government

   */;

   ** Agregate industries;
   rename mind7090 mind;
   gen byte inagri = mind==1 | mind==21;
   gen byte inmine = mind==2;
   gen byte intran = mind==6 | mind==7 | mind==8;
   gen byte inmand = mind==4;
   gen byte inmann = mind==5;
   gen byte incons = mind==3;
   gen byte inwtrd = mind==9;
   gen byte inrtrd = mind==10;
   gen byte infire = mind==11;
   gen byte insvcs = mind>=12 & mind<=20;
   gen byte ingovt = mind==22;
   assert (inagri+inmine+intran+inmand+inmann+incons+inwtrd+inrtrd+infire+insvcs
          +ingovt==1) | ind7090==.;
   gen byte inmiss= ind7090==.;


replace earnwt=earnwt/12;


   **********************************************************************;
   * Take means for each sample;
   **********************************************************************;
   collapse (mean)
           ed1-ed6  edsmc edclg edgtc
           fed1-fed6 fedsmc fedclg fedgtc
           exp1-exp4
           fexp1-fexp4
           female black other bfem ofem
           inagri inmine intran inmand inmann incons inwtrd inrtrd infire ingovt inmiss
   [aw=earnwt];
   save "d:\wage phillips\stata\data\stmns`1'",replace;
   
end;

**************************************************************************;
** Let's do it                                                          **;
**************************************************************************;

WORKDATA 79;
WORKDATA 80;
WORKDATA 81;
WORKDATA 82;
WORKDATA 83;
WORKDATA 84;
WORKDATA 85;
WORKDATA 86;
WORKDATA 87;
WORKDATA 88;
WORKDATA 89;
WORKDATA 90;
WORKDATA 91;
WORKDATA 92;
WORKDATA 93;
WORKDATA 94;
WORKDATA 95;
WORKDATA 96;
WORKDATA 97;
WORKDATA 98;
WORKDATA 99;

**************************************************************************;
** Now append and collapse                                              **;
**************************************************************************;

clear;
use "d:\wage phillips\stata\data\stmns79";
append using "d:\wage phillips\stata\data\stmns80";
append using "d:\wage phillips\stata\data\stmns81";
append using "d:\wage phillips\stata\data\stmns82";
append using "d:\wage phillips\stata\data\stmns83";
append using "d:\wage phillips\stata\data\stmns84";
append using "d:\wage phillips\stata\data\stmns85";
append using "d:\wage phillips\stata\data\stmns86";
append using "d:\wage phillips\stata\data\stmns87";
append using "d:\wage phillips\stata\data\stmns88";
append using "d:\wage phillips\stata\data\stmns89";
append using "d:\wage phillips\stata\data\stmns90";
append using "d:\wage phillips\stata\data\stmns91";
append using "d:\wage phillips\stata\data\stmns92";
append using "d:\wage phillips\stata\data\stmns93";
append using "d:\wage phillips\stata\data\stmns94";
append using "d:\wage phillips\stata\data\stmns95";
append using "d:\wage phillips\stata\data\stmns96";
append using "d:\wage phillips\stata\data\stmns97";
append using "d:\wage phillips\stata\data\stmns98";
append using "d:\wage phillips\stata\data\stmns99";

summ;

collapse (mean)
           ed1-ed6  edsmc edclg edgtc
           fed1-fed6 fedsmc fedclg fedgtc
           exp1-exp4
           fexp1-fexp4
           female black other bfem ofem
           inagri inmine intran inmand inmann incons inwtrd inrtrd infire ingovt inmiss
           ;
gen sample=1;

   save "d:\wage phillips\stata\data\stmns7999",replace;


log close;
