set more 1

/* 
   Create 'compatible' MSAs for linking to pre-19995 CPS changeover.
   This code valid for CPS data 1/95 forward.
   
   D. Autor, 7/23/98.
   
   We code here:
   
   1) MSAs compatible with 1970 rankings
   2) Non-MSA areas by state
   3) Other MSAs which were suppressed in 1970s but visible post 1985

*/


   generate msa70=.

   *New York 
      * New York City
     replace msa70 =  1 if (msafips == 5600)
      * Nassau-Suffolk
     replace msa70 =  9 if (msafips == 5380)
      * Newark
     replace msa70 = 15 if (msafips == 5640)
      * Patterson-Clifton-Passaic
     replace msa70 = 23 if (msafips == 875)

   *Los Angeles
      * Los Angeles-Long Beach
     replace msa70 =  2 if (msafips == 4480)
      * Anaheim-Santa Ana
     replace msa70 = 19 if (msafips == 360)
      * San Bernardino-Riverside-Ontario
     replace msa70 = 29 if (msafips == 6780)

   *Chicago

     /*  This was the line of code that Otoo had for Chicago PMSA but I do not agree that
         Lake County should be part of Chicago MSA and hence do not merge it here:
         replace msa70 =  3 if (msafips == 3 & (pmsarank == 1 | pmsarank == 3 | pmsarank == 4 | pmsarank == 5)) */
      * Chicago 
     replace msa70 =  3 if (msafips == 1600)
      * Gary
     replace msa70 = 53 if (msafips == 2960)

   *Philadelphia
      * Philadelphia
     replace msa70 =  4 if (msafips == 6160)

   *Detroit
      * Detroit
     replace msa70 =  5 if (msafips == 2160)

   *San Francisco-Oakland-San Jose
      * San Francisco-Oakland
     replace msa70 =  6 if (msafips == 7360 | msafips == 5775)
      * San Jose
     replace msa70 = 31 if (msafips == 7400)

   *Washington
      * Washington
     replace msa70 =  7 if (msafips == 8840)

   *Boston 
      * Boston
     replace msa70 =  8 if (msafips == 1120)

   *Pittsburgh
      * Pittsburgh
     replace msa70 = 10 if (msafips == 6280)

   *St. Louis
      * St. Louis
     replace msa70 = 11 if (msafips == 7040)
     ** Drop newly identified IL fraction for consistency with old series
     replace msa70=. if msa70==1 & state==33

   *Baltimore 
      * Baltimore 
     replace msa70 = 12 if (msafips == 720)

   *Cleveland-Akron-Lorain
      * Cleveland
     replace msa70 = 13 if (msafips == 1680)
      * Akron
     replace msa70 = 49 if (msafips == 80)

   *Houston-Galveston-Brazoria
      * Houston-Brazoria
     replace msa70 = 14 if (msafips == 3360 | msafips == 1145)

   *Minneapolis-St. Paul
      * Minneapolis-St. Paul
     replace msa70 = 16 if (msafips == 5120)

   *Dallas-Fort Worth
      * Dallas
     replace msa70 = 17 if (msafips == 1920)
      * Fort Worth-Arlington
     replace msa70 = 44 if (msafips == 2800)

   *Seattle-Tacoma
      * Seattle
     replace msa70 = 18 if (msafips == 7600)

   *Milwaukee-Racine
      * Milwaukee
     replace msa70 = 20 if (msafips == 5080)

   *Atlanta
      * Atlanta
     replace msa70 = 21 if (msafips == 520)

   *Cincinnati
      * Cincinnati
     replace msa70 = 22 if (msafips == 1640)

   *San Diego
      * San Diego
     replace msa70 = 24 if (msafips == 7320)

   *Buffalo-Niagara Falls
      * Buffalo, Niagara Falls
     replace msa70 = 25 if (msafips == 1280 | msafips == 5700)

   *Miami-Fort Lauderdale
      * Miami-Hialeah
     replace msa70 = 26 if (msafips == 5000)

   *Kansas City
      * Kansas City
     replace msa70 = 27 if (msafips == 3760)

   *Denver-Boulder
      * Denver-Boulder 
     replace msa70 = 28 if (msafips == 2080 | msafips == 1125)

   *Indianapolis 
      * Indianapolis
     replace msa70 = 30 if (msafips == 3480)

   *New Orleans
      * New Orleans
     replace msa70 = 32 if (msafips == 5560)

   *Tampa
      * Tampa
     replace msa70 = 33 if (msafips == 8280)

   *Portland-Vancouver
      * Portland-Vancouver
     replace msa70 = 34 if (msafips == 6440 | msafips == 8725)

   *Columbus
      * Columbus
     replace msa70 = 36 if (msafips == 1840)

   *Rochester
      * Rochester
     replace msa70 = 38 if (msafips == 6840)

   *Sacramento
      * Sacramento
     replace msa70 = 42 if (msafips == 6920)

   *Birmingham
      * Birmingham 
     replace msa70 = 45 if (msafips == 1000)

   *Albany 
      * Albany
     replace msa70 = 46 if (msafips == 160)

   *Norfolk-Virginia Beach-Newport News
      * Norfolk
     replace msa70 = 48 if (msafips == 5720)

   *Greensboro
      * Greensboro
     replace msa70 = 57 if (msafips == 3120)

   gen msa85 = msa70
   replace msa70=state*100 if msa70==.

   **********************************************************************
   ** Code MSAs that did not become publicly available until 1985      **
   **********************************************************************

   * Jersey City
     replace msa85 = 56 if (msafips == 3640)

   * Wilmington
     replace msa85 = 67 if (msafips == 9160)

   * Tacoma
     replace msa85 = 72 if (msafips == 8200)

   * Fort Lauderdale
     replace msa85 = 55 if (msafips == 2680)

   *Phoenix 
      * Phoenix
     replace msa85 = 35 if (msafips == 6200)

   *Providence
      * Providence
     replace msa85 = 37 if (msafips == 6480 | msafips == 6060)

   *San Antonio
      * San Antonio
     replace msa85 = 39 if (msafips == 7240)

   *Dayton-Springfield 
      * Dayton
     replace msa85 = 40 if (msafips == 2000)

   *Louisville
      * Louisville
     replace msa85 = 41 if (msafips == 4520)

   *Memphis
      * Memphis
     replace msa85 = 43 if (msafips == 4920)

   *Toledo 
      * Toledo 
     replace msa85 = 47 if (msafips == 8400)

   *Hartford 
      * Hartford
     replace msa85 = 50 if (msafips == 3280)

   *Oklahoma City
      * Oklahoma City
     replace msa85 = 51 if (msafips == 5880)

   *Syracuse
      * Syracuse
     replace msa85 = 52 if (msafips == 8160)

   *Honolulu 
      * Honolulu
     replace msa85 = 54 if (msafips == 3320)

   *Salt Lake City-Ogden
      * Salt Lake City-Ogden
     replace msa85 = 58 if (msafips == 7160)

   *Allentown-Bethlehem-Easton
      * Allentown-Bethlehem-Easton
     replace msa85 = 59 if (msafips == 240)

   *Omaha
      * Omaha
     replace msa85 = 60 if (msafips == 5920)

   *Nashville
      * Nashville
     replace msa85 = 61 if (msafips == 5360)

   *Grand Rapids
      * Grand Rapids
     replace msa85 = 62 if (msafips == 3000)

   *Youngstown-Warren
      * Youngstown-Warren
     replace msa85 = 63 if (msafips == 9320)

   *Springfield-Chicopee-Holyoke
      * Springfield
     replace msa85 = 64 if (msafips == 8000)

   *Jacksonville
      * Jacksonville
     replace msa85 = 65 if (msafips == 3600)

   *Richmond
      * Richmond
     replace msa85 = 66 if (msafips == 6760)

   *Flint 
      * Flint 
     replace msa85 = 68 if (msafips == 2640)

   *Tulsa 
      * Tulsa 
     replace msa85 = 69 if (msafips == 8560)

   *Orlando
      * Orlando
     replace msa85 = 70 if (msafips == 5960)

   *Fresno
      * Fresno
     replace msa85 = 71 if (msafips == 2840)

   *Harrisburg
      * Harrisburg 
     replace msa85 = 73 if (msafips == 3240)

   *Charlotte
      * Charlotte
     replace msa85 = 74 if (msafips == 1520)

   *Knoxville
      * Knoxville
     replace msa85 = 75 if (msafips == 3840)

   * Use balance of state (for non-MSA85 area) if still no MSA assigned
   replace msa85 = state*100 if msa85==.

