# delimit ;



set more 1;

log using "d:\wage phillips\stata\replication\ssw_final_state", replace;

log off;

/* 

   Do final runs on the state data.
   This has some runs added after the conference
 
*/;

clear;
set mem 100m;
set matsize 800;

** Read the data **;

use "d:\wage phillips\stata\data\nairu7999-state-ind";
sort state year;


** make cpi inflation variable -- 100 percent **;
quietly by state: gen cpiinf = 100*(log(cpi_ann)-log(cpi_ann[_n-1]));
quietly by state: replace cpiinf = 100*(log(cpi_ann)-log(65.2)) if year==79;

gen region = 0;
replace region = 1 if state>10 & state<30;
replace region = 2 if state>30 & state<50;
replace region = 3 if state>50 & state<80;
replace region = 4 if state>80 & state<100;

gen divis = int(state/10);


** this is a fix for some variable names **;
rename m_wghrly m_wghrl;
rename m_thshrl m_thsh1;
rename marmale marmal;
rename marmale1 marmal1;
rename marmale2 marmal2;
rename cbthshr2 cbths2;
rename cbthshr1 cbths1;

** Create the wage growth variables **;
  ** will be done for all, 1 and 2 with mkvar1 **;

** this program will make real difs/lags of wages, 100 percent **;
capture program drop mkdif1;
program define mkdif1;
   * Parameters: 1 - variable name, 6 char or less;
   *             2 - blank, 1 or 2 indicating sample;
   replace `1' = 100*`1';
   quietly by state: gen d_`1' = (`1'[_n+1]-`1') - cpiinf[_n+1] - prodgr[_n+1];
   quietly by state: gen d1`1' = d_`1'[_n-1];
   quietly by state: gen d2`1' = d_`1'[_n-2];
   quietly by state: gen d3`1' = d_`1'[_n-3];
   quietly by state: gen e_`1' = (`1'[_n+1]-`1') - cpiinf - prodgr;
   quietly by state: gen e1`1' = e_`1'[_n-1];
   quietly by state: gen e2`1' = e_`1'[_n-2];
   quietly by state: gen e3`1' = e_`1'[_n-3];
   quietly by state: gen d_x`1' = (`1'[_n+1]-`1') - cpiinf[_n+1] - prdgx`2'[_n+1];
   quietly by state: gen d1x`1' = d_`1'[_n-1];
   quietly by state: gen d2x`1' = d_`1'[_n-2];
   quietly by state: gen d3x`1' = d_`1'[_n-3];
   quietly by state: gen e_x`1' = (`1'[_n+1]-`1') - cpiinf - prdgx`2';
   quietly by state: gen e1x`1' = e_`1'[_n-1];
   quietly by state: gen e2x`1' = e_`1'[_n-2];
   quietly by state: gen e3x`1' = e_`1'[_n-3];
   quietly by state: gen d_0`1' = (`1'[_n+1]-`1') - cpiinf[_n+1];
   quietly by state: gen d10`1' = d_`1'[_n-1];
   quietly by state: gen d20`1' = d_`1'[_n-2];
   quietly by state: gen d30`1' = d_`1'[_n-3];
   quietly by state: gen e_0`1' = (`1'[_n+1]-`1') - cpiinf;
   quietly by state: gen e10`1' = e_`1'[_n-1];
   quietly by state: gen e20`1' = e_`1'[_n-2];
   quietly by state: gen e30`1' = e_`1'[_n-3];
end;

** this program will make difs/lags of unem/prod, 100 percent **;
capture program drop mkdif2;
program define mkdif2;
   * Parameters: 1 - variable name, 6 char or less;
   replace `1' = 100*`1';
   quietly by state: gen d_`1' = (`1'-`1'[_n-1]);
   quietly by state: gen d1`1' = d_`1'[_n-1];
   quietly by state: gen d2`1' = d_`1'[_n-2];
   quietly by state: gen c_`1' = (`1'[_n+1]);
end;

** this program subtracts means off of control variables;
capture program drop dmean;
program define dmean;
   * Parameters: 1 - variable name, 2 - first year, 3 - last year;
   quietly summ `1' if year>=`2' & year<=`3';
   replace `1' = `1' - r(mean);
end;

** this program subtracts means off of control variables & multiplies by 100;
capture program drop dmeanp;
program define dmeanp;
   * Parameters: 1 - variable name, 2 - first year, 3 - last year;
   quietly summ `1' if year>=`2' & year<=`3';
   replace `1' = 100*(`1' - r(mean));
end;


** this program does all the variable creation for all, 1 or 2 **;
capture program drop mkvar1;
program define mkvar1;
   * Parameters: 1 - " ", 1 or 2;

   * productivity measures;
   gen prdgx`1' = (prodgr1*inagri`1' + prodgr2*inmine`1' + prodgr3*incons`1' +
                  prodgr4*inmand`1' + prodgr5*inmann`1' + prodgr6*intran`1' +
                  prodgr7*inwtrd`1' + prodgr8*inrtrd`1' + prodgr9*infire`1' + 
                  prodgr10*insvcs`1' + prodgr11*ingovt`1')/(1-inmiss);
   mkdif2 prdgx`1';
   gen empgx`1' = (empg1*inagri`1' + empg2*inmine`1' + empg3*incons`1' +
                  empg4*inmand`1' + empg5*inmann`1' + empg6*intran`1' +
                  empg7*inwtrd`1' + empg8*inrtrd`1' + empg9*infire`1' + 
                  empg10*insvcs`1' + empg11*ingovt`1')/(1-inmiss);
   mkdif2 empgx`1';
   gen gspgx`1' = (gspgr1*inagri`1' + gspgr2*inmine`1' + gspgr3*incons`1' +
                  gspgr4*inmand`1' + gspgr5*inmann`1' + gspgr6*intran`1' +
                  gspgr7*inwtrd`1' + gspgr8*inrtrd`1' + gspgr9*infire`1' + 
                  gspgr10*insvcs`1' + gspgr11*ingovt`1')/(1-inmiss);
   mkdif2 gspgx`1';



   * wages;
   rename m_wghr`1' mhr`1';
   mkdif1 mhr`1' `1';
   rename m_wgft`1' mft`1';
   mkdif1 mft`1' `1';
   rename m_wghrl`1' mhy`1';
   mkdif1 mhy`1' `1';
   mkdif1 ehr`1' `1';
   mkdif1 eft`1' `1';
   rename ehrly`1' ehy`1';
   mkdif1 ehy`1' `1';
   mkdif1 phr`1' `1';
   mkdif1 pft`1' `1';
   rename phrly`1' phy`1';
   mkdif1 phy`1' `1';
   rename lnwkw`1' lww`1';
   mkdif1 lww`1' `1';
   rename lnftw`1' lfw`1';
   mkdif1 lfw`1' `1';
   rename mdlnhw`1' mdhw`1';
   mkdif1 mdhw`1' `1';
   rename mdlnww`1' mdww`1';
   mkdif1 mdww`1' `1';
   rename mdlnftw`1' mdfw`1';
   mkdif1 mdfw`1' `1';

   * unemployment;
   mkdif2 m_ue`1';
   mkdif2 eue`1';
   mkdif2 euei`1';
   mkdif2 pue`1';
   mkdif2 puei`1';

   * make interactions with pue;
   gen r1p`1' = (region==1)*pue`1';
   gen r2p`1' = (region==2)*pue`1';
   gen r3p`1' = (region==3)*pue`1';
   gen r4p`1' = (region==4)*pue`1';
   gen dv1p`1' = (divis==1)*pue`1';
   gen dv2p`1' = (divis==2)*pue`1';
   gen dv3p`1' = (divis==3)*pue`1';
   gen dv4p`1' = (divis==4)*pue`1';
   gen dv5p`1' = (divis==5)*pue`1';
   gen dv6p`1' = (divis==6)*pue`1';
   gen dv7p`1' = (divis==7)*pue`1';
   gen dv8p`1' = (divis==8)*pue`1';
   gen dv9p`1' = (divis==9)*pue`1';
   gen ge92p`1' = (year>=92)*pue`1';
   gen le84p`1' = (year<=84)*pue`1';
   gen y80p`1' = (year==80)*pue`1';
   gen y81p`1' = (year==81)*pue`1';
   gen y82p`1' = (year==82)*pue`1';
   gen y83p`1' = (year==83)*pue`1';
   gen y84p`1' = (year==84)*pue`1';
   gen y85p`1' = (year==85)*pue`1';
   gen y86p`1' = (year==86)*pue`1';
   gen y87p`1' = (year==87)*pue`1';
   gen y88p`1' = (year==88)*pue`1';
   gen y89p`1' = (year==89)*pue`1';
   gen y90p`1' = (year==90)*pue`1';
   gen y91p`1' = (year==91)*pue`1';
   gen y92p`1' = (year==92)*pue`1';
   gen y93p`1' = (year==93)*pue`1';
   gen y94p`1' = (year==94)*pue`1';
   gen y95p`1' = (year==95)*pue`1';
   gen y96p`1' = (year==96)*pue`1';
   gen y97p`1' = (year==97)*pue`1';
   gen y98p`1' = (year==98)*pue`1';

   * make interactions with m_ue;
   gen r1m`1' = (region==1)*m_ue`1';
   gen r2m`1' = (region==2)*m_ue`1';
   gen r3m`1' = (region==3)*m_ue`1';
   gen r4m`1' = (region==4)*m_ue`1';
   gen dv1m`1' = (divis==1)*m_ue`1';
   gen dv2m`1' = (divis==2)*m_ue`1';
   gen dv3m`1' = (divis==3)*m_ue`1';
   gen dv4m`1' = (divis==4)*m_ue`1';
   gen dv5m`1' = (divis==5)*m_ue`1';
   gen dv6m`1' = (divis==6)*m_ue`1';
   gen dv7m`1' = (divis==7)*m_ue`1';
   gen dv8m`1' = (divis==8)*m_ue`1';
   gen dv9m`1' = (divis==9)*m_ue`1';
   gen ge92m`1' = (year>=92)*m_ue`1';
   gen le84m`1' = (year<=84)*m_ue`1';
   gen y80m`1' = (year==80)*m_ue`1';
   gen y81m`1' = (year==81)*m_ue`1';
   gen y82m`1' = (year==82)*m_ue`1';
   gen y83m`1' = (year==83)*m_ue`1';
   gen y84m`1' = (year==84)*m_ue`1';
   gen y85m`1' = (year==85)*m_ue`1';
   gen y86m`1' = (year==86)*m_ue`1';
   gen y87m`1' = (year==87)*m_ue`1';
   gen y88m`1' = (year==88)*m_ue`1';
   gen y89m`1' = (year==89)*m_ue`1';
   gen y90m`1' = (year==90)*m_ue`1';
   gen y91m`1' = (year==91)*m_ue`1';
   gen y92m`1' = (year==92)*m_ue`1';
   gen y93m`1' = (year==93)*m_ue`1';
   gen y94m`1' = (year==94)*m_ue`1';
   gen y95m`1' = (year==95)*m_ue`1';
   gen y96m`1' = (year==96)*m_ue`1';
   gen y97m`1' = (year==97)*m_ue`1';
   gen y98m`1' = (year==98)*m_ue`1';

   * demean control variables;
   dmeanp m_thshr`1' 79 97;
   dmeanp m_thsh1`1' 79 97;
   dmeanp m_thsft`1' 79 97;
   dmeanp ths`1' 79 97;
   dmeanp hsd`1' 79 97;
   dmeanp hsg`1' 79 97;
   dmeanp smc`1' 79 97;
   dmeanp clg`1' 79 97;
   dmeanp gtc`1' 79 97;
   dmeanp rs_wm`1' 79 97;
   dmeanp rs_wf`1' 79 97;
   dmeanp rs_bm`1' 79 97;
   dmeanp rs_bf`1' 79 97;
   dmeanp rs_om`1' 79 97;
   dmeanp rs_of`1' 79 97;
   dmeanp m1619`1' 79 97;
   dmeanp m2024`1' 79 97;
   dmeanp m2554`1' 79 97;
   dmeanp m5564`1' 79 97;
   dmeanp m65up`1' 79 97;
   dmeanp f1619`1' 79 97;
   dmeanp f2024`1' 79 97;
   dmeanp f2554`1' 79 97;
   dmeanp f5564`1' 79 97;
   dmeanp f65up`1' 79 97;
   dmeanp inagri`1' 79 97;
   dmeanp inmine`1' 79 97;
   dmeanp intran`1' 79 97;
   dmeanp inmand`1' 79 97;
   dmeanp inmann`1' 79 97;
   dmeanp incons`1' 79 97;
   dmeanp inwtrd`1' 79 97;
   dmeanp inrtrd`1' 79 97;
   dmeanp infire`1' 79 97;
   dmeanp insvcs`1' 79 97;
   dmeanp ingovt`1' 79 97;
   dmeanp inmiss`1' 79 97;
   dmeanp unmem`1' 79 97;
   dmeanp uncov`1' 79 97;
   dmeanp se`1' 79 97;
   dmeanp smsa`1' 79 97;
   dmeanp marfem`1' 79 97;
   dmeanp marmal`1' 79 97;

end;

** common state variables (must be done before running mkdif1, mkvar 1);

mkdif2 prodgr;
mkdif2 empg;
mkdif2 gspgr;
mkdif2 iur;


** do mkvar ;
mkvar1 1;
mkvar1 2;
mkvar1 ;

** more common state variables ;

replace minwg=minwg*cpi_99;
sort state year;
quietly by state: gen dminwg=100*(ln(minwg[_n+1])-ln(minwg));
dmean minwg 79 97;
dmean dminwg 79 97;
dmeanp rrate 79 97;
dmean awben 79 97;
dmean maxben 79 97;
dmean maxm2 79 97;
dmean maxnk 79 97;
dmeanp cbthshr 79 97;
dmeanp cbths1 79 97;
dmeanp cbths2 79 97;
dmeanp ssfrc 79 97;
dmeanp difrc 79 97;
dmeanp bofrc 79 97;


** generate year and state dummies **;
gen d80=year==80;
gen d81=year==81;
gen d82=year==82;
gen d83=year==83;
gen d84=year==84;
gen d85=year==85;
gen d86=year==86;
gen d87=year==87;
gen d88=year==88;
gen d89=year==89;
gen d90=year==90;
gen d91=year==91;
gen d92=year==92;
gen d93=year==93;
gen d94=year==94;
gen d95=year==95;
gen d96=year==96;
gen d97=year==97;
gen d98=year==98;
gen d99=year==99;

tab state, gen(ds);

** simplify demographic variables **;
gen cgrad = (clg+gtc);
gen cgrad1 = (clg1+gtc1);
gen cgrad2 = (clg2+gtc2);
gen white = (rs_wm+rs_wf);
gen white1 = (rs_wm1+rs_wf1);
gen white2 = (rs_wm2+rs_wf2);
gen female = (rs_wf+rs_bf+rs_of);
gen female1 = (rs_wf1+rs_bf1+rs_of1);
gen female2 = (rs_wf2+rs_bf2+rs_of2);
gen a2554 = (m2554+f2554);
gen a25541 = (m25541+f25541);
gen a25542 = (m25542+f25542);

** create mark's variable for change in wage;

sort state year;
quietly by state: gen wgr = mhr-mhr[_n-1];
quietly by state: gen wgrp = wgr - prodgr;
quietly by state: gen d_wgr = wgr[_n+1]-wgr;
quietly by state: gen d_wgrp = wgrp[_n+1]-wgrp;
quietly by state: gen wgr1 = mhr1-mhr1[_n-1];
quietly by state: gen wgrp1 = wgr1 - prodgr;
quietly by state: gen d_wgr1 = wgr1[_n+1]-wgr1;
quietly by state: gen d_wgrp1 = wgrp1[_n+1]-wgrp1;
quietly by state: gen wgr2 = mhr2-mhr2[_n-1];
quietly by state: gen wgrp2 = wgr2 - prodgr;
quietly by state: gen d_wgr2 = wgr2[_n+1]-wgr2;
quietly by state: gen d_wgrp2 = wgrp2[_n+1]-wgrp2;


** This program sets up needed globals **;
capture program drop mkglobal;
program define mkglobal;
    * parameters: none ;

    global test1 = "_b[ds1]+_b[ds2]+_b[ds3]+_b[ds4]+_b[ds5]+_b[ds6]+_b[ds7]+_b[ds8]";
    global test2 = "_b[ds9]+_b[ds10]+_b[ds11]+_b[ds12]+_b[ds13]+_b[ds14]+_b[ds15]+_b[ds16]";
    global test3 = "_b[ds17]+_b[ds18]+_b[ds19]+_b[ds20]+_b[ds21]+_b[ds22]+_b[ds23]+_b[ds24]";
    global test4 = "_b[ds25]+_b[ds26]+_b[ds27]+_b[ds28]+_b[ds29]+_b[ds30]+_b[ds31]+_b[ds32]";
    global test5 = "_b[ds33]+_b[ds34]+_b[ds35]+_b[ds36]+_b[ds37]+_b[ds38]+_b[ds39]+_b[ds40]";
    global test6 = "_b[ds41]+_b[ds42]+_b[ds43]+_b[ds44]+_b[ds45]+_b[ds46]+_b[ds47]+_b[ds48]";

    * educ, high school grad is omitted;
     global educ = "hsd cgrad";
     global educ1 = "hsd1 cgrad1";
     global educ2 = "hsd2 cgrad2";
     global educ1a = "hsd=hsd1 cgrad=cgrad1";
     global educ2a = "hsd=hsd2 cgrad=cgrad2";
    * industry;
     global indust = "inmand inmann inrtrd insvcs";
     global indust1 = "inmand1 inmann1 inrtrd1 insvcs1";
     global indust2 = "inmand2 inmann2 inrtrd2 insvcs2";
     global indust1a = "inmand=inmand1 inmann=inmann1 inrtrd=inrtrd1 insvcs=insvcs1";
     global indust2a = "inmand=inmand2 inmann=inmann2 inrtrd=inrtrd2 insvcs=insvcs2";
    * interactions with pue;
     global regpue = "r1p r2p r4p";
     global regpue1 = "r1p1 r2p1 r4p1";
     global regpue1a = "r1p=r1p1 r2p=r2p1 r4p=r4p1";
     global regpue2 = "r1p2 r2p2 r4p2";
     global divpue = "dv1p dv2p dv3p dv4p dv6p dv7p dv8p dv9p";
     global divpue1 = "dv1p1 dv2p1 dv3p1 dv4p1 dv6p1 dv7p1 dv8p1 dv9p1";
     global divpue2 = "dv1p2 dv2p2 dv3p2 dv4p2 dv6p2 dv7p2 dv8p2 dv9p2";
     global gyrpue = "le84p ge92p";
     global gyrpue1 = "le84p1 ge92p1";
     global gyrpue1a = "le84p=le84p1 ge92p=ge92p1";
     global gyrpue2 = "le84p2 ge92p2";
     global yrpuea = "y80p y81p y82p y83p y84p y85p y86p y87p y88p";
     global yrpueb = "y89p y90p y91p y92p y93p y94p y95p y96p y97p";
     global yrpuea1 = "y80p1 y81p1 y82p1 y83p1 y84p1 y85p1 y86p1 y87p1 y88p1";
     global yrpueb1 = "y89p1 y90p1 y91p1 y92p1 y93p1 y94p1 y95p1 y96p1 y97p1";
     global yrpuea2 = "y80p2 y81p2 y82p2 y83p2 y84p2 y85p2 y86p2 y87p2 y88p2";
     global yrpueb2 = "y89p2 y90p2 y91p2 y92p2 y93p2 y94p2 y95p2 y96p2 y97p2";
    * interactions with m_ue;
     global regmue = "r1m r2m r4m";
     global regmue1 = "r1m1 r2m1 r4m1";
     global regmue1a = "r1m=r1m1 r2m=r2m1 r4m=r4m1";
     global regmue2 = "r1m2 r2m2 r4m2";
     global divmue = "dv1m dv2m dv3m dv4m dv6m dv7m dv8m dv9m";
     global divmue1 = "dv1m1 dv2m1 dv3m1 dv4m1 dv6m1 dv7m1 dv8m1 dv9m1";
     global divmue2 = "dv1m2 dv2m2 dv3m2 dv4m2 dv6m2 dv7m2 dv8m2 dv9m2";
     global gyrmue = "le84m ge92m";
     global gyrmue1 = "le84m1 ge92m1";
     global gyrmue1a = "le84m=le84m1 ge92m=ge92m1";
     global gyrmue2 = "le84m2 ge92m2";
     global yrmuea = "y80m y81m y82m y83m y84m y85m y86m y87m y88m";
     global yrmueb = "y89m y90m y91m y92m y93m y94m y95m y96m y97m";
     global yrmuea1 = "y80m1 y81m1 y82m1 y83m1 y84m1 y85m1 y86m1 y87m1 y88m1";
     global yrmueb1 = "y89m1 y90m1 y91m1 y92m1 y93m1 y94m1 y95m1 y96m1 y97m1";
     global yrmuea2 = "y80m2 y81m2 y82m2 y83m2 y84m2 y85m2 y86m2 y87m2 y88m2";
     global yrmueb2 = "y89m2 y90m2 y91m2 y92m2 y93m2 y94m2 y95m2 y96m2 y97m2";
                  

    * n1 row names;
     global d_name1 = "DELTA79 SE DELTA80 SE DELTA81 SE DELTA82 SE";
     global d_name1a = "DELTA80 SE DELTA81 SE DELTA82 SE";
     global d_name1b = "DELTA81 SE DELTA82 SE";
     global d_name2 = "DELTA83 SE DELTA84 SE DELTA85 SE DELTA86 SE";
     global d_name3 = "DELTA87 SE DELTA88 SE DELTA89 SE DELTA90 SE";
     global d_name4 = "DELTA91 SE DELTA92 SE DELTA93 SE DELTA94 SE";
     global d_name5 = "DELTA95 SE DELTA96 SE DELTA97 SE DELTA98 SE";
     global d_name5a = "DELTA95 SE DELTA96 SE DELTA97 SE";

     global n_name1 = "NAWRU79 SE NAWRU80 SE NAWRU81 SE NAWRU82 SE";
     global n_name1a = "NAWRU80 SE NAWRU81 SE NAWRU82 SE";
     global n_name1b = "NAWRU81 SE NAWRU82 SE";
     global n_name2 = "NAWRU83 SE NAWRU84 SE NAWRU85 SE NAWRU86 SE";
     global n_name3 = "NAWRU87 SE NAWRU88 SE NAWRU89 SE NAWRU90 SE";
     global n_name4 = "NAWRU91 SE NAWRU92 SE NAWRU93 SE NAWRU94 SE";
     global n_name5 = "NAWRU95 SE NAWRU96 SE NAWRU97 SE NAWRU98 SE";
     global n_name5a = "NAWRU95 SE NAWRU96 SE NAWRU97 SE";

end;

** This program sets up for tables when last year is 97;

capture program drop setup97;
program define setup97;
   * parameters: 1 - # specifications being tabled;
   mkglobal;
   if `1'==2 {;
    global specname = "A B";
   };
   if `1'==3 {;
    global specname = "A B C";
   };
   if `1'==4 {;
    global specname = "A B C D";
   };
   if `1'==5 {;
    global specname = "A B C D E";
   };
   if `1'==6 {;
    global specname = "A B C D E F";
   };
   
   ** set up for printing nawru's, #rows=2*#nawru's, #cols=#specs;
   matrix ntbl = J(38,`1',0);
   matrix rownames ntbl = $d_name1 $d_name2 $d_name3 $d_name4 $d_name5a;
   matrix colnames ntbl = $specname;
   matrix ntblf1 = J(38,`1',0);
   matrix rownames ntblf1 = $n_name1 $n_name2 $n_name3 $n_name4 $n_name5a;
   matrix colnames ntblf1 = $specname;
   matrix ntblf2 = J(38,`1',0);
   matrix rownames ntblf2 = $n_name1 $n_name2 $n_name3 $n_name4 $n_name5a;
   matrix colnames ntblf2 = $specname;
   matrix ntblf3 = J(38,`1',0);
   matrix rownames ntblf3 = $n_name1 $n_name2 $n_name3 $n_name4 $n_name5a;
   matrix colnames ntblf3 = $specname;
   matrix ntbld = J(6,`1',0);
   matrix ntbld = (chng1,ntbld);
   matrix rownames ntbld = dif9297 SE dif9297 SE dif9297 SE;
   matrix colnames ntbld = SD_dNWRU $specname;
end;

** This program sets up for tables when last year is 97, first year 81;

capture program drop setup97a;
program define setup97a;
   * parameters: 1 - # specifications being tabled;
   mkglobal;
   if `1' == 2 {;
    global specname = "A B";
   };
   if `1' == 3 {;
    global specname = "A B C";
   };
   if `1' == 4 {;
    global specname = "A B C D";
   };
   if `1' == 5 {;
    global specname = "A B C D E";
   };
   if `1' ==6 {;
    global specname = "A B C D E F";
   };
  
   ** set up for printing nawru's, #rows=2*#nawru's, #cols=#specs;
   matrix ntbl = J(34,`1',0);
   matrix rownames ntbl = $d_name1b $d_name2 $d_name3 $d_name4 $d_name5a;
   matrix colnames ntbl = $specname;
   matrix ntblf1 = J(34,`1',0);
   matrix rownames ntblf1 = $n_name1b $n_name2 $n_name3 $n_name4 $n_name5a;
   matrix colnames ntblf1 = $specname;
   matrix ntblf2 = J(34,`1',0);
   matrix rownames ntblf2 = $n_name1b $n_name2 $n_name3 $n_name4 $n_name5a;
   matrix colnames ntblf2 = $specname;
   matrix ntblf3 = J(34,`1',0);
   matrix rownames ntblf3 = $n_name1b $n_name2 $n_name3 $n_name4 $n_name5a;
   matrix colnames ntblf3 = $specname;
   matrix ntbld = J(6,`1',0);
   matrix ntbld = (chng1,ntbld);
   matrix rownames ntbld = dif9297 SE dif9297 SE dif9297 SE;
   matrix colnames ntbld = SD_dNWRU $specname;
end;


** This program sets up for tables when last year is 98;

capture program drop setup98;
program define setup98;
   * parameters: 1 - # specifications being tabled;
   mkglobal;
   if `1' == 2 {;
    global specname = "A B";
   };
   if `1' == 3 {;
    global specname = "A B C";
   };
   if `1' == 4 {;
    global specname = "A B C D";
   };
   if `1' == 5 {;
    global specname = "A B C D E";
   };
   if `1' == 6 {;
    global specname = "A B C D E F";
   };
   
   ** set up for printing nawru's, #rows=2*#nawru's, #cols=#specs;
   matrix ntbl = J(40,`1',0);
   matrix rownames ntbl = $d_name1 $d_name2 $d_name3 $d_name4 $d_name5;
   matrix colnames ntbl = $specname;
   matrix ntblf1 = J(40,`1',0);
   matrix rownames ntblf1 = $n_name1 $n_name2 $n_name3 $n_name4 $n_name5;
   matrix colnames ntblf1 = $specname;
   matrix ntblf2 = J(40,`1',0);
   matrix rownames ntblf2 = $n_name1 $n_name2 $n_name3 $n_name4 $n_name5;
   matrix colnames ntblf2 = $specname;
   matrix ntblf3 = J(40,`1',0);
   matrix rownames ntblf3 = $n_name1 $n_name2 $n_name3 $n_name4 $n_name5;
   matrix colnames ntblf3 = $specname;
   matrix ntbld = J(6,`1',0);
   matrix ntbld = (chng1,ntbld);
   matrix rownames ntbld = dif9298 SE dif9298 SE dif9298 SE;
   matrix colnames ntbld = SD_dNWRU $specname;
end;

** this program cleans up for tables when last year is 97;

capture program drop clnup97;
program define clnup97;
   * parameters: 1 - # specifications being tabled;

  nawrutbl `1' 19;
  nawruf 0.2 5;
  nawrutbf `1' 19 ntblf1;
  nawrutbd `1' 1;
  nawruf 0.4 5;
  nawrutbf `1' 19 ntblf2;
  nawrutbd `1' 2;
  nawruf 0.6 5;
  nawrutbf `1' 19 ntblf3;
  nawrutbd `1' 3;

end;

** this program cleans up for tables when last year is 97, first year is 81;

capture program drop clnup97a;
program define clnup97a;
   * parameters: 1 - # specifications being tabled;

  nawrutbl `1' 17;
  nawruf 0.2 5;
  nawrutbf `1' 17 ntblf1;
  nawrutbd `1' 1;
  nawruf 0.4 5;
  nawrutbf `1' 17 ntblf2;
  nawrutbd `1' 2;
  nawruf 0.6 5;
  nawrutbf `1' 17 ntblf3;
  nawrutbd `1' 3;

end;


** this program cleans up for tables when last year is 98;

capture program drop clnup98;
program define clnup98;
   * parameters: 1 - # specifications being tabled;

  nawrutbl `1' 20;
  nawruf 0.2 6;
  nawrutbf `1' 20 ntblf1;
  nawrutbd `1' 1;
  nawruf 0.4 6;
  nawrutbf `1' 20 ntblf2;
  nawrutbd `1' 2;
  nawruf 0.6 6;
  nawrutbf `1' 20 ntblf3;
  nawrutbd `1' 3;

end;

** this program prints the nawru stuff after the modltbl command;

capture program drop finup;
program define finup;
   * parameters: none;

   *** filtered estimates of change in NAWRU from 1992 to last year;
   display "Filtered estimates of change in NAWRU from 1992 to last year";
   matrix list ntbld, noheader format(%9.3f) ;
   *** unfiltered estimates of delta=year/B;
   display "Unfiltered estimates of delta=year/B";
   matrix list ntbl, noheader format(%9.3f) ;
/*
   ** filtered estimates of NAWRU, assume sd of d_nairu = .2;
   matrix list ntblf1, noheader format(%9.3f) ;
   ** filtered estimates of NAWRU, assume sd of d_nairu = .4;
   matrix list ntblf2, noheader format(%9.3f) ;
*/
   ** filtered estimates of NAWRU, assume sd of d_nairu = .6;
   display "Filtered estimates of NAWRU, assuming SD of d_nairu = .6";
   matrix list ntblf3, noheader format(%9.3f) ;

end;

** This program calculates NAWRU **;

capture program drop nawru;
program define nawru;
   * parameters: 1 - name of unemployment measure
                 2 - log or level (is UN logged?)
                 3 - FE or NOFE (FE if state effects)
                 4 - start year in regression (e.g. 79)
                 5 - start year for calculating NAWRU (e.g. 80)
                 6 - interval at which to calculate NAWRU (e.g. 2 years);

   * result holding matrix;
   matrix n1 = J(100-int(100+(`5'-99)/`6'),3,0);

   local i = `5';
   local j = 1;

   while `i'<=98 {;

     if `i'==`4' {;
      if "`2'"!="log" {;
       if "`3'"!="FE" {;
         testnl [-_b[_cons]/_b[`1']] = 0, r(a1);
        };
       else {;
         testnl [[$test1 + $test2 + $test3 + $test4 + $test5 + $test6]/48]*[-1/_b[`1']] = 0, r(a1);
        };
       };
      else {;
       if "`3'"!="FE" {;
         testnl exp([-_b[_cons]/_b[`1']]) = 0, r(a1);
        };
       else {;
         testnl exp([[$test1 + $test2 + $test3 + $test4 + $test5 + $test6]/48]*[-1/_b[`1']]) = 0, r(a1);
        };
       };
      };

     else {;
      if "`2'"!="log" {;
       if "`3'"!="FE" {;
         testnl [_b[_cons]+_b[d`i']]*[-1/_b[`1']] = 0, r(a1);
        };
       else {;
         testnl [[[$test1 + $test2 + $test3 + $test4 + $test5 + $test6]/48]+_b[d`i']]*[-1/_b[`1']] = 0, r(a1);
        };
       };
      else {;
       if "`3'"!="FE" {;
         testnl exp([_b[_cons]+_b[d`i']]*[-1/_b[`1']]) = 0, r(a1);
        };
       else {;
         testnl exp([[[$test1 + $test2 + $test3 + $test4 + $test5 + $test6]/48]+_b[d`i']]*[-1/_b[`1']]) = 0, r(a1);
        };
       };
      };
     

   matrix n1[`j',1] = `i';
   matrix n1[`j',2]=a1;
   matrix n1[`j',3]=a1/sqrt(r(F));
   local j = `j' + 1;
   local i = `i' + `6';
   };

   matrix rownames n1 = " ";
   matrix colnames n1 = Year NAWRU SE;

end;

** This program calculates NAWRU when last year is 97 **;

capture program drop nawru97;
program define nawru97;
   * parameters: 1 - name of unemployment measure
                 2 - log or level (is UN logged?)
                 3 - FE or NOFE (FE if state effects)
                 4 - start year in regression (e.g. 79)
                 5 - start year for calculating NAWRU (e.g. 80)
                 6 - interval at which to calculate NAWRU (e.g. 2 years);

   * result holding matrix;
   matrix n1 = J(100-int(100+(`5'-98)/`6'),3,0);

   local i = `5';
   local j = 1;

   while `i'<=97 {;

     if `i'==`4' {;
      if "`2'"!="log" {;
       if "`3'"!="FE" {;
         testnl [-_b[_cons]/_b[`1']] = 0, r(a1);
        };
       else {;
         testnl [[$test1 + $test2 + $test3 + $test4 + $test5 + $test6]/48]*[-1/_b[`1']] = 0, r(a1);
        };
       };
      else {;
       if "`3'"!="FE" {;
         testnl exp([-_b[_cons]/_b[`1']]) = 0, r(a1);
        };
       else {;
         testnl exp([[$test1 + $test2 + $test3 + $test4 + $test5 + $test6]/48]*[-1/_b[`1']]) = 0, r(a1);
        };
       };
      };

     else {;
      if "`2'"!="log" {;
       if "`3'"!="FE" {;
         testnl [_b[_cons]+_b[d`i']]*[-1/_b[`1']] = 0, r(a1);
        };
       else {;
         testnl [[[$test1 + $test2 + $test3 + $test4 + $test5 + $test6]/48]+_b[d`i']]*[-1/_b[`1']] = 0, r(a1);
        };
       };
      else {;
       if "`3'"!="FE" {;
         testnl exp([_b[_cons]+_b[d`i']]*[-1/_b[`1']]) = 0, r(a1);
        };
       else {;
         testnl exp([[[$test1 + $test2 + $test3 + $test4 + $test5 + $test6]/48]+_b[d`i']]*[-1/_b[`1']]) = 0, r(a1);
        };
       };
      };
     

   matrix n1[`j',1] = `i';
   matrix n1[`j',2]=a1;
   matrix n1[`j',3]=a1/sqrt(r(F));
   local j = `j' + 1;
   local i = `i' + `6';
   };

   matrix rownames n1 = " ";
   matrix colnames n1 = Year NAWRU SE;

end;


** This program puts NAWRU's into table for printing **;

capture program drop nawrutbl;
program define nawrutbl;
   * parameters: 1 - specification #, 2 - # NAWRUs being reported;
   local i = 1;
   while `i'<=`2' {;
     matrix ntbl[1+(`i'-1)*2,`1'] = n1[`i',2];
     matrix ntbl[2+(`i'-1)*2,`1'] = n1[`i',3];
    local i = `i' + 1;
   };
end;

** This program puts NAWRUF's into table for printing **;

capture program drop nawrutbf;
program define nawrutbf;
   * parameters: 1 - specification # 
                 2 - # NAWRUFs being reported
                 3 - matrix name holding output;
   local i = 1;
   while `i'<=`2' {;
     matrix `3'[1+(`i'-1)*2,`1'] = n1f[`i',4];
     matrix `3'[2+(`i'-1)*2,`1'] = n1f[`i',5];
    local i = `i' + 1;
   };
end;

** This program puts NAWRUD's into table for printing **;

capture program drop nawrutbd;
program define nawrutbd;
   * parameters: 1 - specification # 
                 2 - 0.2=1, 0.4=2, 0.6=3;
        matrix ntbld[1+(`2'-1)*2,1+`1'] = nawrud1[1,1];
        matrix ntbld[2+(`2'-1)*2,1+`1'] = nawrud1[1,2];
end;


** This program calculates NAWRUF (filtered NAWRU) **;

capture program drop nawruf;
program define nawruf;
   * parameters: 1 - assumed SD of change in NAWRU;
   *             2 - k, where we'll report change over last k years;
   
   * setup;
   matrix del = n1[1..rowsof(n1),2];
   scalar t0 = rowsof(del);
   matrix v_ubar = `1'*`1';
   matrix d0 = J(t0,t0,0);
   local i=1;
    while `i'<=t0 {;
       local j=1;
       while `j'<=t0 {;
         if `i'<=`j' {;
           matrix d0[`i',`j'] = `i';
         };
         else {;
           matrix d0[`i',`j'] = `j';
         };
         local j = `j' + 1;
       };
       local i = `i' + 1;       
    };

   * demean del, add mean back later;
   matrix mdel = trace(diag(del))/rowsof(del);
   matrix mdel = mdel*J(t0,1,1);
   matrix del = del-mdel;

   * calculate var of change in unfiltered nawru (del);
   matrix d_del = del[2..t0,1]-del[1..(t0-1),1];
   matrix m_del = trace(diag(d_del))/rowsof(d_del);
   matrix m_del = m_del*J(t0-1,1,1);
   matrix v_del = ((d_del'-m_del')*(d_del-m_del))/(rowsof(d_del)-1);

   * calculate lambda;
   matrix lambda = (2*v_ubar)*inv(v_del-v_ubar);

   * calculate nawruf and add back the mean;
   matrix nawruf = del'*syminv(lambda*d0+I(t0))*(lambda*d0);
   matrix nawruf = mdel + nawruf';
   
   * calculate SE's conditional on del;
   matrix nawrufv = (lambda*d0) - ( (lambda*d0)*syminv(lambda*d0+I(t0))*(lambda*d0) );
   matrix nawrufse = vecdiag(cholesky(diag(vecdiag(nawrufv))));
   matrix nawrufse = nawrufse';
   matrix nawruf1 = (nawruf,nawrufse);
   matrix colnames nawruf1 = NAWRUF NAWRUFSE;
   matrix n1f = (n1,nawruf1);

   * now calculate the dif/SE between last year and k years before;
   matrix d1 = J(t0,1,0);
   matrix d1[t0,1] = 1;
   matrix d1[t0-`2',1] = -1;
   matrix nawrud = d1'*nawruf;
   matrix nawrudv = d1'*nawrufv*d1;
   matrix nawrudse = cholesky(nawrudv);
   matrix nawrud1 = (nawrud,nawrudse);

end;

* set up first column for change in nairu results;
   matrix chng1 = 0.2 \ 0.2 \ 0.4 \ 0.4 \ 0.6 \ 0.6 ;


**** end of variable creation ***;



log on;
***** RESULTS FROM UNWEIGHTED REGRESSIONS, EXCEPT AS NOTED *****;

*** TABLE 6: USING DWAGE(T+1)-INF(T+1)-PROD(T+1), UNADJUSTED WAGE/UNEM ***;
log off;

macro drop _all;

quietly reg d_mhr m_ue d80-d97;
modl A nocon m_ue Year, Without state FEs [OLS];
quietly testparm d80-d97;
testres A 1 ,dyear=0;

quietly reg d_mhr m_ue d80-d97 ds1-ds47;
modl B nocon m_ue Year State, With state FEs [OLS];
quietly testparm d80-d97;
testres B 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres B 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 d80-d97 (m_ue2 d80-d97);
modl C nocon m_ue=m_ue1 Year IV, Without state FEs [IV] (instr w/even);
quietly testparm d80-d97;
testres C 1 ,dyear=0;

quietly reg d_mhr1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47);
modl D nocon m_ue=m_ue1 Year State IV, With state FEs [IV] (instr w/even);
quietly testparm d80-d97;
testres D 1 ,dyear=0;
quietly testparm ds1-ds47;
testres D 2,state dummies = 0;


log on;

modltbl se A B C D, Table 6 -- Using dwage(t+1)-inf(t+1)-prod(t+1) and unadjusted wage/unem ;

log off;


log on;
*** TABLE 7: ALTERNATIVE PHILLIPS CURVE ESTIMATES ***;
log off;

macro drop _all;

quietly reg d_mhr1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47);
modl A nocon m_ue=m_ue1, base case (instr w/even);

quietly reg d_mhr2 m_ue2 d80-d97 ds1-ds47 (m_ue1 d80-d97 ds1-ds47);
modl B nocon m_ue=m_ue2, instr w/odd;

quietly reg d_mhr1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47) [aw=hrwt];
modl C nocon m_ue=m_ue1, Weighted IV;

quietly reg d_phr1 pue1 d80-d97 ds1-ds47 (pue2 d80-d97 ds1-ds47);
modl D nocon m_ue=pue1, adjusted wages & unemployment;

quietly reg d_mhr1 pue1 d80-d97 ds1-ds47 (pue2 d80-d97 ds1-ds47);
modl E nocon m_ue=pue1, adjusted unemployment;

quietly reg d_mhr1 puei1 d80-d97 ds1-ds47 (puei2 d80-d97 ds1-ds47);
modl F nocon m_ue=puei1, adjusted unemployment adding industry effects;

quietly reg d_phr1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47);
modl G nocon m_ue=m_ue1, adjusted wages;

quietly reg d_mdhw1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47);
modl H nocon m_ue=m_ue1, median wages;

quietly reg d_mft1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47);
modl I nocon m_ue=m_ue1, mean wages full-time workers;

quietly reg d_mhy1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47);
modl J nocon m_ue=m_ue1, mean wages hourly workers;

quietly reg d_0mhr1 m_ue1 d80-d98 ds1-ds47 (m_ue2 d80-d98 ds1-ds47);
modl K nocon m_ue=m_ue1, no productivity growth adjustment;

quietly reg d_0mhr1 m_ue1 c_prodgr d80-d97 ds1-ds47 (m_ue2 c_prdgx2 d80-d97 ds1-ds47);
modl L nocon m_ue=m_ue1, estimating coef on prod growth;

quietly reg d_xmhr1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47);
modl M nocon m_ue=m_ue1, weighted industry productivity growth adjustment;

quietly reg e_mhr1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47) if year<98;
modl N nocon m_ue=m_ue1, productivity gowth dated "t";

quietly reg d_mhr1 c_m_ue1 d80-d97 ds1-ds47 (c_m_ue2 d80-d97 ds1-ds47);
modl O nocon m_ue=c_m_ue1, unemployment data "t+1";

log on;

modltbl se A B C D E F, Table 7 -- alternative phillips curve estimates ;
modltbl se G H I J K L, Table 7 (continued);
modltbl se M N O, Table 7 (continued) ;

log off;


log on;
*** TABLE 8: Alternative Specification of Phillips Curve Dynamics  ***;
log off;

macro drop _all;


gen lnprod=ln(gsp/emp);
gen mhrlp=mhr-lnprod;
gen mhrlp1 = mhr1-lnprod;
gen mhrlp2 = mhr2-lnprod;
gen phrlp=phr-lnprod;
gen phrlp1 = phr1-lnprod;
gen phrlp2 = phr2-lnprod;

quietly reg d_mhr mhrlp m_ue d80-d97 ds1-ds47;
modl A nocon m_ue mhrlp Year State, prod adjustment [OLS];
quietly reg d_0mhr mhr m_ue d80-d98 ds1-ds47;
modl C nocon m_ue mhr Year State, no prod adjustment [OLS];
quietly reg d_phr phrlp m_ue d80-d97 ds1-ds47;
modl B nocon m_ue phrlp Year State, prod adjustment & wage adjust [OLS];
quietly reg d_mhr1 mhrlp1 m_ue1 d80-d97 ds1-ds47 (mhrlp2 m_ue2 d80-d97 ds1-ds47);
modl D nocon m_ue=m_ue1 mhrlp=mhrlp1 Year State, prod adjustment [IV];
quietly reg d_0mhr1 mhr1 m_ue1 d80-d98 ds1-ds47 (mhr2 m_ue2 d80-d98 ds1-ds47);
modl F nocon m_ue=m_ue1 mhr=mhr1 Year State, no prod adjustment [IV];
quietly reg d_phr1 phrlp1 m_ue1 d80-d97 ds1-ds47 (phrlp2 m_ue2 d80-d97 ds1-ds47);
modl E nocon m_ue=m_ue1 phrlp=phrlp1 Year State, prod adjustment [IV];

log on;

modltbl se A B C D E F, Table 8 Panel A -- Relaxing Unit Root Constraint on Real Wages;

log off;


macro drop _all;

quietly reg d_mhr1 m_ue1 d1mhr1 d_m_ue1 d82-d97 ds1-ds47 (m_ue2 d1mhr2 d_m_ue2 d82-d97 ds1-ds47) if year>80;
modl E nocon m_ue=m_ue1 d1mhr=d1mhr1 d_m_ue=d_m_ue1 Year State IV, Base with one lag dwage & dunem (81-97) [IV];
quietly testparm d82-d97;
testres E 1 ,dyear=0;
quietly testparm ds1-ds47;
testres E 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 d1mhr1 d2mhr1 d_m_ue1 d1m_ue1 d82-d97 ds1-ds47 (m_ue2 d1mhr2 d2mhr2 d_m_ue2 d1m_ue2 d82-d97 ds1-ds47) if year>80;
modl F nocon m_ue=m_ue1 d1mhr=d1mhr1 d2mhr=d2mhr1 d_m_ue=d_m_ue1 d1m_ue=d1m_ue1 Year State IV, Base with two lags dwage & dunem (81-97) [IV];
quietly testparm d82-d97;
testres F 1 ,dyear=0;
quietly testparm ds1-ds47;
testres F 2,state dummies = 0;
quietly testparm d1mhr1 d2mhr1;
testres F 3, both dwage lags = 0;
quietly testparm d_m_ue1 d1m_ue1;
testres F 4, both dunem lags = 0;

log on;

modltbl se E F, Table 8 Panel B -- allowing distributed lags;

log off;


log on;

*** TABLE 9: Stability of Phillips Curve through Time and Space ***;
log off;
macro drop _all;
mkglobal;


quietly reg d_mhr1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47);
modl D nocon m_ue=m_ue1 Year State, no interactions [IV];
quietly testparm d80-d97;
testres D 1 ,year dummies=0;
quietly testparm ds1-ds47;
testres D 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 $gyrmue1 d80-d97 ds1-ds47 (m_ue2 $gyrmue2 d80-d97 ds1-ds47);
modl E nocon m_ue=m_ue1 $gyrmue1a Year State, grouped year interacted with unem [IV];
quietly testparm d80-d97;
testres E 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres E 2,state dummies = 0;
quietly testparm $gyrmue1;
testres E 3,grouped year x unem interactions = 0;

quietly reg d_mhr1 m_ue1 $regmue1 d80-d97 ds1-ds47 (m_ue2 $regmue2 d80-d97 ds1-ds47);
modl F nocon m_ue=m_ue1 $regmue1a Year State, Census region interacted with unem [IV];
quietly testparm d80-d97;
testres F 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres F 2,state dummies = 0;
quietly testparm $regmue1;
testres F 4,Census region x unem interactions = 0;


log on;

modltbl se D E F, Table 9 -- stability of phillips curve through time and space;

log off;


log on;
*** TABLE 10: DEMOGRAPHIC VARIABLES AND THE PHILLIPS CURVE ***;
log off;

macro drop _all;
mkglobal;


quietly reg d_mhr1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47);
modl A nocon m_ue=m_ue1 Year State, Base with no controls [IV];
quietly testparm d80-d97;
testres A 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres A 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 $educ1 d80-d97 ds1-ds47 (m_ue2 $educ2 d80-d97 ds1-ds47);
modl B nocon m_ue=m_ue1 $educ1a Year State, Base with educ controls [IV];
quietly testparm d80-d97;
testres B 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres B 2,state dummies = 0;
quietly testparm $educ1;
testres B 3,education vars = 0;

quietly reg d_mhr1 m_ue1 white1 d80-d97 ds1-ds47 (m_ue2 white2 d80-d97 ds1-ds47);
modl C nocon m_ue=m_ue1 white=white1 Year State, Base with race controls [IV];
quietly testparm d80-d97;
testres C 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres C 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 female1 d80-d97 ds1-ds47 (m_ue2 female2 d80-d97 ds1-ds47);
modl D nocon m_ue=m_ue1 female=female1 Year State, Base with gender controls [IV];
quietly testparm d80-d97;
testres D 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres D 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 a25541 d80-d97 ds1-ds47 (m_ue2 a25542 d80-d97 ds1-ds47);
modl E nocon m_ue=m_ue1 a2554=a25541 Year State, Base with age controls [IV];
quietly testparm d80-d97;
testres E 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres E 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 $educ1 white1 female1 a25541 d80-d97 ds1-ds47 (m_ue2 $educ2 white2 female2 a25542 d80-d97 ds1-ds47);
modl F nocon m_ue=m_ue1 $educ1a white=white1 female=female1 a2554=a25541 Year State, Base with all demographic controls [IV];
quietly testparm d80-d97;
testres F 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres F 2,state dummies = 0;
quietly testparm $educ1;
testres F 3,education vars = 0;
quietly testparm $educ1 white1 female1 a25541;
testres F 4,all vars = 0;

log on;

modltbl se A B C D E F, Table 10 -- Demographic variables and the phillips curve;

log off;


log on;
*** TABLE 11: INDUSTRY CHARACTERISTICS AND THE PHILLIPS CURVE ***;
log off;

macro drop _all;
mkglobal;


quietly reg d_mhr1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47);
modl A nocon m_ue=m_ue1 Year State, Base with no controls [IV];
quietly testparm d80-d97;
testres A 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres A 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 $indust1 d80-d97 ds1-ds47 (m_ue2 $indust2 d80-d97 ds1-ds47);
modl B nocon m_ue=m_ue1 $indust1a Year State, Base with major industry controls [IV];
quietly testparm d80-d97;
testres B 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres B 2,state dummies = 0;
quietly testparm $indust1;
testres B 3,industry vars = 0;

quietly reg d_mhr1 m_ue1 ths1 d80-d97 ds1-ds47 (m_ue2 ths2 d80-d97 ds1-ds47);
modl C nocon m_ue=m_ue1 ths=ths1 Year State, Base with temp industry (CPS) controls [IV];
quietly testparm d80-d97;
testres C 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres C 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 cbths1 d80-d97 ds1-ds47 (m_ue2 cbths1 d80-d97 ds1-ds47);
modl D nocon m_ue=m_ue1 cbths1 Year State, Base with temp industry (CBP, 1yr lag) controls [IV];
quietly testparm d80-d97;
testres D 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres D 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 se1 d80-d97 ds1-ds47 (m_ue2 se2 d80-d97 ds1-ds47);
modl E nocon m_ue=m_ue1 se=se1 Year State, Base with self-employment controls [IV];
quietly testparm d80-d97;
testres E 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres E 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 $indust1 cbths1 se1 d80-d97 ds1-ds47 (m_ue2 $indust2 cbths1 se2 d80-d97 ds1-ds47);
modl F nocon m_ue=m_ue1 $indust1a cbths1 se=se1 Year State, Base with all industry (using CBP for temp) controls [IV];
quietly testparm d80-d97;
testres F 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres F 2,state dummies = 0;
quietly testparm $indust1;
testres F 3,major industry vars = 0;
quietly testparm $indust1 cbths1 se1;
testres F 4,all vars = 0;

log on;

modltbl se A B C D E F, Table 11 -- Industry characteristics and the phillips curve;

log off;



log on;
*** TABLE 12: GOVERNMENT POLICY VARIABLES AND THE PHILLIPS CURVE ***;
log off;

macro drop _all;
mkglobal;


quietly reg d_mhr1 m_ue1 d80-d97 ds1-ds47 (m_ue2 d80-d97 ds1-ds47);
modl A nocon m_ue=m_ue1 Year State, Base with no controls [IV];
quietly testparm d80-d97;
testres A 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres A 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 difrc ssfrc d80-d97 ds1-ds47 (m_ue2 difrc ssfrc d80-d97 ds1-ds47);
modl B nocon m_ue=m_ue1 difrc ssfrc Year State, Base with DI/SSI controls [IV];
quietly testparm d80-d97;
testres B 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres B 2,state dummies = 0;
quietly testparm difrc ssfrc;
testres B 3,DI/SSI = 0;

quietly reg d_mhr1 m_ue1 minwg dminwg d80-d97 ds1-ds47 (m_ue2 minwg dminwg d80-d97 ds1-ds47);
modl C nocon m_ue=m_ue1 minwg dminwg Year State, Base with min wage (99$ level and growth) controls [IV];
quietly testparm d80-d97;
testres C 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres C 2,state dummies = 0;
quietly testparm minwg dminwg;
testres C 4, minwg=0 and dminwg=0;

quietly reg d_mhr1 m_ue1 rrate d80-d97 ds1-ds47 (m_ue2 rrate d80-d97 ds1-ds47);
modl D nocon m_ue=m_ue1 rrate Year State, Base with UI replacement rate controls [IV];
quietly testparm d80-d97;
testres D 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres D 2,state dummies = 0;

quietly reg d_mhr1 m_ue1 difrc ssfrc minwg dminwg rrate d80-d97 ds1-ds47 (m_ue2 difrc ssfrc minwg dminwg rrate d80-d97 ds1-ds47);
modl E nocon m_ue=m_ue1 difrc ssfrc minwg dminwg rrate Year State, Base with all institutional variables [IV];
quietly testparm d80-d97;
testres E 1 ,year dummies = 0;
quietly testparm ds1-ds47;
testres E 2,state dummies = 0;
quietly testparm difrc ssfrc;
testres E 3,DI/SSI = 0;
quietly testparm minwg dminwg;
testres E 4, minwg=0 and dminwg=0;
quietly testparm difrc ssfrc minwg dminwg rrate;
testres E 5,all vars = 0;

log on;

modltbl se A B C D E, Table 12 -- Government policy variables and the phillips curve;

log off;

log close;


