/* cci.prc */
/* procedure to calculate the cutoff points of confidence intervals
   and the median unbiased estimator based on k=0 */

/* usage:
   chat=cci(alfa,tau)  where
      chat is the cutoff point
      alfa is the significance level e.g. 0.05
      tau is the input value of dickey fuller tau statistic */

/* load cutoff-points matrix */
loadm pc=upcs0.fmt;
cnr=(cols(pc)-1)/2;
vc=pc[1,2:cnr+1];
vl=pc[.,1];
mcbar=pc[.,cnr+2:2*cnr+1];

proc(1) = cci(alfa,tau);
  local rw,cbar,ci;
  rw=indnv(alfa,vl);
  cbar=1;
  ci=1;
  do while ci <= cnr;
    if tau > mcbar[rw,ci];
      if ci==1;
        cbar=0;
      else;
        cbar=vc[ci]+(tau-mcbar[rw,ci])*(vc[ci]-vc[ci-1])/
          (mcbar[rw,ci]-mcbar[rw,ci-1]);
      endif;
    break;
    endif;
    ci=ci+1;
  endo;
  retp(cbar);
endp;
