/* dftau.prc */
/* procedure calculating the dickey-fuller tau statistic */

/* usage:
   tau=dftau(y,nar);
     y is the series your considering
     nar is the number of lagged FD's in the ADF Regression
     tau is the df-tau statistic */


proc(1) = dftau(y,nar);
  local t,dy,y1,x,i,xxi,coef,e,sig2,vcoef,dftau;
  t=rows(y);
  dy=0|y[2:t]-y[1:t-1];
  y1=dy[2+nar:t];
  x=y[2+nar-1:t-1];
  if nar >= 1;
    i=1;
    do while i <= nar;
      x=x~dy[2+nar-i:t-i];
      i=i+1;
    endo;
  endif;
  x=x~ones(rows(y1),1)~seqa(1,1,rows(y1));
  xxi=invpd(x'x);
  coef=xxi*x'y1;
  e=y1-x*coef;
  sig2=e'e/(rows(e)-cols(x));
  vcoef=sig2*xxi;
  dftau=coef[1]/sqrt(vcoef[1,1]);
  retp(dftau);
endp;
