proc(1) = cspline(q,nk);
/* Compute Fitted Values from Cubic Spline 
   
   Q = series
   nk = number of knots 
   
   ct = spline fit 
*/
local tmp, trnd, tr, isel, qp, n, nks, i, spreg, t0, t1, t2, b, ct;
 
 tmp = missrv(q,1e+32);
 isel = tmp ./= 1e+32;
 trnd = seqa(1,1,rows(q));
 trnd = selif(trnd,isel);
 qp = q[trnd];
 n = rows(qp);
 tr = seqa(1,1,n);
 nks = zeros(nk+1,1);
 i=1; do while i <= nk;
 	nks[i+1]=floor((i/(nk+1))*n);
 i=i+1; endo;
 spreg = zeros(n,nk+4);
 t0 = ones(n,1);
 t1 = tr;
 t2 = tr.^2;
 spreg[.,1] = t0;
 spreg[.,2] = t1;
 spreg[.,3] = t2;
 i = 1; do while i <= nk+1;
	tmp = t1-nks[i];
	spreg[.,3+i] = (0.5*(tmp.^3)).*(t1 .> nks[i]);
 i=i+1; endo;
 b = qp/spreg;
 ct = spreg*b;
 tmp = miss(zeros(rows(q),1),0);
 tmp[trnd] = ct;
 retp(tmp);
endp;