
#delimit;
clear;
capture log close;
set memory 400m;
set matsize 6000;
set more off;
version 10.0;

log using logs\counterfactual.log,replace;

******************************************************************************************;
**** Counterfactual to examine the heterogeneous effects of delicensing across states ****;
**** depending on their labor regulation stance                                       ****;
******************************************************************************************;

****************;
**** Output ****;
****************;

clear;
u data\ABRZ3dAER.dta;

gen outvar=Rirout;
gen loutvar=lRirout;
drop Rirout lRirout;

xi: areg loutvar nstrictdelic i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
predict f_loutvar , xbd;

gen c_loutvar=f_loutvar-(_b[nstrictdelic]*nstrictdelic);

gen f_outvar=exp(f_loutvar);
gen c_outvar=exp(c_loutvar);

collapse (sum) outvar f_outvar c_outvar , by(state year);
so state year;

gen percent=(f_outvar/c_outvar)*100;

format outvar f_outvar percent %12.2f;

list state year outvar f_outvar percent;

format percent %12.0f;

so state year;

replace year=year-1900;

lab var percent " ";

set scheme s1mono;
graph set print logo off;

lab drop state;
lab def state 1 "Andra Pradesh" 2 "Assam" 3 "Bihar" 4 "Gujarat" 5 "Haryana" 
7 "Jammu & Kashmir" 8 "Karnataka" 9 "Kerala" 10 "Madhya Pradesh" 11 "Maharashtra" 
14 "Orissa" 15 "Punjab" 16 "Rajasthan" 18 "Tamil Nadu" 20 "Uttar Pradesh" 
21 "West Bengal";
lab val state state;

scatter percent year , msymbol(Oh) subtitle(, bcolor(white)) 
by(state, noyrescale title("Figure A3: The Unequal Effects of Delicensing in India 1980-97", size(medium))
note("Notes: For each Indian state we display the ratio of fitted state output (from column (1) of Table 3) to counterfactual state output obtained by setting"
"the delicense-labor regulation interaction to zero in this specification. The fitted-counterfactual ratio has been multiplied by one hundred to be"
"expressed as a percentage.  Deviations from a value of one hundred are attributable to the heterogeneous effects of delicensing across states"
"due to their different labor market regulations. Since industry-year and state-year effects absorb, respectively, the level effects of delicensing"
"and labor regulation, the difference between the fitted and counterfactual series can only identify the heterogeneous effects of delicensing."
"Vertical lines denote the two waves of delicensing in 1985 and 1991."
, size(vsmall)))
xlabel(80 85 90 95, nogrid) ylabel(80 90 100 110 120, angle(horizontal) nogrid) xline(85 91) yline(100);

so state year;
sa data\counterfactual_output.dta,replace;

********************;
**** Employment ****;
********************;

clear;
u data\ABRZ3dAER.dta;

gen outvar=employees;
gen loutvar=lirte;

xi: areg loutvar nstrictdelic i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
predict f_loutvar , xbd;

gen c_loutvar=f_loutvar-(_b[nstrictdelic]*nstrictdelic);

gen f_outvar=exp(f_loutvar);
gen c_outvar=exp(c_loutvar);

collapse (sum) outvar f_outvar c_outvar , by(state year);
so state year;

gen percent=(f_outvar/c_outvar)*100;

format outvar f_outvar percent %12.2f;

list state year outvar f_outvar percent;

format percent %12.0f;

so state year;

replace year=year-1900;

lab var percent " ";

set scheme s1mono;
graph set print logo off;

lab drop state;
lab def state 1 "Andra Pradesh" 2 "Assam" 3 "Bihar" 4 "Gujarat" 5 "Haryana" 
7 "Jammu & Kashmir" 8 "Karnataka" 9 "Kerala" 10 "Madhya Pradesh" 11 "Maharashtra" 
14 "Orissa" 15 "Punjab" 16 "Rajasthan" 18 "Tamil Nadu" 20 "Uttar Pradesh" 
21 "West Bengal";
lab val state state;

scatter percent year , msymbol(Oh) subtitle(, bcolor(white)) 
by(state, noyrescale title("Figure A3: The Unequal Effects of Delicensing in India 1980-97", size(medium))
note("Notes: For each Indian state we display the ratio of fitted state output (from column (1) of Table 3) to counterfactual state output obtained by setting"
"the delicense-labor regulation interaction to zero in this specification. The fitted-counterfactual ratio has been multiplied by one hundred to be"
"expressed as a percentage.  Deviations from a value of one hundred are attributable to the heterogeneous effects of delicensing across states"
"due to their different labor market regulations. Since industry-year and state-year effects absorb, respectively, the level effects of delicensing"
"and labor regulation, the difference between the fitted and counterfactual series can only identify the heterogeneous effects of delicensing."
"Vertical lines denote the two waves of delicensing in 1985 and 1991."
, size(vsmall)))
xlabel(80 85 90 95, nogrid) ylabel(80 90 100 110 120, angle(horizontal) nogrid) xline(85 91) yline(100);

so state year;
sa data\counterfactual_employ.dta,replace;

***********************;
**** Fixed Capital ****;
***********************;

clear;
u data\ABRZ3dAER.dta;

gen outvar=Rircap;
gen loutvar=lRircap;
drop Rirout lRircap;

xi: areg loutvar nstrictdelic i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
predict f_loutvar , xbd;

gen c_loutvar=f_loutvar-(_b[nstrictdelic]*nstrictdelic);

gen f_outvar=exp(f_loutvar);
gen c_outvar=exp(c_loutvar);

collapse (sum) outvar f_outvar c_outvar , by(state year);
so state year;

gen percent=(f_outvar/c_outvar)*100;

format outvar f_outvar percent %12.2f;

list state year outvar f_outvar percent;

format percent %12.0f;

so state year;

replace year=year-1900;

lab var percent " ";

set scheme s1mono;
graph set print logo off;

lab drop state;
lab def state 1 "Andra Pradesh" 2 "Assam" 3 "Bihar" 4 "Gujarat" 5 "Haryana" 
7 "Jammu & Kashmir" 8 "Karnataka" 9 "Kerala" 10 "Madhya Pradesh" 11 "Maharashtra" 
14 "Orissa" 15 "Punjab" 16 "Rajasthan" 18 "Tamil Nadu" 20 "Uttar Pradesh" 
21 "West Bengal";
lab val state state;

scatter percent year , msymbol(Oh) subtitle(, bcolor(white)) 
by(state, noyrescale title("Figure A3: The Unequal Effects of Delicensing in India 1980-97", size(medium))
note("Notes: For each Indian state we display the ratio of fitted state output (from column (1) of Table 3) to counterfactual state output obtained by setting"
"the delicense-labor regulation interaction to zero in this specification. The fitted-counterfactual ratio has been multiplied by one hundred to be"
"expressed as a percentage.  Deviations from a value of one hundred are attributable to the heterogeneous effects of delicensing across states"
"due to their different labor market regulations. Since industry-year and state-year effects absorb, respectively, the level effects of delicensing"
"and labor regulation, the difference between the fitted and counterfactual series can only identify the heterogeneous effects of delicensing."
"Vertical lines denote the two waves of delicensing in 1985 and 1991."
, size(vsmall)))
xlabel(80 85 90 95, nogrid) ylabel(80 90 100 110 120, angle(horizontal) nogrid) xline(85 91) yline(100);

so state year;
sa data\counterfactual_capital.dta,replace;

log close;


