
#delimit;
clear;
capture log close;
set mem 400m;
set matsize 800;
set more off;
set scheme s1mono;
version 10.0;
log using logs\Labor_Regulation_Graph.log,replace;

******************;
**** Use data ****;
******************;

u data\ABRZ3dAER.dta;
so state year nic3;

quietly by state year: keep if _n==1;

replace year=year-1900;
lab var nstrict "Labor Regulation";

set scheme s1mono;
graph set print logo off;

lab drop state;
lab def state 1 "Andra Pradesh" 2 "Assam" 3 "Bihar" 4 "Gujarat" 5 "Haryana" 
7 "Jammu & Kashmir" 8 "Karnataka" 9 "Kerala" 10 "Madhya Pradesh" 11 "Maharashtra" 
14 "Orissa" 15 "Punjab" 16 "Rajasthan" 18 "Tamil Nadu" 20 "Uttar Pradesh" 
21 "West Bengal";
lab val state state;

lab var nstrict "Labor Regulation";
scatter nstrict year , msymbol(Oh) subtitle(, bcolor(white)) 
by(state, noyrescale title("Figure A2: Labor Regulation in India 1980-97", size(medium)) 
note("Notes: State amendments to the Industrial Disputes Act are coded: 1=pro-worker, 0=neutral, -1=pro-employer and cumulated from 1947-97."
"Vertical lines denote the two waves of delicensing in 1985 and 1991. See the data appendix for further details on the variables and data sources.", size(vsmall)))
xlabel(80 85 90 95, nogrid) ylabel(-4 -2 0 2 4, nogrid) yline(0) xline(85 91);

log close;
