
#delimit ;
clear;
capture log close;
set memory 400m;
set matsize 1200;
set more off;
version 10.0;

log using logs\prereformgrowth.log,replace;

***************************************************************************************;
**** This File Examines The Relationship Between Pre-reform Growth and Delicensing ****;
***************************************************************************************;

u data\ABRZ3dAER.dta;
so state nic3 year;

*********************************************;
**** Aggregate to industry-level dataset ****;
*********************************************;

egen iemployees=sum(employees),by(nic3 year);
egen iworkers=sum(workers),by(nic3 year);
egen ioutput=sum(Rirout),by(nic3 year);
egen icapital=sum(Rircap),by(nic3 year);
egen inofactories=sum(nofactories),by(nic3 year);

so nic3 year state;
quietly by nic3 year: keep if _n==1;
drop state;

gen iyl=ioutput/iemployees;

gen liemployees=ln(iemployees);
gen lioutput=ln(ioutput);
gen linofactories=ln(inofactories);
gen liyl=ln(iyl);

*******************************;
**** Generate Growth Rates ****;
*******************************;

so nic3 year;
quietly by nic3: gen g_liemployees=liemployees[_n]-liemployees[_n-4];
quietly by nic3: gen g_lioutput=lioutput[_n]-lioutput[_n-4];
quietly by nic3: gen g_linofactories=linofactories[_n]-linofactories[_n-4];
quietly by nic3: gen g_liyl=liyl[_n]-liyl[_n-4];

***********************************************;
**** Run regressions for the 1980-4 period ****;
***********************************************;

keep if year==1984;

* First year delicensed==2000 corresponds to never delicensed;
* So drop these observations;
drop if firstyrdelic>1997;

reg firstyrdelic g_liemployees , robust;
reg firstyrdelic g_lioutput , robust;
reg firstyrdelic g_liyl , robust;

log close;


