
#delimit ;
clear;
capture log close;
set memory 500m;
set matsize 4000;
set more off;
version 10.0;

****************************************************************************;
**** Main estimation results for Aghion, Burgess, Redding and Zilibotti ****;
****************************************************************************;

u data\ABRZ3dAER.dta;
so state nic3 year;

log using tables\table1.log,replace;

******************************************;
**** Table 1 : Descriptive Statistics ****;
******************************************;

gen steve=1;

**** NOTE : keep command here;

keep if noj_yr==18;

so nic3 year state;
quietly by nic3 year: gen fob_state=1 if _n==1;

egen ct_delic=count(nic3) if delicense==1&fob_state==1,by(year);
egen ct_ind=count(nic3) if fob_state==1,by(year);

egen tot_emp=sum(employees),by(year);
egen tot_out=sum(Rirout),by(year);

egen temp=sum(employees) if delicense==1,by(year);
egen del_emp=max(temp),by(year);
drop temp;
egen temp=sum(Rirout) if delicense==1,by(year);
egen del_out=max(temp),by(year);
so state nic3 year;
drop temp;

replace del_emp=(del_emp/tot_emp)*100;
replace del_out=(del_out/tot_out)*100;
gen del_num=(ct_delic/ct_ind)*100;

gen noj=1;

* Delicensing;

table steve year if noj_yr==18&(year==1980|year==1985|year==1990|year==1997), c(mean del_num) format(%12.2f);
table steve year if noj_yr==18&(year==1980|year==1985|year==1990|year==1997), c(mean del_out) format(%12.2f);
table steve year if noj_yr==18&(year==1980|year==1985|year==1990|year==1997), c(mean del_emp) format(%12.2f);

table steve if noj_yr==18, c(mean del_num) format(%12.2f);
table steve if noj_yr==18, c(mean del_out) format(%12.2f);
table steve if noj_yr==18, c(mean del_emp) format(%12.2f);

* Labor regulation;

table steve year if noj_yr==18&(year==1980|year==1985|year==1990|year==1997), c(mean nstrict sd nstrict) format(%12.2f);
table steve if noj_yr==18, c(mean nstrict sd nstrict) format(%12.2f);

* Tariffs;

table steve year if noj_yr==18&(year==1980|year==1985|year==1990|year==1997), c(mean etariff sd etariff) format(%12.2f);
table steve if noj_yr==18, c(mean etariff sd etariff) format(%12.2f);

* FDI reform;

table steve year if noj_yr==18&(year==1980|year==1985|year==1990|year==1997), c(mean FDIreform sd FDIreform) format(%12.2f);

table steve if noj_yr==18, c(mean FDIreform sd FDIreform) format(%12.2f);

* Output;

table steve year if noj_yr==18&(year==1980|year==1985|year==1990|year==1997), c(mean lRirout sd lRirout) format(%12.2f);
table steve if noj_yr==18, c(mean lRirout sd lRirout) format(%12.2f);

* Factories;

table steve year if noj_yr==18&(year==1980|year==1985|year==1990|year==1997), c(mean lirnfac sd lirnfac) format(%12.2f);
table steve if noj_yr==18, c(mean lirnfac sd lirnfac) format(%12.2f);

* Employment;

table steve year if noj_yr==18&(year==1980|year==1985|year==1990|year==1997), c(mean lirte sd lirte) format(%12.2f);
table steve if noj_yr==18, c(mean lirte sd lirte) format(%12.2f);

* Real Capital;

table steve year if noj_yr==18&(year==1980|year==1985|year==1990|year==1997), c(mean lRircap sd lRircap) format(%12.2f);
table steve if noj_yr==18, c(mean lRircap sd lRircap) format(%12.2f);

* Observations;

table steve year if noj_yr==18&(year==1980|year==1985|year==1990|year==1997), c(sum noj) format(%12.2f);
table steve if noj_yr==18, c(sum noj) format(%12.2f);

log close;

log using tables\table2.log,replace;

**************************************************************;
**** Table 2 -- delicensing and entry in india: 1980-1997 ****;
**************************************************************;

clear;
version 9.0;
u data\ABRZ3dAER.dta;
so state nic3 year;

gen sdum1 = (state==1);
gen sdum2 = (state==2);
gen sdum3 = (state==3);
gen sdum4 = (state==4);
gen sdum5 = (state==5);
gen sdum7 = (state==7);
gen sdum8 = (state==8);
gen sdum9 = (state==9);
gen sdum10 = (state==10);
gen sdum11 = (state==11);
gen sdum14 = (state==14);
gen sdum15 = (state==15);
gen sdum16 = (state==16);
gen sdum18 = (state==18);
gen sdum20 = (state==20);
gen sdum21 = (state==21);

gen d_state1=delicense*sdum1;
gen d_state2=delicense*sdum2;
gen d_state3=delicense*sdum3;
gen d_state4=delicense*sdum4;
gen d_state5=delicense*sdum5;
gen d_state7=delicense*sdum7;
gen d_state8=delicense*sdum8;
gen d_state9=delicense*sdum9;
gen d_state10=delicense*sdum10;
gen d_state11=delicense*sdum11;
gen d_state14=delicense*sdum14;
gen d_state15=delicense*sdum15;
gen d_state16=delicense*sdum16;
gen d_state18=delicense*sdum18;
gen d_state20=delicense*sdum20;
gen d_state21=delicense*sdum21;

****** Table 2 Columns (1) to (4) plus additional results for state*delicense interactions;

* Table 2 Column (1);
xi: areg lirnfac delicense yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Additional results to Column (1) with state fixed effects interactions;
xi: areg lirnfac d_state* yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
test d_state1=d_state2=d_state3=d_state4=d_state5=d_state7=d_state8=d_state9=d_state10
=d_state11=d_state14=d_state15=d_state16=d_state18=d_state20=d_state21;
* Table 2 Column (2);
xi: areg lirnfac delicense nstrict yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Additional results to Column (2) with state fixed effects interactions;
xi: areg lirnfac d_state* nstrict yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
test d_state1=d_state2=d_state3=d_state4=d_state5=d_state7=d_state8=d_state9=d_state10
=d_state11=d_state14=d_state15=d_state16=d_state18=d_state20=d_state21;
* Table 2 Column (3);
xi: areg lRirout delicense yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Additional results to Column (3) with state fixed effects interactions;
xi: areg lRirout d_state* yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
test d_state1=d_state2=d_state3=d_state4=d_state5=d_state7=d_state8=d_state9=d_state10
=d_state11=d_state14=d_state15=d_state16=d_state18=d_state20=d_state21;
* Table 2 Column (4);
xi: areg lRirout delicense nstrict yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Additional results to Column (4) with state fixed effects interactions;
xi: areg lRirout d_state* nstrict yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
test d_state1=d_state2=d_state3=d_state4=d_state5=d_state7=d_state8=d_state9=d_state10
=d_state11=d_state14=d_state15=d_state16=d_state18=d_state20=d_state21;

**** Additional results for employment and real physical capital with same format;

* Employment and Delicensing;
xi: areg lirte delicense yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Employment and Delicensing with state fixed effects interactions;
xi: areg lirte d_state* yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
test d_state1=d_state2=d_state3=d_state4=d_state5=d_state7=d_state8=d_state9=d_state10
=d_state11=d_state14=d_state15=d_state16=d_state18=d_state20=d_state21;
* Employment, Delicensing and Labor Regulation;
xi: areg lirte delicense nstrict yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Employment, Delicensing and Labor Regulation with state fixed effects interactions;
xi: areg lirte d_state* nstrict yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
test d_state1=d_state2=d_state3=d_state4=d_state5=d_state7=d_state8=d_state9=d_state10
=d_state11=d_state14=d_state15=d_state16=d_state18=d_state20=d_state21;
* Fixed capital and delicensing;
xi: areg lRircap delicense yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Fixed capital and delicensing with state fixed effects interactions;
xi: areg lRircap d_state* yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
test d_state1=d_state2=d_state3=d_state4=d_state5=d_state7=d_state8=d_state9=d_state10
=d_state11=d_state14=d_state15=d_state16=d_state18=d_state20=d_state21;
* Fixed capital, delicensing and labor regulation;
xi: areg lRircap delicense nstrict yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Fixed capital, delicensing and labor regulation with state fixed effects interactions;
xi: areg lRircap d_state* nstrict yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
test d_state1=d_state2=d_state3=d_state4=d_state5=d_state7=d_state8=d_state9=d_state10
=d_state11=d_state14=d_state15=d_state16=d_state18=d_state20=d_state21;

log close;

*************************************************************************************************;
**** Table 3 -- Delicensing, labor regulation and industrial performance in india: 1980-1997 ****;
*************************************************************************************************; 

log using tables\table3.log,replace;

* Column (1);
xi: areg lRirout nstrictdelic i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (2);
xi: areg lRirout nstrict80delic i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (3);
xi: areg lRirout fitnstrictdelic i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Overidentification test and standard error adjustment;
gen degfree=e(df_r);
predict sarganres, residuals;
gen temp=sarganres*sarganres;
egen ssq_sarganres=sum(temp);
so state nic3 year;
drop temp;
replace ssq_sarganres=ssq_sarganres/degfree;
predict fitvals, xbd;
gen othres=lRirout-(fitvals-(_b[fitnstrictdelic]*fitnstrictdelic)+(_b[fitnstrictdelic]*nstrictdelic));
gen temp=othres*othres;
egen ssq_othres=sum(temp);
so state nic3 year;
drop temp;
replace ssq_othres=ssq_othres/degfree;
gen se_adjust=ssq_othres/ssq_sarganres;
su se_adjust;
xi: areg sarganres delicinterun delicintermwa i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
gen nobs=e(N);
gen R2=e(r2);
gen sargan=nobs*R2;
di chi2tail(1,sargan);
gen prob=chiprob(1,sargan);
drop sarganres nobs R2 sargan prob degfree ssq_sarganres fitvals othres ssq_othres se_adjust;
* Column (4);
xi: areg lRirout nstrictdelic i.state|delicense i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);

**** Employment and fixed capital results discussed in the text;

* Employment;
xi: areg lirte nstrictdelic i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Fixed capital;
xi: areg lRircap nstrictdelic i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);

log close;

log using tables\table4.log,replace;

*********************************************************************************************************;
**** Table 4-- Trade liberalization, labor regulation and industrial performance in india: 1980-1997 ****;
*********************************************************************************************************; 

* Column (1);
xi: areg lRirout nstricttar i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (2);
xi: areg lRirout nstrictdelic nstricttar i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (3);
xi: areg lRirout nstricttar nstrictfdi i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (4);
xi: areg lRirout nstrictdelic nstricttar nstrictfdi i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);

log close;

log using tables\table5.log,replace;

*********************************************************************************************;
**** Table 5 -- Robustness to Interactions with State and State-Industry Characteristics ****;
*********************************************************************************************;

* Column (1);
xi: areg lRirout nstrictdelic ldevdelic delicrunbforIV i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
gen degfree=e(df_r);
* Standard Error Adjustment;
predict ivres, res;
gen temp=ivres*ivres;
egen ssq_ivres=sum(temp);
so state nic3 year;
drop temp;
replace ssq_ivres=ssq_ivres/degfree;
predict fitvals, xbd;
gen othres=lRirout-(fitvals-(_b[delicrunbforIV]*delicrunbforIV)+(_b[delicrunbforIV]*delicrunbfor));
gen temp=othres*othres;
egen ssq_othres=sum(temp);
so state nic3 year;
drop temp;
replace ssq_othres=ssq_othres/degfree;
gen se_adjust=ssq_othres/ssq_ivres;
su se_adjust;
drop ivres degfree ssq_ivres fitvals othres ssq_othres se_adjust;

* Column (2);
xi: areg lRirout nstrictdelic ldevdelic delicrunbforIV p1_del p3_del i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
gen degfree=e(df_r);
* Standard Error Adjustment;
predict ivres, res;
gen temp=ivres*ivres;
egen ssq_ivres=sum(temp);
so state nic3 year;
drop temp;
replace ssq_ivres=ssq_ivres/degfree;
predict fitvals, xbd;
gen othres=lRirout-(fitvals-(_b[delicrunbforIV]*delicrunbforIV)+(_b[delicrunbforIV]*delicrunbfor));
gen temp=othres*othres;
egen ssq_othres=sum(temp);
so state nic3 year;
drop temp;
replace ssq_othres=ssq_othres/degfree;
gen se_adjust=ssq_othres/ssq_ivres;
su se_adjust;
drop ivres degfree ssq_ivres fitvals othres ssq_othres se_adjust;

* Column (3);
xi: areg lRirout nstrictdelic ldevdelic delicrunbforIV p1_del p3_del cmconadelic cmhdlftdelic cmjandelic cmregdelic cmhindudelic i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
gen degfree=e(df_r);
* Standard Error Adjustment;
predict ivres, res;
gen temp=ivres*ivres;
egen ssq_ivres=sum(temp);
so state nic3 year;
drop temp;
replace ssq_ivres=ssq_ivres/degfree;
predict fitvals, xbd;
gen othres=lRirout-(fitvals-(_b[delicrunbforIV]*delicrunbforIV)+(_b[delicrunbforIV]*delicrunbfor));
gen temp=othres*othres;
egen ssq_othres=sum(temp);
so state nic3 year;
drop temp;
replace ssq_othres=ssq_othres/degfree;
gen se_adjust=ssq_othres/ssq_ivres;
su se_adjust;
capture drop ivres degfree ssq_ivres fitvals othres ssq_othres se_adjust;

log close;

******************************************************************************;
**** Additional Sensitivity Analysis Discussed in a Footnote in the Paper ****;
******************************************************************************;

* Column (1);
xi: areg lRirout nstrictdelic delicpfedu delicpfhlth delicpfoth delicrunbforIV delicclre delichead delic_elec_CSubsidy i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (2);
xi: areg lRirout nstrictdelic delicpfedu delicpfhlth delicpfoth delicrunbforIV delicclre delichead delic_elec_CSubsidy p1_del p3_del i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (3);
xi: areg lRirout nstrictdelic delicpfedu delicpfhlth delicpfoth delicrunbforIV delicclre delichead delic_elec_CSubsidy p1_del p3_del cmconadelic cmhdlftdelic cmjandelic cmregdelic cmhindudelic i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);

log using tables\tablea3.log,replace;

********************************************************************************************************************************************;
**** Wed Appendix Table A3: Delicensing, Trade Liberalization, FDI Reform, Labor Regulation and Industrial Performance in India 1980-97 ****;
**** Alternative Specification with state-industry interactions and year fixed effects                                                  ****;
********************************************************************************************************************************************;

* Column (1);
xi: areg lRirout delicense nstrict nstrictdelic yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (2);
xi: areg lRirout tariff nstrict yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (3);
xi: areg lRirout nstrict tariff nstricttar yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (4);
xi: areg lRirout delicense nstrict nstrictdelic tariff nstricttar yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (5);
xi: areg lRirout tariff FDIreform yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (6);
xi: areg lRirout nstrict tariff nstricttar FDIreform nstrictfdi yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
* Column (7);
xi: areg lRirout delicense nstrict nstrictdelic tariff nstricttar FDIreform nstrictfdi yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);

log close;

capture log close;
