
# delimit;
clear;
set mem 400m;
set matsize 1200;
version 10.0;
cap log close;

set more off;

log using logs\financialdevelopment_abrz.log,replace;

*****************************************************************************************************;
**** This file contains the first-stage estimation for the financial development instrumentation ****;
**** The source for the data is Burgess and Pande (2005)                                         ****;
*****************************************************************************************************;

use data\financialdevelopment_abrz.dta;

macro define controls " popt61 popt77 popd77 popt90 popdum90 rursht61 rursht77 rurshd77 rursht90 rurshd90  stint61 stint77 stin77d stint90 stindum90";

* Table 1: Banking as a Function of Initial financial development;

* IV runbfor;
reg runbfor ubt61 ubt77 ubt90 ubdum77 ubdum90 $controls stdum* yrdum*,cluster(state);
test ubt61+ubt77=0;
test ubt61+ubt77+ubt90=0;
predict runbforIV, xb;

lab var runbforIV	"Instrumented Runbfor from Burgess-Pande";

log close;
