
#delimit;
clear;
capture log close;
set mem 400m;
set matsize 800;
set more off;
version 10.0;

log using logs\labreginstrumented_abrz.log,replace;

u data\labreginstrumented_abrz.dta;
so state year;

************************************************************************************************;
**** This file contains the first-stage estimation for the labor regulation instrumentation ****;
**** The source for the data is Besley and Burgess (2004)                                   ****;
************************************************************************************************;

areg nstrict interun intermwa yy* , abs(state) cluster(state);
test interun intermwa;
predict nstrictres,residuals;
predict fitnstrict,xbd;

lab var fitnstrict 	"Instrumented Labor Regulation";

log close;

#delimit cr

