
#delimit;
clear;
capture log close;
set memory 500m;
set matsize 4000;
set more off;
version 8.0;

*****************************************************;
**** 100 SIMULATIONS                             ****;
**** EMPIRICAL DISTRIBUTION OF DELICENSING YEARS ****;
**** RANDOM DELICENSING ONLY                     ****;
**** SPECIFICATION INCLUDING STATE-INDUSTRY      ****;
**** INTERACTIONS AND YEAR DUMMIES               ****;
*****************************************************;

u data\ABRZ3dAER.dta;
so state nic3 year;

* Merge random measure;

keep state nic3 year yy* statenic3 lRirout delicense nstrict nstrictdelic noj_yr statefirstyr;
so nic3 year state;
merge nic3 year using placebos\randdeldata\eranddel_1.dta;
tab _m;
keep if _m==3;
drop _m;
so state nic3 year;

* Create state-first year for random measures;

capture prog drop sfy;
prog def sfy;

while "${_1}"~=""{;

quietly so nic3 state year;
quietly by nic3 state: gen fsy_${_1}=year if ${_1}[_n]==1&${_1}[_n-1]==0;
quietly egen temp=max(fsy_${_1}),by(nic3);
quietly so state nic3 year;
quietly replace fsy_${_1}=temp;
quietly drop temp;
quietly replace fsy_${_1}=2000 if fsy_${_1}==.;
quietly gen sfsy_${_1}=(state*100000)+fsy_${_1};

macro shift;
};
end;

sfy eranddel1 eranddel2 eranddel3 eranddel4 eranddel5 eranddel6 eranddel7 eranddel8 eranddel9 eranddel10
eranddel11 eranddel12 eranddel13 eranddel14 eranddel15 eranddel16 eranddel17 eranddel18 eranddel19 eranddel20
eranddel21 eranddel22 eranddel23 eranddel24 eranddel25 eranddel26 eranddel27 eranddel28 eranddel29 eranddel30
eranddel31 eranddel32 eranddel33 eranddel34 eranddel35 eranddel36 eranddel37 eranddel38 eranddel39 eranddel40
eranddel41 eranddel42 eranddel43 eranddel44 eranddel45 eranddel46 eranddel47 eranddel48 eranddel49 eranddel50
eranddel51 eranddel52 eranddel53 eranddel54 eranddel55 eranddel56 eranddel57 eranddel58 eranddel59 eranddel60
eranddel61 eranddel62 eranddel63 eranddel64 eranddel65 eranddel66 eranddel67 eranddel68 eranddel69 eranddel70
eranddel71 eranddel72 eranddel73 eranddel74 eranddel75 eranddel76 eranddel77 eranddel78 eranddel79 eranddel80
eranddel81 eranddel82 eranddel83 eranddel84 eranddel85 eranddel86 eranddel87 eranddel88 eranddel89 eranddel90
eranddel91 eranddel92 eranddel93 eranddel94 eranddel95 eranddel96 eranddel97 eranddel98 eranddel99 eranddel100;

so state nic3 year;

* Regression specification with true delicensing measure; 

xi: areg lRirout delicense nstrict nstrictdelic yy* if noj_yr==18, abs(statenic3) cluster(statefirstyr);
gen true=_b[nstrictdelic]/_se[nstrictdelic];
replace true=abs(true);

gen inter=.;
gen countsignif_1 = 0;
gen tstat=.;

******************************************************************;
**** Estimate specification using random delicensing measures ****;
******************************************************************;

local x = 1;

while `x' <= 100 {;

replace inter=nstrict*eranddel`x';

quietly xi: areg lRirout eranddel`x' nstrict inter yy* if noj_yr==18, abs(statenic3) cluster(sfsy_eranddel`x');

replace tstat=_b[inter]/_se[inter];
replace tstat=abs(tstat);
if tstat>true replace countsignif_1=countsignif_1+1;

local x = `x' + 1;

};

log using logs\emprandlicense2.log,replace;

***************************;
**** Summarize results ****;
****************************;

su countsignif_1;

log close;

