
#delimit;
clear;
capture log close;
set memory 500m;
set matsize 4000;
set more off;
version 8.0;

*****************************************************;
**** 100 SIMULATIONS                             ****;
**** EMPIRICAL DISTRIBUTION OF DELICENSING YEARS ****;
**** RANDOM AND TRUE DELICENSING                 ****;
**** SPECIFICATION WITH STATE-INDUSTRY           ****;
**** STATE-YEAR AND INDUSTRY-YEAR INTERACTIONS   ****;
*****************************************************;

u data\ABRZ3dAER.dta;
so state nic3 year;

*******************************************;
**** Merge random delicensing measures ****;
*******************************************;

* Merge random measures;

keep state nic3 year yy* statenic3 lRirout delicense nstrict nstrictdelic stateyr nic3yr noj_yr statefirstyr;
so nic3 year state;
merge nic3 year using placebos\randdeldata\eranddel_1.dta;
tab _m;
keep if _m==3;
drop _m;
so state nic3 year;

* Create state-first year for random measures;

capture prog drop sfy;
prog def sfy;

while "${_1}"~=""{;

quietly so nic3 state year;
quietly by nic3 state: gen fsy_${_1}=year if ${_1}[_n]==1&${_1}[_n-1]==0;
quietly egen temp=max(fsy_${_1}),by(nic3);
quietly so state nic3 year;
quietly replace fsy_${_1}=temp;
quietly drop temp;
quietly replace fsy_${_1}=2000 if fsy_${_1}==.;
quietly gen sfsy_${_1}=(state*100000)+fsy_${_1};

macro shift;
};
end;

sfy eranddel1 eranddel2 eranddel3 eranddel4 eranddel5 eranddel6 eranddel7 eranddel8 eranddel9 eranddel10
eranddel11 eranddel12 eranddel13 eranddel14 eranddel15 eranddel16 eranddel17 eranddel18 eranddel19 eranddel20
eranddel21 eranddel22 eranddel23 eranddel24 eranddel25 eranddel26 eranddel27 eranddel28 eranddel29 eranddel30
eranddel31 eranddel32 eranddel33 eranddel34 eranddel35 eranddel36 eranddel37 eranddel38 eranddel39 eranddel40
eranddel41 eranddel42 eranddel43 eranddel44 eranddel45 eranddel46 eranddel47 eranddel48 eranddel49 eranddel50
eranddel51 eranddel52 eranddel53 eranddel54 eranddel55 eranddel56 eranddel57 eranddel58 eranddel59 eranddel60
eranddel61 eranddel62 eranddel63 eranddel64 eranddel65 eranddel66 eranddel67 eranddel68 eranddel69 eranddel70
eranddel71 eranddel72 eranddel73 eranddel74 eranddel75 eranddel76 eranddel77 eranddel78 eranddel79 eranddel80
eranddel81 eranddel82 eranddel83 eranddel84 eranddel85 eranddel86 eranddel87 eranddel88 eranddel89 eranddel90
eranddel91 eranddel92 eranddel93 eranddel94 eranddel95 eranddel96 eranddel97 eranddel98 eranddel99 eranddel100;

so state nic3 year;

* Specification with true delicensing measure; 

xi: areg lRirout nstrictdelic i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
gen true=_b[nstrictdelic]/_se[nstrictdelic];
replace true=abs(true);

gen inter=.;
gen rcountsignif_1 = 0;
gen ocountsignif_1 = 0;
gen rtstat=.;
gen otstat=.;

****************************************************;
**** Estimate Placebo Delicensing Specification ****;
****************************************************;

gen iter_1=.;

local x = 1;

while `x' <= 100 {;

di "Simulation 1";
di `x';
quietly replace inter=nstrict*eranddel`x';

quietly xi: areg lRirout nstrictdelic inter i.stateyr i.nic3yr if noj_yr==18, abs(statenic3) cluster(statefirstyr);
quietly replace rtstat=_b[inter]/_se[inter];
quietly replace rtstat=abs(rtstat);
if rtstat>1.96 replace rcountsignif_1=rcountsignif_1+1;
if rtstat>1.96 corr eranddel`x' delicense;

quietly replace otstat=_b[nstrictdelic]/_se[nstrictdelic];
quietly replace otstat=abs(otstat);
if otstat>1.96 replace ocountsignif_1=ocountsignif_1+1;

quietly replace iter_1=`x';

local x = `x' + 1;

};

capture drop eranddel* fsy_* sfsy_* _Inic* _Istate*;

log using logs\emprandlicense5.log,replace;

******************************************;
**** Summarize results of simulations ****;
******************************************;

su rcountsignif_1;
su ocountsignif_1;

log close;

