
% MATLAB program to create random delicensing measures; 
% Assuming the empirical distribution of delicensing years;

% Aghion, Burgess, Redding and Zilibotti;
% The Unequal Effects of Liberalization: Evidence from Dismantling the License Raj;

% SJR : December 2007;

% Initialisations %;

% 156 is the desired number of industries ;
% 18 is the desired number of years ;
% 100 is the number of simulations ;

clc;

bigmat=zeros(15600,20);

% Industry codes;
temp1=[200 201 202 203 204 205 206 207 208 209 210 212 213 214 215 216 217 218 219]';
temp2=[220 221 222 223 224 225 226 227 229 230 231 232 233 234 235 236 240 241 242 243]';
temp3=[245 246 247 248 250 254 257 258 259 260 261 262 264 265 266 267 268 269 270 271]';
temp4=[272 273 274 275 276 277 279 280 281 283 284 285 286 287 288 289 290 291 292 293]';
temp5=[294 295 296 299 301 303 304 305 306 307 308 309 310 311 312 313 316 318 319 320]';
temp6=[321 322 323 324 325 326 327 329 331 332 333 334 335 336 339 340 342 343 344 345]';
temp7=[346 349 350 351 352 353 354 355 356 357 358 359 360 361 362 366 367 368 369 370]';
temp8=[371 372 374 375 376 377 378 379 380 381 382 383 385 386 387 388 389]';
nic3=vertcat(temp7,temp8);
nic3=vertcat(temp6,nic3);
nic3=vertcat(temp5,nic3);
nic3=vertcat(temp4,nic3);
nic3=vertcat(temp3,nic3);
nic3=vertcat(temp2,nic3);
nic3=vertcat(temp1,nic3);

% Empirical distribution of licensing years;
empdist=zeros(1,156);
empdist(1,1)=1982; empdist(1,2:49)=1985;
empdist(1,50:51)=1986; empdist(1,52)=1989;
empdist(1,53:132)=1991; empdist(1,133:134)=1993;
empdist(1,135:140)=1997; empdist(1,141:156)=2000;
empdist=empdist-1979;

% SIMULATION;
% This loop is the one hundred simulations;
x=1;
while x<=100;
disp('Simulation');
disp(x);
A=zeros(156,18);
    
% This loop fills the matrix of zeros with ones;
% after a randomly chosen year;
i=1;
while i<=156;
randdel=randint(1,1,[1,156]);
randyr=empdist(1,randdel);
if randyr<19;
    A(i,randyr:18)=1;
elseif randyr>=19;
    A(i,:)=0;
end        
i = i+1 ;
end;

% Store the random matrix for each simulation ;
% within a larger matrix ;

s = (156*(x-1)) + 1 ;
z = 156*x;
bigmat(s:z,1)=x;
bigmat(s:z,2)=nic3;
bigmat(s:z,3:20)=A;

x = x+1 ;
end;

%csvwrite('Z:\SR\ABRZdata\ABRZ3d_AER\placebos\delicensing\empranddel_1.csv',bigmat);


