
% Simulations for Bernard, Redding, Schott (2006);
% "Comparative Advantage and Heterogenous Firms"; 

% SJR, March 31, 2006;

% Comparison of costly trade and autarky equilibria of the;
% heterogeneous firm model;

% The file evaluates total, within and between-industry labor turnover;

% The file first solves for the costly trade equilibrium with;
% variable trade costs of 1.2

% The file then merges in the data for autarky equilibrium values;

% The file then evaluates total, within and between-industry labor;
% turnover in moving from the autarkic steady-state equilibrium;
% to the costly trade steady-state equilibrium with;
% variable trade costs of 1.2;

clear;
clc;

format short;

% PARAMETER VALUES;

% numeraire (home skilled wage);
Ws=1;           

% fixed production costs;
f1=0.10; f2=0.10;

% entry and exit;
fe1=2; fe2=2; delta=0.025;

% variable trade costs;
tau1=1.2; tau2=1.2;
% fixed exporting costs;
fx1=f1; fx2=f2;

% labour supplies;
L=1000;          % home skilled labour abundant;
S=1200;
l=1200;
s=1000;

% cobb-douglas expenditure share;
alpha=0.5;

% elasticity of substitution;
sigma=3.8; rho=1-1/sigma;

% production technologies;
beta1=0.6;       % good 1 skill intensive;
beta2=0.4;

% pareto parameters;
k=0.2; c=3.4; gamma=c-sigma+1; xi=c*(k^(c-gamma))/gamma;

% SOLUTION TO EQUATION SYSTEM;

% Starting values taken from free trade; 

Wl=1; wl=1; ws=1;
L1=520; L2=480; S1=780; S2=320; 
l1=320; l2=780; s1=480; s2=520; 
Q1=0.4831; Q2=0.4831; q1=0.4831; q2=0.4831;
M1=16.25; M2=10; m1=10; m2=16.25;
P1=0.2134; P2=0.2134; p1=0.2134; p2=0.2134;
E1=650; E2=400; e1=400; e2=650;
G1=400; G2=650; g1=650; g2=400;
R1=1300; R2=800; r1=800; r2=1300;
R=2100; r=2100; 
LAMBDA1=2; LAMBDA2=2; lambda1=2; lambda2=2;
PHI1=1.2937; PHI2=1.2937; phi1=1.2937; phi2=1.2937;
PSI1=5; PSI2=5; psi1=5; psi2=5;
A1=2.5873; A2=2.5873; a1=2.5873; a2=2.5873;
B1=2.5873; B2=2.5873; b1=2.5873; b2=2.5873;
X1=1; X2=1; x1=1; x2=1;
AR1=80; AR2=80; ar1=80; ar2=80;

start=([Wl wl ws L1 L2 S1 S2 l1 l2 s1 s2 Q1 Q2 q1 q2 P1 P2 p1 p2 E1 E2 e1 e2 G1 G2 g1 g2 R1 R2 r1 r2 R r M1 M2 m1 m2 LAMBDA1 LAMBDA2 lambda1 lambda2 PHI1 PHI2 phi1 phi2 PSI1 PSI2 psi1 psi2 A1 A2 a1 a2 B1 B2 b1 b2 X1 X2 x1 x2 AR1 AR2 ar1 ar2]);
start_i=start*1000000;
start_i=round(start_i);

% *******************************;
% **** Solve for equilibrium ****;
% *******************************;

store_s=ones(65,1);
store_n=ones(65,1);
converge=0;
vecones=1;

i=1;

while i<10000;

% Labor market equilibrium;
Wl=((1-beta1)*R1 + (1-beta2)*R2)/L;
wl=((1-beta1)*r1 + (1-beta2)*r2)/l; 
ws=(beta1*r1 + beta2*r2)/s;
L1=(1-beta1)*R1/Wl; 
L2=(1-beta2)*R2/Wl; 
S1=beta1*R1/Ws; 
S2=S-S1;
l1=(1-beta1)*r1/wl; 
l2=(1-beta2)*r2/wl; 
s1=beta1*r1/ws; 
s2=beta2*r2/ws; 

% Productivity cutoffs, entry and exit;
LAMBDA1=tau1 * (P1/p1) * ((R*fx1)/(r*f1))^(1/(sigma-1));
LAMBDA2=tau2 * (P2/p2) * ((R*fx2)/(r*f2))^(1/(sigma-1));
lambda1=tau1 * (p1/P1) * ((r*fx1)/(R*f1))^(1/(sigma-1));
lambda2=tau2 * (p2/P2) * ((r*fx2)/(R*f2))^(1/(sigma-1));
PHI1=(f1 + fx1*LAMBDA1^(-c))^(1/c) * (1/fe1)^(1/c) * ((1/delta)*(c/gamma-1)*k^c)^(1/c);
PHI2=(f2 + fx2*LAMBDA2^(-c))^(1/c) * (1/fe2)^(1/c) * ((1/delta)*(c/gamma-1)*k^c)^(1/c);
phi1=(f1 + fx1*lambda1^(-c))^(1/c) * (1/fe1)^(1/c) * ((1/delta)*(c/gamma-1)*k^c)^(1/c);
phi2=(f2 + fx2*lambda2^(-c))^(1/c) * (1/fe2)^(1/c) * ((1/delta)*(c/gamma-1)*k^c)^(1/c);
PSI1=LAMBDA1*PHI1;
PSI2=LAMBDA2*PHI2;
psi1=lambda1*phi1;
psi2=lambda2*phi2;
A1=(c/gamma)^(1/(sigma-1)) * PHI1;
A2=(c/gamma)^(1/(sigma-1)) * PHI2;
a1=(c/gamma)^(1/(sigma-1)) * phi1;
a2=(c/gamma)^(1/(sigma-1)) * phi2;
B1=(c/gamma)^(1/(sigma-1)) * PSI1;
B2=(c/gamma)^(1/(sigma-1)) * PSI2;
b1=(c/gamma)^(1/(sigma-1)) * psi1;
b2=(c/gamma)^(1/(sigma-1)) * psi2;
X1=(PHI1/PSI1)^c;
X2=(PHI2/PSI2)^c;
x1=(phi1/psi1)^c;
x2=(phi2/psi2)^c;
AR1=((A1/PHI1)^(sigma-1)) * sigma * f1 * (Ws)^beta1 * (Wl)^(1-beta1) + X1 * ((B1/PSI1)^(sigma-1)) * sigma * fx1 * (Ws)^beta1 * (Wl)^(1-beta1);
AR2=((A2/PHI2)^(sigma-1)) * sigma * f2 * (Ws)^beta2 * (Wl)^(1-beta2) + X2 * ((B2/PSI2)^(sigma-1)) * sigma * fx2 * (Ws)^beta2 * (Wl)^(1-beta2);
ar1=((a1/phi1)^(sigma-1)) * sigma * f1 * (ws)^beta1 * (wl)^(1-beta1) + x1 * ((b1/psi1)^(sigma-1)) * sigma * fx1 * (ws)^beta1 * (wl)^(1-beta1);
ar2=((a2/phi2)^(sigma-1)) * sigma * f2 * (ws)^beta2 * (wl)^(1-beta2) + x2 * ((b2/psi2)^(sigma-1)) * sigma * fx2 * (ws)^beta2 * (wl)^(1-beta2);

% Prices and expenditure;
Q1=(1/(rho*A1))*(Ws^beta1)*(Wl^(1-beta1));
Q2=(1/(rho*A2))*(Ws^beta2)*(Wl^(1-beta2)); 
q1=(1/(rho*a1))*(ws^beta1)*(wl^(1-beta1)); 
q2=(1/(rho*a2))*(ws^beta2)*(wl^(1-beta2)); 
M1=R1/AR1; 
M2=R2/AR2; 
m1=r1/ar1; 
m2=r2/ar2; 
P1=(M1*(Q1^(1-sigma)) + x1*m1*(tau1*(a1/b1)*q1)^(1-sigma))^(1/(1-sigma)); 
P2=(M2*(Q2^(1-sigma)) + x2*m2*(tau2*(a2/b2)*q2)^(1-sigma))^(1/(1-sigma)); 
p1=(m1*(q1^(1-sigma)) + X1*M1*(tau1*(A1/B1)*Q1)^(1-sigma))^(1/(1-sigma)); 
p2=(m2*(q2^(1-sigma)) + X2*M2*(tau2*(A2/B2)*Q2)^(1-sigma))^(1/(1-sigma)); 
E1=P1^(sigma-1) * Q1^(1-sigma) * alpha * R * M1; 
E2=P2^(sigma-1) * Q2^(1-sigma) * (1-alpha) * R * M2; 
e1=p1^(sigma-1) * q1^(1-sigma) * alpha * r * m1; 
e2=p2^(sigma-1) * q2^(1-sigma) * (1-alpha) * r * m2; 
G1=P1^(sigma-1) * tau1^(1-sigma) * ((a1/b1)*q1)^(1-sigma) * alpha * R * x1 * m1; 
G2=P2^(sigma-1) * tau2^(1-sigma) * ((a2/b2)*q2)^(1-sigma) * (1-alpha) * R * x2 * m2;
g1=p1^(sigma-1) * tau1^(1-sigma) * ((A1/B1)*Q1)^(1-sigma) * alpha * r * X1 * M1; 
g2=p2^(sigma-1) * tau2^(1-sigma) * ((A2/B2)*Q2)^(1-sigma) * (1-alpha) * r * X2 * M2; 
R1=E1+g1; 
R2=E2+g2;
r1=e1+G1;
r2=e2+G2; 
R=Ws*S+Wl*L;
r=ws*s+wl*l; 

new=([Wl wl ws L1 L2 S1 S2 l1 l2 s1 s2 Q1 Q2 q1 q2 P1 P2 p1 p2 E1 E2 e1 e2 G1 G2 g1 g2 R1 R2 r1 r2 R r M1 M2 m1 m2 LAMBDA1 LAMBDA2 lambda1 lambda2 PHI1 PHI2 phi1 phi2 PSI1 PSI2 psi1 psi2 A1 A2 a1 a2 B1 B2 b1 b2 X1 X2 x1 x2 AR1 AR2 ar1 ar2]);
new_i=new*1000000;
new_i=round(new_i);
test=new_i-start_i;
%test=new-start;

if test==0; 
    converge=1;
    i=10000;
else;
    start=(0.5*start)+(0.5*new);
    start_i=start*1000000;
    start_i=round(start_i);

    Wl     =start(1);
    wl     =start(2);
    ws     =start(3);
    L1     =start(4);
    L2     =start(5);
    S1     =start(6);
    S2     =start(7);
    l1     =start(8);
    l2     =start(9);
    s1     =start(10);
    s2     =start(11);
    Q1     =start(12);
    Q2     =start(13);
    q1     =start(14);
    q2     =start(15);
    P1     =start(16);
    P2     =start(17);
    p1     =start(18);
    p2     =start(19);
    E1     =start(20);
    E2     =start(21);
    e1     =start(22);
    e2     =start(23);
    G1     =start(24);
    G2     =start(25);
    g1     =start(26);
    g2     =start(27);
    R1     =start(28);
    R2     =start(29);
    r1     =start(30);
    r2     =start(31);
    R      =start(32);
    r      =start(33);
    M1     =start(34);
    M2     =start(35);
    m1     =start(36);
    m2     =start(37);
    LAMBDA1=start(38);
    LAMBDA2=start(39);
    lambda1=start(40);
    lambda2=start(41);
    PHI1   =start(42);
    PHI2   =start(43);
    phi1   =start(44);
    phi2   =start(45);
    PSI1   =start(46);
    PSI2   =start(47);
    psi1   =start(48);
    psi2   =start(49);
    A1     =start(50);
    A2     =start(51);
    a1     =start(52);
    a2     =start(53);
    B1     =start(54);
    B2     =start(55);
    b1     =start(56);
    b2     =start(57);
    X1     =start(58);
    X2     =start(59);
    x1     =start(60);
    x2     =start(61);
    AR1    =start(62);
    AR2    =start(63);
    ar1    =start(64);
    ar2    =start(65);
   
    i=i+1;
end;
end;

store_s=start';
store_n=new';

format short;

delete C:\Redding\Matlab\HoHetSimsReallocT\costly_output.out
diary('C:\Redding\Matlab\HoHetSimsReallocT\costly_output.out')

     disp('Solution vector')
     disp('Trade costs')
     tau1
     tau2
     disp('Labor market outcomes')
     Ws
     Wl
     wl
     ws
     L1
     L2
     S1
     S2
     l1
     l2
     s1
     s2
     disp('Check for labor market equilibrium')
     disp('home')
     Wscheck=(beta1*R1 + beta2*R2)/S
     Wlcheck=((1-beta1)*R1 + (1-beta2)*R2)/L
     Scheck=(beta1*R1)/Ws + (beta2*R2)/Ws
     Lcheck=((1-beta1)*R1)/Wl + ((1-beta2)*R2)/Wl
     disp('foreign')
     wscheck=(beta1*r1 + beta2*r2)/s
     wlcheck=((1-beta1)*r1 + (1-beta2)*r2)/l
     scheck=(beta1*r1)/ws + (beta2*r2)/ws
     lcheck=((1-beta1)*r1)/wl + ((1-beta2)*r2)/wl
     disp('Product market prices')
     Q1
     Q2
     q1
     q2
     P1
     P2
     p1
     p2
     disp('Expenditure')
     E1
     E2
     e1
     e2
     G1
     G2
     g1
     g2
     disp('Revenue')
     R1
     R2
     r1
     r2
     r
     R
     disp('Check income equals expenditure')
     Y1=Ws*S1+Wl*L1
     R1
     Y2=Ws*S2+Wl*L2
     R2
     y1=ws*s1+wl*l1
     r1
     y2=ws*s2+wl*l2
     r2
     Y=Ws*S+Wl*L
     R
     y=ws*s+wl*l
     r
     disp('Mass of firms')
     M1
     M2
     m1
     m2
     disp('Free entry and productivity cutoffs')
     LAMBDA1
     LAMBDA2
     lambda1
     lambda2
     PHI1
     PHI2
     phi1
     phi2
     PSI1
     PSI2
     psi1
     psi2
     disp('Average productivity, probability of exporting and average firm revenue')
     A1
     A2
     a1
     a2
     B1
     B2
     b1
     b2
     X1
     X2
     x1
     x2
     AR1
     AR2
     ar1
     ar2

format bank
test=store_s-store_n;
maxtest=max(test);
maxtest=max(maxtest)

% Read in autarky values for the comparison;
% Autarky values indicated by _a;

store_a=csvread('C:\Redding\Matlab\HoHetAutarky\autstore_n.csv');

% ****************************************;
% **** Generate variables of interest ****;
% ****************************************;

% Average profitability under costly trade;

AP1=(store_n(62)./sigma) - ( f1.*(1.^(beta1)).*(store_n(1).^(1-beta1)) ) - ( store_n(58).*fx1.*(1.^(beta1)).*(store_n(1).^(1-beta1)) );       
AP2=(store_n(63)./sigma) - ( f2.*(1.^(beta2)).*(store_n(1).^(1-beta2)) ) - ( store_n(59).*fx2.*(1.^(beta2)).*(store_n(1).^(1-beta2)) );
ap1=(store_n(64)./sigma) - ( f1.*(store_n(3).^(beta1)).*(store_n(2).^(1-beta1)) ) - ( store_n(60).*fx1.*(store_n(3).^(beta1)).*(store_n(2).^(1-beta1)) );       
ap2=(store_n(65)./sigma) - ( f2.*(store_n(3).^(beta2)).*(store_n(2).^(1-beta2)) ) - ( store_n(61).*fx2.*(store_n(3).^(beta2)).*(store_n(2).^(1-beta2)) );

% Average profitability under autarky;

AP_a1=(store_a(62)./sigma) - ( f1.*(1.^(beta1)).*(store_a(1).^(1-beta1)) ) - ( store_a(58).*fx1.*(1.^(beta1)).*(store_a(1).^(1-beta1)) );       
AP_a2=(store_a(63)./sigma) - ( f2.*(1.^(beta2)).*(store_a(1).^(1-beta2)) ) - ( store_a(59).*fx2.*(1.^(beta2)).*(store_a(1).^(1-beta2)) );
ap_a1=(store_a(64)./sigma) - ( f1.*(store_a(3).^(beta1)).*(store_a(2).^(1-beta1)) ) - ( store_a(60).*fx1.*(store_a(3).^(beta1)).*(store_a(2).^(1-beta1)) );       
ap_a2=(store_a(65)./sigma) - ( f2.*(store_a(3).^(beta2)).*(store_a(2).^(1-beta2)) ) - ( store_a(61).*fx2.*(store_a(3).^(beta2)).*(store_a(2).^(1-beta2)) );

% Total industry profits under costly trade;

PI1=store_n(34).*AP1;
PI2=store_n(35).*AP2;
pi1=store_n(36).*ap1;
pi2=store_n(37).*ap2;

% Total industry profits under autarky;

PI_a1=store_a(34).*AP_a1;
PI_a2=store_a(35).*AP_a2;
pi_a1=store_a(36).*ap_a1;
pi_a2=store_a(37).*ap_a2;

% ******************************;
% **** Analyze Reallocation ****;
% ******************************;

% Industry Revenue under costly trade;

R1=store_n(28);
R2=store_n(29);
r1=store_n(30);
r2=store_n(31);

% Industry Revenue under autarky;

R_a1=store_a(28);
R_a2=store_a(29);
r_a1=store_a(30);
r_a2=store_a(31);

% Industry skilled employment under costly trade;

S1=store_n(6);
S2=store_n(7);
s1=store_n(10);
s2=store_n(11);

% Industry skilled employment under autarky;

S_a1=store_a(6);
S_a2=store_a(7);
s_a1=store_a(10);
s_a2=store_a(11);

% Industry unskilled employment under costly trade;

L1=store_n(4);
L2=store_n(5);
l1=store_n(8);
l2=store_n(9);

% Industry unskilled employment under autarky;

L_a1=store_a(4);
L_a2=store_a(5);
l_a1=store_a(8);
l_a2=store_a(9);

% Skilled wage under costly trade;

Wl=store_n(1);
ws=store_n(3);
wl=store_n(2);

% Skilled wage under autarky;

Ws_a=1;
Wl_a=store_a(1);
ws_a=store_a(3);
wl_a=store_a(2);

% Ex ante probabilities of successful entry under costly trade;

GPHI1    = 1 - ((k./store_n(42)).^c);
GPHI2    = 1 - ((k./store_n(43)).^c);
gphi1    = 1 - ((k./store_n(44)).^c);
gphi2    = 1 - ((k./store_n(45)).^c);

% Ex ante probabilities of successful entry under autarky;

GPHI_a1    = 1 - ((k./store_a(42)).^c);
GPHI_a2    = 1 - ((k./store_a(43)).^c);
gphi_a1    = 1 - ((k./store_a(44)).^c);
gphi_a2    = 1 - ((k./store_a(45)).^c);

% Total labor payments in entry under costly trade;

INPAY1= PI1;
INPAY2= PI2;
inpay1= pi1;
inpay2= pi2;

% Total labor payments in entry under autarky;

INPAY_a1= PI_a1;            
INPAY_a2= PI_a2; 
inpay_a1= pi_a1;
inpay_a2= pi_a2;

% Unit factor costs under costly trade;

FACCOST1=(1^beta1).*(store_n(1).^(1-beta1));
FACCOST2=(1^beta2).*(store_n(1).^(1-beta2));
faccost1=(store_n(3).^beta1).*(store_n(2).^(1-beta1));
faccost2=(store_n(3).^beta2).*(store_n(2).^(1-beta2));

% Unit factor costs under autarky;

FACCOST_a1=(1^beta1).*(store_a(1).^(1-beta1));
FACCOST_a2=(1^beta2).*(store_a(1).^(1-beta2));
faccost_a1=(store_a(3).^beta1).*(store_a(2).^(1-beta1));
faccost_a2=(store_a(3).^beta2).*(store_a(2).^(1-beta2));

% ********************************************;
% **** Total labor payments decomposition ****;
% ********************************************;

% Total labor payments for domestic production under costly trade;

DPAY1=f1.*FACCOST1.*store_n(34).*((sigma-1).*(c/gamma) + 1);
DPAY2=f2.*FACCOST2.*store_n(35).*((sigma-1).*(c/gamma) + 1);
dpay1=f1.*faccost1.*store_n(36).*((sigma-1).*(c/gamma) + 1);
dpay2=f2.*faccost2.*store_n(37).*((sigma-1).*(c/gamma) + 1);

% Total labor payments for domestic production under autarky;

DPAY_a1=f1.*FACCOST_a1.*store_a(34).*((sigma-1).*(c/gamma) + 1);
DPAY_a2=f2.*FACCOST_a2.*store_a(35).*((sigma-1).*(c/gamma) + 1);
dpay_a1=f1.*faccost_a1.*store_a(36).*((sigma-1).*(c/gamma) + 1);
dpay_a2=f2.*faccost_a2.*store_a(37).*((sigma-1).*(c/gamma) + 1);

% Labor payments for export production under costly trade;
% (zero under autarky);

EPAY1=fx1.*FACCOST1.*store_n(58).*store_n(34).*((sigma-1).*(c/gamma) + 1);
EPAY2=fx2.*FACCOST2.*store_n(59).*store_n(35).*((sigma-1).*(c/gamma) + 1);
epay1=fx1.*faccost1.*store_n(60).*store_n(36).*((sigma-1).*(c/gamma) + 1);
epay2=fx2.*faccost2.*store_n(61).*store_n(37).*((sigma-1).*(c/gamma) + 1);

% Labor payments for domestic production at firms who will exit;
% following the opening of costly trade; 

DPAYx_a1=f1.*FACCOST_a1.*store_a(34).*((sigma-1).*(c/gamma).*(1-(store_n(42)./store_a(42)).^(-gamma))...
    + (1-(store_n(42)./store_a(42)).^(-c)));
DPAYx_a2=f2.*FACCOST_a2.*store_a(35).*((sigma-1).*(c/gamma).*(1-(store_n(43)./store_a(43)).^(-gamma))...
    + (1-(store_n(43)./store_a(43)).^(-c)));
dpayx_a1=f1.*faccost_a1.*store_a(36).*((sigma-1).*(c/gamma).*(1-(store_n(44)./store_a(44)).^(-gamma))...
    + (1-(store_n(44)./store_a(44)).^(-c)));
dpayx_a2=f2.*faccost_a2.*store_a(37).*((sigma-1).*(c/gamma).*(1-(store_n(45)./store_a(45)).^(-gamma))...
    + (1-(store_n(45)./store_a(45)).^(-c)));

% Labor payments for domestic production at firms who will survive; 
% following the opening of costly trade;

DPAYc_a1=f1.*FACCOST_a1.*store_a(34).*((sigma-1).*(c/gamma).*((store_n(42)./store_a(42)).^(-gamma))...
    + ((store_n(42)./store_a(42)).^(-c)));
DPAYc_a2=f2.*FACCOST_a2.*store_a(35).*((sigma-1).*(c/gamma).*((store_n(43)./store_a(43)).^(-gamma))...
    + ((store_n(43)./store_a(43)).^(-c)));
dpayc_a1=f1.*faccost_a1.*store_a(36).*((sigma-1).*(c/gamma).*((store_n(44)./store_a(44)).^(-gamma))...
    + ((store_n(44)./store_a(44)).^(-c)));
dpayc_a2=f2.*faccost_a2.*store_a(37).*((sigma-1).*(c/gamma).*((store_n(45)./store_a(45)).^(-gamma))...
    + ((store_n(45)./store_a(45)).^(-c)));

disp('Test that industry revenue sums to components paid to factors used in entry and production');

disp('Costly Trade');
TEST1=INPAY1+DPAY1+EPAY1; TEST2=INPAY2+DPAY2+EPAY2; test1=inpay1+dpay1+epay1; 
test2=inpay2+dpay2+epay2;
TEST1-R1
TEST2-R2
test1-r1
test2-r2

disp('Autarky');
TEST_a1=INPAY_a1+DPAY_a1;
TEST_a2=INPAY_a2+DPAY_a2;
test_a1=inpay_a1+dpay_a1; 
test_a2=inpay_a2+dpay_a2;
TEST_a1-R_a1
TEST_a2-R_a2
test_a1-r_a1
test_a2-r_a2

disp('Autarky: Exitors and Survivors decomposition');
TEST_a1=INPAY_a1+DPAYx_a1+DPAYc_a1;
TEST_a2=INPAY_a2+DPAYx_a2+DPAYc_a2;
test_a1=inpay_a1+dpayx_a1+dpayc_a1; 
test_a2=inpay_a2+dpayx_a2+dpayc_a2;
TEST_a1-R_a1
TEST_a2-R_a2
test_a1-r_a1
test_a2-r_a2

% ******************************************;
% **** Skilled Employment Decomposition ****;
% ******************************************;

% Skilled employment in entry under costly trade;

INS1= (beta1.*PI1)./1;
INS2= (beta2.*PI2)./1;
ins1= (beta1.*pi1)./ws;
ins2= (beta2.*pi2)./ws;

% Skilled employment in entry under autarky;

INS_a1= (beta1.*PI_a1)./1;            
INS_a2= (beta2.*PI_a2)./1; 
ins_a1= (beta1.*pi_a1)./ws_a;
ins_a2= (beta2.*pi_a2)./ws_a;

% Total skilled employment for domestic production under costly trade;

DS1=(beta1.*DPAY1)./1;
DS2=(beta2.*DPAY2)./1;
ds1=(beta1.*dpay1)./ws;
ds2=(beta2.*dpay2)./ws;

% Total skilled employment for domestic production under autarky;

DS_a1=(beta1.*DPAY_a1)./1;
DS_a2=(beta2.*DPAY_a2)./1;
ds_a1=(beta1.*dpay_a1)./ws_a;
ds_a2=(beta2.*dpay_a2)./ws_a;

% Skilled employment for export production under costly trade;
% (zero under autarky);

ES1=(beta1.*EPAY1)./1;
ES2=(beta2.*EPAY2)./1;
es1=(beta1.*epay1)./ws;
es2=(beta2.*epay2)./ws;

% Skilled employment for domestic production at firms who will exit;
% following the opening of costly trade; 

DSx_a1=(beta1.*DPAYx_a1)./1;
DSx_a2=(beta2.*DPAYx_a2)./1;
dsx_a1=(beta1.*dpayx_a1)./ws_a;
dsx_a2=(beta2.*dpayx_a2)./ws_a;

% Skilled employment for domestic production at firms who will survive;
% following the opening of costly trade; 

DSc_a1=(beta1.*DPAYc_a1)./1;
DSc_a2=(beta2.*DPAYc_a2)./1;
dsc_a1=(beta1.*dpayc_a1)./ws_a;
dsc_a2=(beta2.*dpayc_a2)./ws_a;

disp ('Test that skilled employment sums to components used in entry and production');

disp('Costly trade');
TEST1=INS1+DS1+ES1;  TEST2=INS2+DS2+ES2; test1=ins1+ds1+es1; test2=ins2+ds2+es2;
TEST1-S1
TEST2-S2
test1-s1
test2-s2

disp('Autarky');
TEST_a1=INS_a1+DS_a1; TEST_a2=INS_a2+DS_a2; 
test_a1=ins_a1+ds_a1; test_a2=ins_a2+ds_a2;
TEST_a1-S_a1
TEST_a2-S_a2
test_a1-s_a1
test_a2-s_a2

disp('Autarky: Exitors and Survivors decomposition');
TEST_a1=INS_a1+DSx_a1+DSc_a1; TEST_a2=INS_a2+DSx_a2+DSc_a2; 
test_a1=ins_a1+dsx_a1+dsc_a1; test_a2=ins_a2+dsx_a2+dsc_a2;
TEST_a1-S_a1
TEST_a2-S_a2
test_a1-s_a1
test_a2-s_a2

% Absolute change in skilled employment in entry;

RASin1=abs(INS1-INS_a1);
RASin2=abs(INS2-INS_a2);
rasin1=abs(ins1-ins_a1);
rasin2=abs(ins2-ins_a2);

% Absolute change in skilled employment due to exit following;
% the opening of costly trade;

RASx1=DSx_a1;
RASx2=DSx_a2;
rasx1=dsx_a1;
rasx2=dsx_a2;

% Absolute change in skilled employment for domestic production at 
% surviving firms following the opening of costly trade; 

RASc1=abs(DS1-DSc_a1);
RASc2=abs(DS2-DSc_a2);
rasc1=abs(ds1-dsc_a1);
rasc2=abs(ds2-dsc_a2);

% Absolute change in skilled employment due to exporting following the;
% opening of costly trade;

RASe1=ES1;
RASe2=ES2;
rase1=es1;
rase2=es2;

% Between-industry change in skilled employment;

BTWNS1=abs(S1-S_a1).*100./2200;
BTWNS2=abs(S2-S_a2).*100./2200;
btwns1=abs(s1-s_a1).*100./2200;
btwns2=abs(s2-s_a2).*100./2200;

% Total change in skilled employment;

TOTS1=(RASin1+RASx1+RASc1+RASe1).*100./2200;
TOTS2=(RASin2+RASx2+RASc2+RASe2).*100./2200;
tots1=(rasin1+rasx1+rasc1+rase1).*100./2200;
tots2=(rasin2+rasx2+rasc2+rase2).*100./2200;

% Within-industry change in skilled employment;

WITHS1=TOTS1-BTWNS1;
WITHS2=TOTS2-BTWNS2;
withs1=tots1-btwns1;
withs2=tots2-btwns2;

% ********************************************;
% **** Unskilled employment decomposition ****;
% ********************************************;

% Unskilled employment in entry under costly trade;

INL1= ((1-beta1).*PI1)./Wl;
INL2= ((1-beta2).*PI2)./Wl;
inl1= ((1-beta1).*pi1)./wl;
inl2= ((1-beta2).*pi2)./wl;

% Unskilled employment in entry under autarky;

INL_a1= ((1-beta1).*PI_a1)./Wl_a;            
INL_a2= ((1-beta2).*PI_a2)./Wl_a; 
inl_a1= ((1-beta1).*pi_a1)./wl_a;
inl_a2= ((1-beta2).*pi_a2)./wl_a;

% Total unskilled employment for domestic production under costly trade;

DL1=((1-beta1).*DPAY1)./Wl;
DL2=((1-beta2).*DPAY2)./Wl;
dl1=((1-beta1).*dpay1)./wl;
dl2=((1-beta2).*dpay2)./wl;

% Total unskilled employment for domestic production under autarky;

DL_a1=((1-beta1).*DPAY_a1)./Wl_a;
DL_a2=((1-beta2).*DPAY_a2)./Wl_a;
dl_a1=((1-beta1).*dpay_a1)./wl_a;
dl_a2=((1-beta2).*dpay_a2)./wl_a;

% Unskilled employment for export production under costly trade;
% (zero under autarky);

EL1=((1-beta1).*EPAY1)./Wl;
EL2=((1-beta2).*EPAY2)./Wl;
el1=((1-beta1).*epay1)./wl;
el2=((1-beta2).*epay2)./wl;

% Unskilled employment for domestic production at firms who will exit;
% following the opening of costly trade;

DLx_a1=((1-beta1).*DPAYx_a1)./Wl_a;
DLx_a2=((1-beta2).*DPAYx_a2)./Wl_a;
dlx_a1=((1-beta1).*dpayx_a1)./wl_a;
dlx_a2=((1-beta2).*dpayx_a2)./wl_a;

% Unskilled employment for domestic production at firms who will survive;
% following the opening of costly trade;

DLc_a1=((1-beta1).*DPAYc_a1)./Wl_a;
DLc_a2=((1-beta2).*DPAYc_a2)./Wl_a;
dlc_a1=((1-beta1).*dpayc_a1)./wl_a;
dlc_a2=((1-beta2).*dpayc_a2)./wl_a;

disp ('Test that unskilled employment sums to components used in entry and production');

disp('Costly trade');
TEST1=INL1+DL1+EL1;  TEST2=INL2+DL2+EL2; test1=inl1+dl1+el1; 
test2=inl2+dl2+el2;
TEST1-L1
TEST2-L2
test1-l1
test2-l2

disp('Autarky');
TEST_a1=INL_a1+DL_a1; TEST_a2=INL_a2+DL_a2;
test_a1=inl_a1+dl_a1; test_a2=inl_a2+dl_a2;
TEST_a1-L_a1
TEST_a2-L_a2
test_a1-l_a1
test_a2-l_a2

disp('Autarky: Exitors and Survivors Decomposition');
TEST_a1=INL_a1+DLx_a1+DLc_a1; TEST_a2=INL_a2+DLx_a2+DLc_a2;
test_a1=inl_a1+dlx_a1+dlc_a1; test_a2=inl_a2+dlx_a2+dlc_a2;
TEST_a1-L_a1
TEST_a2-L_a2
test_a1-l_a1
test_a2-l_a2

% Absolute change in unskilled employment in entry;

RALin1=abs(INL1-INL_a1);
RALin2=abs(INL2-INL_a2);
ralin1=abs(inl1-inl_a1);
ralin2=abs(inl2-inl_a2);

% Absolute change in unskilled employment due to exit following;
% the opening of costly trade;

RALx1=DLx_a1;
RALx2=DLx_a2;
ralx1=dlx_a1;
ralx2=dlx_a2;

% Absolute change in unskilled employment for domestic production;
% at surviving firms following the opening of costly trade; 

RALc1=abs(DL1-DLc_a1);
RALc2=abs(DL2-DLc_a2);
ralc1=abs(dl1-dlc_a1);
ralc2=abs(dl2-dlc_a2);

% Absolute change in unskilled employment due to exporting following the;
% opening of costly trade;

RALe1=abs(EL1);
RALe2=abs(EL2);
rale1=abs(el1);
rale2=abs(el2);

% Between-industry change in unskilled employment;

BTWNL1=abs(L1-L_a1).*100./2200;
BTWNL2=abs(L2-L_a2).*100./2200;
btwnl1=abs(l1-l_a1).*100./2200;
btwnl2=abs(l2-l_a2).*100./2200;

% Total change in unskilled employment;

TOTL1=(RALin1+RALx1+RALc1+RALe1).*100./2200;
TOTL2=(RALin2+RALx2+RALc2+RALe2).*100./2200;
totl1=(ralin1+ralx1+ralc1+rale1).*100./2200;
totl2=(ralin2+ralx2+ralc2+rale2).*100./2200;

% Within-industry change in unskilled employment;

WITHL1=TOTL1-BTWNL1;
WITHL2=TOTL2-BTWNL2;
withl1=totl1-btwnl1;
withl2=totl2-btwnl2;

disp('**** Test between-industry change equals the sum of the four components');

TESTS1=(INS1-INS_a1)-DSx_a1+(DS1-DSc_a1)+ES1;
TESTS2=(INS2-INS_a2)-DSx_a2+(DS2-DSc_a2)+ES2;
tests1=(ins1-ins_a1)-dsx_a1+(ds1-dsc_a1)+es1;
tests2=(ins2-ins_a2)-dsx_a2+(ds2-dsc_a2)+es2;

TESTL1=(INL1-INL_a1)-DLx_a1+(DL1-DLc_a1)+EL1;
TESTL2=(INL2-INL_a2)-DLx_a2+(DL2-DLc_a2)+EL2;
testl1=(inl1-inl_a1)-dlx_a1+(dl1-dlc_a1)+el1;
testl2=(inl2-inl_a2)-dlx_a2+(dl2-dlc_a2)+el2;

(S1-S_a1)-TESTS1
(S2-S_a2)-TESTS2
(s1-s_a1)-tests1
(s2-s_a2)-tests2

(L1-L_a1)-TESTL1
(L2-L_a2)-TESTL2
(l1-l_a1)-testl1
(l2-l_a2)-testl2

disp('****************************************************');
disp('**** Table 2 : Job Turnover as Trade Costs Fall ****');
disp('****************************************************');

disp('Comparative Advantage Industry: Abundant Factor');
TOTS1
BTWNS1
WITHS1
disp('Comparative Disadvantage Industry: Abundant Factor');
TOTS2
BTWNS2
WITHS2
disp('Comparative Advantage Industry: Scarce Factor');
TOTL1
BTWNL1
WITHL1
disp('Comparative Disadvantage Industry: Scarce Factor');
TOTL2
BTWNL2
WITHL2
