
% Simulations for Bernard, Redding, Schott (2006), "Comparative Advantage;
% and Heterogenous Firms";

% SJR, March 6, 2005;

% Helpman-Krugman version of the model;
    % Two differenatiated goods sectors with endogenous number of varieties;
    % All firms have same productivity and no sunk entry cost;

% All firms have the same productivity which is set equal to the value;
% of weighted average productivity in BRS under autarky;

% All firms pay the fixed cost of exporting;
% Can only run for values of trade costs where;
% Exporting cutoff is below BRS weighted average;
% productivity under autarky;

% Version #5 from London calibrated to BRS autarky;
% With factor content of trade;
    
clear;
clc;
format bank;

global Ws beta1 beta2 sigma tau1 tau2 alpha s l S L;

% PARAMETER VALUES;

% numeraire (home skilled wage);
Ws=1;           

% fixed production costs;
f1=0.10; f2=0.10;
% sunk entry costs;
fe1=2; fe2=2;

% variable trade costs;
tau1=1;           
tau2=1;
% fixed exporting costs;
fx1=f1; fx2=f2;

% labour supplies;
L=1000;          % home skilled labour abundant;          
S=1200;
l=1200;
s=1000;

% cobb-douglas expenditure share;
alpha=0.5;

% elasticity of substitution;
sigma=3.8;
rho=1-1/sigma;

% production technologies;
beta1=0.6;       % good 1 skill intensive;
beta2=0.4;

delta=0.025      % probability of death;

k=0.2;           % pareto parameters;
c=3.4; 

vecones=ones(1,13);

% Free trade starting values;

Wl=1; wl=1; ws=1;
L1=520; L2=480; S1=780; S2=320; 
l1=320; l2=780; s1=480; s2=520; 
Q1=1; Q2=1; q1=1; q2=1;
P1=0.07809; P2=0.07809; p1=0.07809; p2=0.07809;
E1=650; E2=400; e1=400; e2=650;
G1=400; G2=650; g1=650; g2=400;
R1=1300; R2=800; r1=800; r2=1300;
r=2100; R=2100; 
M1=1300; M2=800; m1=800; m2=1300;
AR1=R1/M1; AR2=R2/M2; ar1=r1/m1; ar2=r2/m2;

% Calibration values from BRS autarky

% Variable cost productivity parameter
PROD1=0.71677116406740.*vecones; PROD2=0.71677116406740.*vecones; 
prod1=0.71677116406740.*vecones; prod2=0.71677116406740.*vecones;
% Zero-profit cutoff productivity 
PHI1=0.38577575506631; PHI2=0.38577575506631; 
phi1=0.38577575506631; phi2=0.38577575506631;
% Probability of successful entry 
GPHI1=1-(k/PHI1)^c; GPHI2=1-(k/PHI2)^c; gphi1=1-(k/phi1)^c; gphi2=1-(k/phi2)^c;
% Rescale fixed production cost using information on the fixed entry cost,
% the probability of firm death, the probability of successful entry
% and the probability of firm exporting (equals 1 under free trade)
F1=f1+fx1+(delta*fe1/(1-GPHI1)); F2=f2+fx2+(delta*fe2/(1-GPHI2)); 
f1=f1+fx1+(delta*fe1/(1-gphi1)); f2=f2+fx2+(delta*fe2/(1-gphi2));

delete C:\Redding\Matlab\HKSimsT\HK_output.out;
diary('C:\Redding\Matlab\HKSimsT\HK_output.out');

% ***************************************;
% **** Loop to solve for equilibrium ****;
% ***************************************;

start=([Wl wl ws L1 L2 S1 S2 l1 l2 s1 s2 Q1 Q2 q1 q2 P1 P2 p1 p2 E1 E2 e1 e2 G1 G2 g1 g2 R1 R2 r1 r2 R r M1 M2 m1 m2 AR1 AR2 ar1 ar2]);
start_i=start*1000000;
start_i=round(start_i);

store_s=ones(41,13);
store_n=ones(41,13);
tau1value=ones(1,13);
tau2value=ones(1,13);
converge=zeros(1,13);

for z = 1:1:13;

disp('Iteration');
disp(z);

tau1value(z)=tau1;
tau2value(z)=tau2;

% Code for varying productivity;
A1=PROD1(z);
A2=PROD2(z);
a1=prod1(z);
a2=prod2(z);

i=1;

while i<10000;

% labor market equilibrium;
Wl=((1-beta1)*R1 + (1-beta2)*R2)/L; 
wl=((1-beta1)*r1 + (1-beta2)*r2)/l; 
ws=(beta1*r1 + beta2*r2)/s; 
L1=(1-beta1)*R1/Wl; 
L2=(1-beta2)*R2/Wl; 
S1=beta1*R1/Ws; 
S2=S-S1;
l1=(1-beta1)*r1/wl;
l2=(1-beta2)*r2/wl; 
s1=beta1*r1/ws; 
s2=beta2*r2/ws; 

% prices and expenditure;
Q1=(1/(rho*A1))*(Ws^beta1)*(Wl^(1-beta1)); 
Q2=(1/(rho*A2))*(Ws^beta2)*(Wl^(1-beta2)); 
q1=(1/(rho*a1))*(ws^beta1)*(wl^(1-beta1)); 
q2=(1/(rho*a2))*(ws^beta2)*(wl^(1-beta2)); 
AR1=sigma * F1 * (Ws^beta1) * (Wl^(1-beta1)) 
AR2=sigma * F2 * (Ws^beta2) * (Wl^(1-beta2)) 
ar1=sigma * f1 * (ws^beta1) * (wl^(1-beta1))
ar2=sigma * f2 * (ws^beta2) * (wl^(1-beta2))
M1=R1/AR1; 
M2=R2/AR2; 
m1=r1/ar1; 
m2=r2/ar2; 
P1=(M1*(Q1^(1-sigma)) + m1*(tau1*q1)^(1-sigma))^(1/(1-sigma)); 
P2=(M2*(Q2^(1-sigma)) + m2*(tau2*q2)^(1-sigma))^(1/(1-sigma)); 
p1=(m1*(q1^(1-sigma)) + M1*(tau1*Q1)^(1-sigma))^(1/(1-sigma)); 
p2=(m2*(q2^(1-sigma)) + M2*(tau2*Q2)^(1-sigma))^(1/(1-sigma)); 
E1=(P1)^(sigma-1) * Q1^(1-sigma) * alpha * R * M1; 
E2=(P2)^(sigma-1) * Q2^(1-sigma) * (1-alpha) * R * M2; 
e1=(p1)^(sigma-1) * q1^(1-sigma) * alpha * r * m1; 
e2=(p2)^(sigma-1) * q2^(1-sigma) * (1-alpha) * r * m2; 
G1=(P1)^(sigma-1) * tau1^(1-sigma) * q1^(1-sigma) * alpha * R * m1; 
G2=(P2)^(sigma-1) * tau2^(1-sigma) * q2^(1-sigma) * (1-alpha) * R * m2; 
g1=(p1)^(sigma-1) * tau1^(1-sigma) * Q1^(1-sigma) * alpha * r * M1; 
g2=(p2)^(sigma-1) * tau2^(1-sigma) * Q2^(1-sigma) * (1-alpha) * r * M2; 
R1=E1+g1;
R2=E2+g2;
r1=e1+G1;
r2=e2+G2;
R=Ws*S+Wl*L;
r=ws*s+wl*l;

new=([Wl wl ws L1 L2 S1 S2 l1 l2 s1 s2 Q1 Q2 q1 q2 P1 P2 p1 p2 E1 E2 e1 e2 G1 G2 g1 g2 R1 R2 r1 r2 R r M1 M2 m1 m2 AR1 AR2 ar1 ar2]);
new_i=new*1000000;
new_i=round(new_i);
test=new_i-start_i;

if test==0; 
    converge(z)=1;
    i=10000;
else;
    start=(0.5*start)+(0.5*new);
    start_i=start*1000000;
    start_i=round(start_i);

    Wl=start(1);
    wl=start(2);
    ws=start(3);
    L1=start(4);
    L2=start(5);
    S1=start(6);
    S2=start(7);
    l1=start(8);
    l2=start(9);
    s1=start(10);
    s2=start(11);
    Q1=start(12);
    Q2=start(13);
    q1=start(14);
    q2=start(15);
    P1=start(16);
    P2=start(17);
    p1=start(18);
    p2=start(19);
    E1=start(20);
    E2=start(21);
    e1=start(22);
    e2=start(23);
    G1=start(24);
    G2=start(25);
    g1=start(26);
    g2=start(27);
    R1=start(28);
    R2=start(29);
    r1=start(30);
    r2=start(31);
    R =start(32);
    r =start(33);
    M1=start(34);
    M2=start(35);
    m1=start(36);
    m2=start(37);
    AR1=start(38);
    AR2=start(39);
    ar1=start(40);
    ar2=start(41);

    i=i+1;
end;
end;

store_s(:,z)=start';
store_n(:,z)=new';
tau1=tau1+0.05;
tau2=tau2+0.05;

end;

     % solution
     Ws
     Wl
     wl
     ws
     L1
     L2
     S1
     S2
     l1
     l2
     s1
     s2
     Q1
     Q2
     q1
     q2
     P1
     P2
     p1
     p2
     E1
     E2
     e1
     e2
     G1
     G2
     g1
     g2
     R1
     R2
     r1
     r2
     r
     R
     M1
     M2
     m1
     m2
     AR1
     AR2
     ar1
     ar2
 
     disp('Check income equals expenditure')
     Y1=Ws*S1+Wl*L1
     R1
     Y2=Ws*S2+Wl*L2
     R2
     y1=ws*s1+wl*l1
     r1
     y2=ws*s2+wl*l2
     r2
     Y=Ws*S+Wl*L
     R
     y=ws*s+wl*l
     r
     
     disp('check home labor market equilibrium')
     Wscheck=(beta1*R1 + beta2*R2)/S
     Wlcheck=((1-beta1)*R1 + (1-beta2)*R2)/L
     Scheck=(beta1*R1)/Ws + (beta2*R2)/Ws
     Lcheck=((1-beta1)*R1)/Wl + ((1-beta2)*R2)/Wl
     
     disp('check foreign labor market equilibrium')
     wscheck=(beta1*r1 + beta2*r2)/s
     wlcheck=((1-beta1)*r1 + (1-beta2)*r2)/l
     scheck=(beta1*r1)/ws + (beta2*r2)/ws
     lcheck=((1-beta1)*r1)/wl + ((1-beta2)*r2)/wl
 

% Check and output comparative static equilibria
     
test=store_s-store_n;
maxtest=max(test)
maxtest=max(maxtest)

% Average output;
% Average revenue divided by average variety prices;
AOUT1=store_n(38,:)./store_n(12,:);
AOUT2=store_n(39,:)./store_n(13,:);
aout1=store_n(40,:)./store_n(14,:);
aout2=store_n(41,:)./store_n(15,:);

% Revenue;

R1=store_n(28,:);
R2=store_n(29,:);
R=R1+R2;

% Welfare;

P1=store_n(16,:);
P2=store_n(17,:);
p1=store_n(18,:);
p2=store_n(19,:);
CPI=(P1.^(alpha)).*(P2.^(1-alpha));
cpi=(p1.^(alpha)).*(p2.^(1-alpha));
WELF=R./CPI;
welf=r./cpi;

% Volume of trade;

VOL1  = store_n(26,:) + store_n(24,:);       % g1+G1;
VOL2  = store_n(27,:) + store_n(25,:);       % g2+G2;
VOL=VOL1+VOL2;
TGDP=VOL./R;
INTER1= store_n(26,:) - store_n(24,:);       % g1-G1;
INTER2= store_n(27,:) - store_n(25,:);       % g2-G2;
INTRA1= min(store_n(26,:),store_n(24,:));    % min(g1,G1);
INTRA2= min(store_n(27,:),store_n(25,:));    % min(g2,G2);
EXPORTS1=store_n(26,:);                      % g1;
EXPORTS2=store_n(27,:);                      % g2;
IMPORTS1=store_n(24,:);                      % G1;
IMPORTS2=store_n(25,:);                      % G2;
MS=(beta1.*-INTER1./1)+(beta2.*-INTER2./1);                                 % Net skill content of home imports;
ML=((1-beta1).*-INTER1./store_n(1,:))+((1-beta2).*-INTER2./store_n(1,:));   % Net labor content of home imports;
ms=(beta1.*INTER1./store_n(3,:))+(beta2.*INTER2./store_n(3,:));             % Net skill content of foreign imports;
ml=((1-beta1).*INTER1./store_n(2,:))+((1-beta2).*INTER2./store_n(2,:));     % Net labor content of foreign imports;

% Output data;

Ws=Ws.*vecones;

names={'converge' 'tau1' 'tau2' 'A1' 'A2' 'a1' 'a2' 'CPI' 'cpi' 'Ws' 'Wl' 'wl' 'ws' 'L1' 'L2' 'S1' 'S2' 'l1' 'l2' 's1' 's2' 'Q1' 'Q2' 'q1' 'q2' 'P1' 'P2' 'p1' 'p2' 'E1' 'E2' 'e1' 'e2' 'G1' 'G2' 'g1' 'g2' 'R1' 'R2' 'r1' 'r2' 'R' 'r' 'M1' 'M2' 'm1' 'm2' 'AR1' 'AR2' 'ar1' 'ar2' 'AOUT1' 'AOUT2' 'aout1' 'aout2'};
names=names';
data=vertcat(aout1,aout2);
data=vertcat(AOUT2,data);
data=vertcat(AOUT1,data);
data=vertcat(store_n,data);
data=vertcat(Ws,data);
data=vertcat(cpi,data);
data=vertcat(CPI,data);
data=vertcat(prod2,data);
data=vertcat(prod1,data);
data=vertcat(PROD2,data);
data=vertcat(PROD1,data);
data=vertcat(tau2value,data);
data=vertcat(tau1value,data);
data=vertcat(converge,data);
delete C:\Redding\Matlab\HKSimsT\hksims.txt;
save 'C:\Redding\Matlab\HKSimsT\hksims.txt' data -ASCII; 
diary('off');
 
delete C:\Redding\Matlab\HKSimsT\hknames.out;
diary('C:\Redding\Matlab\HKSimsT\hknames.out');
names
diary('off');

tradenames={'Converge' 'tau1' 'tau2' 'A1' 'A2' 'a1' 'a2' 'WELFARE' 'TRADETOGDP' 'VOL' 'VOLUME1' 'VOLUME2' 'INTERINDUSTRY1' 'INTERINDUSTRY2' 'INTRAINDUSTRY1' 'INTRAINDUSTRY2' 'MS' 'ML' 'ms' 'ml' 'Ws' 'Wl' 'wl' 'ws'};
tradenames=tradenames';
tradedata=vertcat(store_n(1,:),store_n(2,:),store_n(3,:));
tradedata=vertcat(Ws,tradedata);
tradedata=vertcat(ms,ml,tradedata);
tradedata=vertcat(MS,ML,tradedata);
tradedata=vertcat(INTRA1,INTRA2,tradedata);
tradedata=vertcat(INTER1,INTER2,tradedata);
tradedata=vertcat(VOL1,VOL2,tradedata);
tradedata=vertcat(VOL,tradedata);
tradedata=vertcat(WELF,TGDP,tradedata);
tradedata=vertcat(prod1,prod2,tradedata);
tradedata=vertcat(PROD1,PROD2,tradedata);
tradedata=vertcat(tau1value,tau2value,tradedata);
tradedata=vertcat(converge,tradedata);
delete C:\Redding\Matlab\HKSimsT\tradedata.txt;
save 'C:\Redding\Matlab\HKSimsT\tradedata.txt' tradedata -ASCII; 
delete C:\Redding\Matlab\HKSimsT\tradenames.out;
diary('C:\Redding\Matlab\HKSimsT\tradenames.out');
tradenames
diary('off');
