
% Simulations for Bernard, Redding, Schott (2006);
% "Comparative Advantage and Heterogenous Firms";

% Complete costly trade version of the heterogeneous firm model; 
% SJR, April, 2004;

clear;
clc;

format long;

% PARAMETER VALUES;

% numeraire (home skilled wage);
Ws=1;           

% fixed production costs;
f1=0.10; f2=0.10;

% entry and exit;
fe1=2; fe2=2; delta=0.025;

% variable trade costs;
tau1=1; tau2=1;
% fixed exporting costs;
fx1=f1; fx2=f2;

% labour supplies;
L=1000;          % home skilled labour abundant;
S=1200;
l=1200;
s=1000;

% cobb-douglas expenditure share;
alpha=0.5;

% elasticity of substitution;
sigma=3.8; rho=1-1/sigma;

% production technologies;
beta1=0.6;       % good 1 skill intensive;
beta2=0.4;

% pareto parameters;
k=0.2; c=3.4; gamma=c-sigma+1; xi=c*(k^(c-gamma))/gamma;

% SOLUTION TO EQUATION SYSTEM;

% Starting values taken from free trade; 

Wl=1; wl=1; ws=1;
L1=520; L2=480; S1=780; S2=320; 
l1=320; l2=780; s1=480; s2=520; 
Q1=0.4831; Q2=0.4831; q1=0.4831; q2=0.4831;
M1=16.25; M2=10; m1=10; m2=16.25;
P1=0.2134; P2=0.2134; p1=0.2134; p2=0.2134;
E1=650; E2=400; e1=400; e2=650;
G1=400; G2=650; g1=650; g2=400;
R1=1300; R2=800; r1=800; r2=1300;
R=2100; r=2100; 
LAMBDA1=2; LAMBDA2=2; lambda1=2; lambda2=2;
PHI1=1.2937; PHI2=1.2937; phi1=1.2937; phi2=1.2937;
PSI1=5; PSI2=5; psi1=5; psi2=5;
A1=2.5873; A2=2.5873; a1=2.5873; a2=2.5873;
B1=2.5873; B2=2.5873; b1=2.5873; b2=2.5873;
X1=1; X2=1; x1=1; x2=1;
AR1=80; AR2=80; ar1=80; ar2=80;

start=([Wl wl ws L1 L2 S1 S2 l1 l2 s1 s2 Q1 Q2 q1 q2 P1 P2 p1 p2 E1 E2 e1 e2 G1 G2 g1 g2 R1 R2 r1 r2 R r M1 M2 m1 m2 LAMBDA1 LAMBDA2 lambda1 lambda2 PHI1 PHI2 phi1 phi2 PSI1 PSI2 psi1 psi2 A1 A2 a1 a2 B1 B2 b1 b2 X1 X2 x1 x2 AR1 AR2 ar1 ar2]);
start_i=start*1000000;
start_i=round(start_i);

% ***************************************;
% **** Loop to solve for equilibrium ****;
% ***************************************;

store_s=ones(65,13);
store_n=ones(65,13);
tradecost=ones(1,13);
tau1value=ones(1,13);
tau2value=ones(1,13);
converge=zeros(1,13);
vecones=ones(1,13);

for z = 1:1:13;

disp('Iteration');
disp(z);
    
tau1value(z)=tau1;
tau2value(z)=tau2;
tradecost(z)=tau1;

i=1;

while i<10000;

% Labor market equilibrium;
Wl=((1-beta1)*R1 + (1-beta2)*R2)/L; 
wl=((1-beta1)*r1 + (1-beta2)*r2)/l; 
ws=(beta1*r1 + beta2*r2)/s; 
L1=(1-beta1)*R1/Wl; 
L2=(1-beta2)*R2/Wl; 
S1=beta1*R1/Ws; 
S2=S-S1; 
l1=(1-beta1)*r1/wl; 
l2=(1-beta2)*r2/wl; 
s1=beta1*r1/ws; 
s2=beta2*r2/ws; 

% Productivity cutoffs, entry and exit;
LAMBDA1=tau1 * (P1/p1) * ((R*fx1)/(r*f1))^(1/(sigma-1));
LAMBDA2=tau2 * (P2/p2) * ((R*fx2)/(r*f2))^(1/(sigma-1));
lambda1=tau1 * (p1/P1) * ((r*fx1)/(R*f1))^(1/(sigma-1));
lambda2=tau2 * (p2/P2) * ((r*fx2)/(R*f2))^(1/(sigma-1));
PHI1=(f1 + fx1*LAMBDA1^(-c))^(1/c) * (1/fe1)^(1/c) * ((1/delta)*(c/gamma-1)*k^c)^(1/c);
PHI2=(f2 + fx2*LAMBDA2^(-c))^(1/c) * (1/fe2)^(1/c) * ((1/delta)*(c/gamma-1)*k^c)^(1/c);
phi1=(f1 + fx1*lambda1^(-c))^(1/c) * (1/fe1)^(1/c) * ((1/delta)*(c/gamma-1)*k^c)^(1/c);
phi2=(f2 + fx2*lambda2^(-c))^(1/c) * (1/fe2)^(1/c) * ((1/delta)*(c/gamma-1)*k^c)^(1/c);
PSI1=LAMBDA1*PHI1;
PSI2=LAMBDA2*PHI2;
psi1=lambda1*phi1;
psi2=lambda2*phi2;
A1=(c/gamma)^(1/(sigma-1)) * PHI1;
A2=(c/gamma)^(1/(sigma-1)) * PHI2;
a1=(c/gamma)^(1/(sigma-1)) * phi1;
a2=(c/gamma)^(1/(sigma-1)) * phi2;
B1=(c/gamma)^(1/(sigma-1)) * PSI1;
B2=(c/gamma)^(1/(sigma-1)) * PSI2;
b1=(c/gamma)^(1/(sigma-1)) * psi1;
b2=(c/gamma)^(1/(sigma-1)) * psi2;
X1=(PHI1/PSI1)^c;
X2=(PHI2/PSI2)^c;
x1=(phi1/psi1)^c;
x2=(phi2/psi2)^c;
AR1=((A1/PHI1)^(sigma-1)) * sigma * f1 * (Ws)^beta1 * (Wl)^(1-beta1) + X1 * ((B1/PSI1)^(sigma-1)) * sigma * fx1 * (Ws)^beta1 * (Wl)^(1-beta1);
AR2=((A2/PHI2)^(sigma-1)) * sigma * f2 * (Ws)^beta2 * (Wl)^(1-beta2) + X2 * ((B2/PSI2)^(sigma-1)) * sigma * fx2 * (Ws)^beta2 * (Wl)^(1-beta2);
ar1=((a1/phi1)^(sigma-1)) * sigma * f1 * (ws)^beta1 * (wl)^(1-beta1) + x1 * ((b1/psi1)^(sigma-1)) * sigma * fx1 * (ws)^beta1 * (wl)^(1-beta1);
ar2=((a2/phi2)^(sigma-1)) * sigma * f2 * (ws)^beta2 * (wl)^(1-beta2) + x2 * ((b2/psi2)^(sigma-1)) * sigma * fx2 * (ws)^beta2 * (wl)^(1-beta2);

% Prices and expenditure;
Q1=(1/(rho*A1))*(Ws^beta1)*(Wl^(1-beta1));
Q2=(1/(rho*A2))*(Ws^beta2)*(Wl^(1-beta2)); 
q1=(1/(rho*a1))*(ws^beta1)*(wl^(1-beta1)); 
q2=(1/(rho*a2))*(ws^beta2)*(wl^(1-beta2)); 
M1=R1/AR1; 
M2=R2/AR2; 
m1=r1/ar1; 
m2=r2/ar2; 
P1=(M1*(Q1^(1-sigma)) + x1*m1*(tau1*(a1/b1)*q1)^(1-sigma))^(1/(1-sigma)); 
P2=(M2*(Q2^(1-sigma)) + x2*m2*(tau2*(a2/b2)*q2)^(1-sigma))^(1/(1-sigma)); 
p1=(m1*(q1^(1-sigma)) + X1*M1*(tau1*(A1/B1)*Q1)^(1-sigma))^(1/(1-sigma)); 
p2=(m2*(q2^(1-sigma)) + X2*M2*(tau2*(A2/B2)*Q2)^(1-sigma))^(1/(1-sigma)); 
E1=P1^(sigma-1) * Q1^(1-sigma) * alpha * R * M1; 
E2=P2^(sigma-1) * Q2^(1-sigma) * (1-alpha) * R * M2; 
e1=p1^(sigma-1) * q1^(1-sigma) * alpha * r * m1; 
e2=p2^(sigma-1) * q2^(1-sigma) * (1-alpha) * r * m2; 
G1=P1^(sigma-1) * tau1^(1-sigma) * ((a1/b1)*q1)^(1-sigma) * alpha * R * x1 * m1; 
G2=P2^(sigma-1) * tau2^(1-sigma) * ((a2/b2)*q2)^(1-sigma) * (1-alpha) * R * x2 * m2; 
g1=p1^(sigma-1) * tau1^(1-sigma) * ((A1/B1)*Q1)^(1-sigma) * alpha * r * X1 * M1; 
g2=p2^(sigma-1) * tau2^(1-sigma) * ((A2/B2)*Q2)^(1-sigma) * (1-alpha) * r * X2 * M2; 
R1=E1+g1; 
R2=E2+g2;
r1=e1+G1;
r2=e2+G2;
R=Ws*S+Wl*L;
r=ws*s+wl*l; 

new=([Wl wl ws L1 L2 S1 S2 l1 l2 s1 s2 Q1 Q2 q1 q2 P1 P2 p1 p2 E1 E2 e1 e2 G1 G2 g1 g2 R1 R2 r1 r2 R r M1 M2 m1 m2 LAMBDA1 LAMBDA2 lambda1 lambda2 PHI1 PHI2 phi1 phi2 PSI1 PSI2 psi1 psi2 A1 A2 a1 a2 B1 B2 b1 b2 X1 X2 x1 x2 AR1 AR2 ar1 ar2]);
new_i=new*1000000;
new_i=round(new_i);
test=new_i-start_i;
%test=new-start;

if test==0;
    converge(z)=1;
    i=10000;
else;
    start=(0.5*start)+(0.5*new);
    start_i=start*1000000;
    start_i=round(start_i);

    Wl     =start(1);
    wl     =start(2);
    ws     =start(3);
    L1     =start(4);
    L2     =start(5);
    S1     =start(6);
    S2     =start(7);
    l1     =start(8);
    l2     =start(9);
    s1     =start(10);
    s2     =start(11);
    Q1     =start(12);
    Q2     =start(13);
    q1     =start(14);
    q2     =start(15);
    P1     =start(16);
    P2     =start(17);
    p1     =start(18);
    p2     =start(19);
    E1     =start(20);
    E2     =start(21);
    e1     =start(22);
    e2     =start(23);
    G1     =start(24);
    G2     =start(25);
    g1     =start(26);
    g2     =start(27);
    R1     =start(28);
    R2     =start(29);
    r1     =start(30);
    r2     =start(31);
    R      =start(32);
    r      =start(33);
    M1     =start(34);
    M2     =start(35);
    m1     =start(36);
    m2     =start(37);
    LAMBDA1=start(38);
    LAMBDA2=start(39);
    lambda1=start(40);
    lambda2=start(41);
    PHI1   =start(42);
    PHI2   =start(43);
    phi1   =start(44);
    phi2   =start(45);
    PSI1   =start(46);
    PSI2   =start(47);
    psi1   =start(48);
    psi2   =start(49);
    A1     =start(50);
    A2     =start(51);
    a1     =start(52);
    a2     =start(53);
    B1     =start(54);
    B2     =start(55);
    b1     =start(56);
    b2     =start(57);
    X1     =start(58);
    X2     =start(59);
    x1     =start(60);
    x2     =start(61);
    AR1    =start(62);
    AR2    =start(63);
    ar1    =start(64);
    ar2    =start(65);
   
    i=i+1;
end;
end;

store_s(:,z)=start';
store_n(:,z)=new';
tau1=tau1+0.05;
tau2=tau2+0.05;

end;

delete C:\Redding\Matlab\HoHetSimsT\costly_output.out;
diary('C:\Redding\Matlab\HoHetSimsT\costly_output.out');

     disp('Solution vector')
     disp('Trade costs')
     tau1
     tau2
     disp('Labor market outcomes')
     Ws
     Wl
     wl
     ws
     L1
     L2
     S1
     S2
     l1
     l2
     s1
     s2
     disp('Check for labor market equilibrium')
     disp('home')
     Wscheck=(beta1*R1 + beta2*R2)/S
     Wlcheck=((1-beta1)*R1 + (1-beta2)*R2)/L
     Scheck=(beta1*R1)/Ws + (beta2*R2)/Ws
     Lcheck=((1-beta1)*R1)/Wl + ((1-beta2)*R2)/Wl
     disp('foreign')
     wscheck=(beta1*r1 + beta2*r2)/s
     wlcheck=((1-beta1)*r1 + (1-beta2)*r2)/l
     scheck=(beta1*r1)/ws + (beta2*r2)/ws
     lcheck=((1-beta1)*r1)/wl + ((1-beta2)*r2)/wl
     disp('Product market prices')
     Q1
     Q2
     q1
     q2
     P1
     P2
     p1
     p2
     disp('Expenditure')
     E1
     E2
     e1
     e2
     G1
     G2
     g1
     g2
     disp('Revenue')
     R1
     R2
     r1
     r2
     r
     R
     disp('Check income equals expenditure')
     Y1=Ws*S1+Wl*L1
     R1
     Y2=Ws*S2+Wl*L2
     R2
     y1=ws*s1+wl*l1
     r1
     y2=ws*s2+wl*l2
     r2
     Y=Ws*S+Wl*L
     R
     y=ws*s+wl*l
     r
     disp('Mass of firms')
     M1
     M2
     m1
     m2
     disp('Free entry and productivity cutoffs')
     LAMBDA1
     LAMBDA2
     lambda1
     lambda2
     PHI1
     PHI2
     phi1
     phi2
     PSI1
     PSI2
     psi1
     psi2
     disp('Average productivity, probability of exporting and average firm revenue')
     A1
     A2
     a1
     a2
     B1
     B2
     b1
     b2
     X1
     X2
     x1
     x2
     AR1
     AR2
     ar1
     ar2

format bank;
test=store_s-store_n;
maxtest=max(test);
maxtest=max(maxtest)
format long;

% Generate extra variables needed for graphs;

% Average output;
% Average revenue divided by average variety prices;

AOUT1=store_n(62,:)./store_n(12,:);
AOUT2=store_n(63,:)./store_n(13,:);
aout1=store_n(64,:)./store_n(14,:);
aout2=store_n(65,:)./store_n(15,:);

% Mass of entrants;

ME1=delta .* (store_n(42,:)./k).^c .* store_n(34,:);
ME2=delta .* (store_n(43,:)./k).^c .* store_n(35,:);
me1=delta .* (store_n(44,:)./k).^c .* store_n(36,:);
me2=delta .* (store_n(45,:)./k).^c .* store_n(37,:);

% Revenue;

R1=store_n(28,:);
R2=store_n(29,:);
R=R1+R2;

% Welfare;

P1=store_n(16,:);
P2=store_n(17,:);
p1=store_n(18,:);
p2=store_n(19,:);
CPI=(P1.^(alpha)).*(P2.^(1-alpha));
cpi=(p1.^(alpha)).*(p2.^(1-alpha));
WELF=R./CPI;
welf=r./cpi;

% Volume of trade;

VOL1  = store_n(26,:) + store_n(24,:);       % g1+G1;
VOL2  = store_n(27,:) + store_n(25,:);       % g2+G2;
VOL=VOL1+VOL2;
TGDP=VOL./R;
INTER1= store_n(26,:) - store_n(24,:);       % g1-G1;
INTER2= store_n(27,:) - store_n(25,:);       % g2-G2;
INTRA1= min(store_n(26,:),store_n(24,:));    % min(g1,G1);
INTRA2= min(store_n(27,:),store_n(25,:));    % min(g2,G2);
EXPORTS1=store_n(26,:);                      % g1;
EXPORTS2=store_n(27,:);                      % g2;
IMPORTS1=store_n(24,:);                      % G1;
IMPORTS2=store_n(25,:);                      % G2;
MS=(beta1.*-INTER1./1)+(beta2.*-INTER2./1);                                 % Net skill content of home imports;
ML=((1-beta1).*-INTER1./store_n(1,:))+((1-beta2).*-INTER2./store_n(1,:));   % Net labor content of home imports;
ms=(beta1.*INTER1./store_n(3,:))+(beta2.*INTER2./store_n(3,:));             % Net skill content of foreign imports;
ml=((1-beta1).*INTER1./store_n(2,:))+((1-beta2).*INTER2./store_n(2,:));     % Net labor content of foreign imports;

% Relative wage;

WREL=1./store_n(1,:);
wrel=store_n(3,:)./store_n(2,:);

diary('off');

% ***********************;
% **** Save the data ****;
% ***********************;

Ws=Ws.*vecones;
names={'Converge' 'tau1' 'tau2' 'ME1' 'ME2' 'me1' 'me2' 'CPI' 'cpi' 'Ws' 'Wl' 'wl' 'ws' 'L1' 'L2' 'S1' 'S2' 'l1' 'l2' 's1' 's2' 'Q1' 'Q2' 'q1' 'q2' 'P1' 'P2' 'p1' 'p2' 'E1' 'E2' 'e1' 'e2' 'G1' 'G2' 'g1' 'g2' 'R1' 'R2' 'r1' 'r2' 'R' 'r' 'M1' 'M2' 'm1' 'm2' 'LAMBDA1' 'LAMBDA2' 'lambda1' 'lambda2' 'PHI1' 'PHI2' 'phi1' 'phi2' 'PSI1' 'PSI2' 'psi1' 'psi2' 'A1' 'A2' 'a1' 'a2' 'B1' 'B2' 'b1' 'b2' 'X1' 'X2' 'x1' 'x2' 'AR1' 'AR2' 'ar1' 'ar2' 'AOUT1' 'AOUT2' 'aout1' 'aout2'};
names=names';
data=vertcat(aout1,aout2);
data=vertcat(AOUT2,data);
data=vertcat(AOUT1,data);
data=vertcat(store_n,data);
data=vertcat(Ws,data);
data=vertcat(cpi,data);
data=vertcat(CPI,data);
data=vertcat(me2,data);
data=vertcat(me1,data);
data=vertcat(ME2,data);
data=vertcat(ME1,data);
data=vertcat(tau2value,data);
data=vertcat(tau1value,data);
data=vertcat(converge,data);
delete C:\Redding\Matlab\HoHetSimsT\costlysims.txt;
save 'C:\Redding\Matlab\HoHetSimsT\costlysims.txt' data -ASCII;
delete C:\Redding\Matlab\HoHetSimsT\costlynames.out;
diary('C:\Redding\Matlab\HoHetSimsT\costlynames.out');
names
diary('off');

tradenames={'Converge' 'tau1' 'tau2' 'A1' 'A2' 'a1' 'a2' 'WELFARE' 'TRADETOGDP' 'VOL' 'VOLUME1' 'VOLUME2' 'INTERINDUSTRY1' 'INTERINDUSTRY2' 'INTRAINDUSTRY1' 'INTRAINDUSTRY2' 'MS' 'ML' 'ms' 'ml' 'Ws' 'Wl' 'wl' 'ws'};
tradenames=tradenames';
tradedata=vertcat(store_n(1,:),store_n(2,:),store_n(3,:));
tradedata=vertcat(Ws,tradedata);
tradedata=vertcat(ms,ml,tradedata);
tradedata=vertcat(MS,ML,tradedata);
tradedata=vertcat(INTRA1,INTRA2,tradedata);
tradedata=vertcat(INTER1,INTER2,tradedata);
tradedata=vertcat(VOL1,VOL2,tradedata);
tradedata=vertcat(VOL,tradedata);
tradedata=vertcat(WELF,TGDP,tradedata);
tradedata=vertcat(store_n(52,:),store_n(53,:),tradedata);
tradedata=vertcat(store_n(50,:),store_n(51,:),tradedata);
tradedata=vertcat(tau1value,tau2value,tradedata);
tradedata=vertcat(converge,tradedata);
delete C:\Redding\Matlab\HoHetSimsT\tradedata.txt;
save 'C:\Redding\Matlab\HoHetSimsT\tradedata.txt' tradedata -ASCII;
delete C:\Redding\Matlab\HoHetSimsT\tradenames.out;
diary('C:\Redding\Matlab\HoHetSimsT\tradenames.out');
tradenames
diary('off');