* Figure A1
use occreg.dta, clear
keep if subinstr(v1, "occd", "", .) != v1 | subinstr(v1[_n-1], "occd", "", .) != v1[_n-1]
drop v2
ren v3 d1880
ren v4 d1900
ren v5 d1920
ren v6 d1940
ren v7 d1960
ren v8 d1980
ren v9 d2000
foreach var of varlist d* {
replace `var' = subinstr(`var', "(", "", .)
replace `var' = subinstr(`var', ")", "", .)
replace `var' = subinstr(`var', "*", "", .)
}
replace v1 = v1[_n-1] if v1==""
gen a = _n
replace a = a-2 if _n >2
replace a = a-2 if _n >4
replace a = a-2 if _n >6
replace a = a-2 if _n >8
replace a = a-2 if _n >10
replace a = a-2 if _n >12
replace a = a-2 if _n >14
reshape wide d*, i(v1) j(a)
foreach num of numlist 1880 1900 1920 1940 1960 1980 2000 {
destring d`num'1, replace
destring d`num'2, replace
egen a = mean(d`num'1)
replace d`num'1 = d`num'1 - a
drop a
gen lci`num' = d`num'1 - 1.96*d`num'2
gen uci`num' = d`num'1 + 1.96*d`num'2
drop d`num'2
ren d`num'1 d`num'
}
reshape long lci uci d, i(v1) j(year)
gen v2 = ""
replace v2 = "Professional, Technical" if v1 == "occd6"
replace v2 = "Managers, Officials, and Proprietors" if v1 == "occd4"
replace v2 = "Clerical and Kindred" if v1 == "occd1"
replace v2 = "Sales workers" if v1 == "occd7"
replace v2 = "Craftsmen" if v1 == "occd2"
replace v2 = "Operatives" if v1 == "occd5"
replace v2 = "Service Workers" if v1 == "occd8"
replace v2 = "Laborers" if v1 == "occd3"
replace v2 = "Mining" if v1=="indd6"
replace v2 = "Construction" if v1=="indd2"
replace v2 = "Manufacturing" if v1=="indd5"
replace v2 = "Transportation, Communication, and Other Utilities" if v1=="indd10"
replace v2 = "Wholesale and Retail Trade" if v1=="indd11"
replace v2 = "Finance, Insurance, and Real Estate" if v1=="indd4"
replace v2 = "Business and Repair Services" if v1=="indd1"
replace v2 = "Personal Services" if v1=="indd7"
replace v2 = "Entertainment and Recreation Services" if v1=="indd3"
replace v2 = "Professional and Related Services" if v1=="indd8"
replace v2 = "Public Administration" if v1=="indd9"
foreach num of numlist 1(1)8 {
gen a = v1=="occd`num'"
gsort - a
local b = v2
so year
twoway(line d lci uci year if v1=="occd`num'", xtitle("") graphregion(fcolor(white)) clcolor(black black black) clwidth(thick thin thin) clpattern(solid dash dash) title("`b'") legend(off) xlab(1880 1920 1960 2000) ylab(-0.6 (0.3) 0.3)), name(g`num', replace)
drop a
}
graph combine g1 g2 g3 g4 g5 g6 g7 g8, graphregion(fcolor(white)) title("Figure A1: Metro Area Specialization for Aggregate Occupations", size(medium)) iscale(0.5) note("Notes: Coefficients estimated from a regression of an indicator variable for whether a worker is located in a metro area on occupation-year and" "sector-year fixed effects (equation (1) in the paper). Occupation-year and sector-year fixed effects are each normalized to sum to zero in each" "year. A separate regression is estimated for each year.", size(vsmall))

