
use panel_decomposition_metro, clear
collapse (sum) measure*, by(year)
so year
replace year = year+20
twoway(line measureClerical measureCraftsmen measureOperatives measureSalesW year, graphregion(fcolor(white)) clwidth(thick thick thick thick) clpattern(solid dash solid dash) clcolor(black black gs8 gs8) legend(order(1 2 3 4) lab(1 "Clerical and Kindred") lab(2 "Craftsmen") lab(3 "Operatives") lab(4 "Sales Workers")) title("Panel A") ylab(-0.04(0.02)0.06) xtitle("20-year difference") ytitle("Interactiveness")), name(pa, replace)
twoway(line measureServiceW measureManagers measureProfessional measureLaborers year, graphregion(fcolor(white)) clwidth(thick thick thick thick) clpattern(solid dash solid dash) clcolor(black black gs8 gs8) legend(order(1 2 3 4) lab(1 "Service Workers") lab(2 "Mangers") lab(3 "Professionals") lab(4 "Laborers")) title("Panel B") ylab(-0.04(0.02)0.06) xtitle("20-year difference") ytitle("Interactiveness")), name(pb, replace)

use panel_decomposition_metro, clear
gen a = 0
foreach var of varlist measure* {
replace `var' = 0 if `var' ==.
replace a = a + `var'
}
replace b = "BusinessServices" if b =="Business and Repair Services"
replace b = "Construction" if b =="Construction"
replace b = "Entertainment" if b =="Entertainment and Recreation Services"
replace b = "Finance" if b =="Finance, Insurance, and Real Estate"
replace b = "Manufacturing" if b =="Manufacturing"
replace b = "Mining" if b =="Mining"
replace b = "PersonalServices" if b =="Personal Services"
replace b = "ProfessionalServices" if b =="Professional and Related Services"
replace b = "PublicAdministration" if b =="Public Administration"
replace b = "TransportationCommunication" if b =="Transportation, Communication, and Other Utilities"
replace b = "Trade" if b =="Wholesale and Retail Trade"
keep a b year
reshape wide a, i(year) j(b) string
replace year = year+20
twoway(line aBusinessServices aConstruction aEntertainment aFinance aManufacturing aMining year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) legend(order(1 2 3 4 5 6) lab(1 "Business") lab(2 "Construction") lab(3 "Entertainment") lab(4 "Finance") lab(5 "Manufacturing") lab(6 "Mining")) title("Panel C") ylab(-0.04(0.02)0.04) xtitle("20-year difference") ytitle("Interactiveness")), name(pc, replace)
twoway(line aPersonalServices aProfessionalServices aPublicAdministration aTrade aTransportationCommunication year, graphregion(fcolor(white)) clwidth(thick thick thick thick medium medium) clpattern(solid dash solid dash solid dash) clcolor(black black gs8 gs8 black black) legend(order(1 2 3 4 5) lab(1 "Personal") lab(2 "Professional") lab(3 "Public Admin") lab(4 "Trade") lab(5 "Transportation")) title("Panel D") ylab(-0.04(0.02)0.04) xtitle("20-year difference") ytitle("Interactiveness")), name(pd, replace)
graph combine pa pb pc pd, iscale(0.6) graphregion(fcolor(white)) title("Figure A6: Decomposition of the Change in Mean" "Interactiveness in Metro Areas", size(medium)) note("Notes: Decomposition of the change in mean interactiveness in metro areas (equation (25) in the paper) into the contributions of two-digit" "occupations and sectors. Mean interactiveness based on time-invariant occupational descriptions from the 1991 DOTs.", size(vsmall))
